% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_get_exclusions_preview}
\alias{inspector_get_exclusions_preview}
\title{Retrieves the exclusions preview (a list of ExclusionPreview objects)
specified by the preview token}
\usage{
inspector_get_exclusions_preview(assessmentTemplateArn, previewToken,
  nextToken, maxResults, locale)
}
\arguments{
\item{assessmentTemplateArn}{[required] The ARN that specifies the assessment template for which the exclusions
preview was requested.}

\item{previewToken}{[required] The unique identifier associated of the exclusions preview.}

\item{nextToken}{You can use this parameter when paginating results. Set the value of
this parameter to null on your first call to the
GetExclusionsPreviewRequest action. Subsequent calls to the action fill
nextToken in the request with the value of nextToken from the previous
response to continue listing data.}

\item{maxResults}{You can use this parameter to indicate the maximum number of items you
want in the response. The default value is 100. The maximum value is
500.}

\item{locale}{The locale into which you want to translate the exclusion's title,
description, and recommendation.}
}
\value{
A list with the following syntax:\preformatted{list(
  previewStatus = "WORK_IN_PROGRESS"|"COMPLETED",
  exclusionPreviews = list(
    list(
      title = "string",
      description = "string",
      recommendation = "string",
      scopes = list(
        list(
          key = "INSTANCE_ID"|"RULES_PACKAGE_ARN",
          value = "string"
        )
      ),
      attributes = list(
        list(
          key = "string",
          value = "string"
        )
      )
    )
  ),
  nextToken = "string"
)
}
}
\description{
Retrieves the exclusions preview (a list of ExclusionPreview objects)
specified by the preview token. You can obtain the preview token by
running the CreateExclusionsPreview API.
}
\section{Request syntax}{
\preformatted{svc$get_exclusions_preview(
  assessmentTemplateArn = "string",
  previewToken = "string",
  nextToken = "string",
  maxResults = 123,
  locale = "EN_US"
)
}
}

\keyword{internal}
