% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_describe_resource_groups}
\alias{inspector_describe_resource_groups}
\title{Describes the resource groups that are specified by the ARNs of the
resource groups}
\usage{
inspector_describe_resource_groups(resourceGroupArns)
}
\arguments{
\item{resourceGroupArns}{[required] The ARN that specifies the resource group that you want to describe.}
}
\value{
A list with the following syntax:\preformatted{list(
  resourceGroups = list(
    list(
      arn = "string",
      tags = list(
        list(
          key = "string",
          value = "string"
        )
      ),
      createdAt = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  failedItems = list(
    list(
      failureCode = "INVALID_ARN"|"DUPLICATE_ARN"|"ITEM_DOES_NOT_EXIST"|"ACCESS_DENIED"|"LIMIT_EXCEEDED"|"INTERNAL_ERROR",
      retryable = TRUE|FALSE
    )
  )
)
}
}
\description{
Describes the resource groups that are specified by the ARNs of the
resource groups.
}
\section{Request syntax}{
\preformatted{svc$describe_resource_groups(
  resourceGroupArns = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# Describes the resource groups that are specified by the ARNs of the
# resource groups.
svc$describe_resource_groups(
  resourceGroupArns = list(
    "arn:aws:inspector:us-west-2:123456789012:resourcegroup/0-PyGXopAI"
  )
)
}

}
\keyword{internal}
