% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_delete_server_certificate}
\alias{iam_delete_server_certificate}
\title{Deletes the specified server certificate}
\usage{
iam_delete_server_certificate(ServerCertificateName)
}
\arguments{
\item{ServerCertificateName}{[required] The name of the server certificate you want to delete.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}
}
\value{
An empty list.
}
\description{
Deletes the specified server certificate.

For more information about working with server certificates, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html}{Working with Server Certificates}
in the \emph{IAM User Guide}. This topic also includes a list of AWS services
that can use the server certificates that you manage with IAM.

If you are using a server certificate with Elastic Load Balancing,
deleting the certificate could have implications for your application.
If Elastic Load Balancing doesn't detect the deletion of bound
certificates, it may continue to use the certificates. This could cause
Elastic Load Balancing to stop accepting traffic. We recommend that you
remove the reference to the certificate from Elastic Load Balancing
before using this command to delete the certificate. For more
information, go to
\href{https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DeleteLoadBalancerListeners.html}{DeleteLoadBalancerListeners}
in the \emph{Elastic Load Balancing API Reference}.
}
\section{Request syntax}{
\preformatted{svc$delete_server_certificate(
  ServerCertificateName = "string"
)
}
}

\keyword{internal}
