% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_list_aliases}
\alias{kms_list_aliases}
\title{Gets a list of all aliases in the caller's AWS account and region}
\usage{
kms_list_aliases(KeyId, Limit, Marker)
}
\arguments{
\item{KeyId}{Lists only aliases that refer to the specified CMK. The value of this
parameter can be the ID or Amazon Resource Name (ARN) of a CMK in the
caller's account and region. You cannot use an alias name or alias ARN
in this value.

This parameter is optional. If you omit it, \code{ListAliases} returns all
aliases in the account and region.}

\item{Limit}{Use this parameter to specify the maximum number of items to return.
When this value is present, AWS KMS does not return more than the
specified number of items, but it might return fewer.

This value is optional. If you include a value, it must be between 1 and
100, inclusive. If you do not include a value, it defaults to 50.}

\item{Marker}{Use this parameter in a subsequent request after you receive a response
with truncated results. Set it to the value of \code{NextMarker} from the
truncated response you just received.}
}
\description{
Gets a list of all aliases in the caller's AWS account and region. You
cannot list aliases in other accounts. For more information about
aliases, see CreateAlias.
}
\details{
By default, the \code{ListAliases} command returns all aliases in the account
and region. To get only the aliases that point to a particular customer
master key (CMK), use the \code{KeyId} parameter.

The \code{ListAliases} response might include several aliases have no
\code{TargetKeyId} field. These are predefined aliases that AWS has created
but has not yet associated with a CMK. Aliases that AWS creates in your
account, including predefined aliases, do not count against your \href{http://docs.aws.amazon.com/kms/latest/developerguide/limits.html#aliases-limit}{AWS KMS aliases limit}.
}
\section{Request syntax}{
\preformatted{svc$list_aliases(
  KeyId = "string",
  Limit = 123,
  Marker = "string"
)
}
}

\examples{
# The following example lists aliases.
\donttest{svc$list_aliases()}

}
\keyword{internal}
