# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include vpclattice_service.R
NULL

#' Updates the listener rules in a batch
#'
#' @description
#' Updates the listener rules in a batch. You can use this operation to change the priority of listener rules. This can be useful when bulk updating or swapping rule priority.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_batch_update_rule/](https://www.paws-r-sdk.com/docs/vpclattice_batch_update_rule/) for full documentation.
#'
#' @param listenerIdentifier &#91;required&#93; The ID or ARN of the listener.
#' @param rules &#91;required&#93; The rules for the specified listener.
#' @param serviceIdentifier &#91;required&#93; The ID or ARN of the service.
#'
#' @keywords internal
#'
#' @rdname vpclattice_batch_update_rule
vpclattice_batch_update_rule <- function(listenerIdentifier, rules, serviceIdentifier) {
  op <- new_operation(
    name = "BatchUpdateRule",
    http_method = "PATCH",
    http_path = "/services/{serviceIdentifier}/listeners/{listenerIdentifier}/rules",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$batch_update_rule_input(listenerIdentifier = listenerIdentifier, rules = rules, serviceIdentifier = serviceIdentifier)
  output <- .vpclattice$batch_update_rule_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$batch_update_rule <- vpclattice_batch_update_rule

#' Enables access logs to be sent to Amazon CloudWatch, Amazon S3, and
#' Amazon Kinesis Data Firehose
#'
#' @description
#' Enables access logs to be sent to Amazon CloudWatch, Amazon S3, and Amazon Kinesis Data Firehose. The service network owner can use the access logs to audit the services in the network. The service network owner can only see access logs from clients and services that are associated with their service network. Access log entries represent traffic originated from VPCs associated with that network. For more information, see [Access logs](https://docs.aws.amazon.com/vpc-lattice/latest/ug/monitoring-access-logs.html) in the *Amazon VPC Lattice User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_create_access_log_subscription/](https://www.paws-r-sdk.com/docs/vpclattice_create_access_log_subscription/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you retry a request that completed
#' successfully using the same client token and parameters, the retry
#' succeeds without performing any actions. If the parameters aren't
#' identical, the retry fails.
#' @param destinationArn &#91;required&#93; The Amazon Resource Name (ARN) of the destination. The supported
#' destination types are CloudWatch Log groups, Kinesis Data Firehose
#' delivery streams, and Amazon S3 buckets.
#' @param resourceIdentifier &#91;required&#93; The ID or ARN of the service network or service.
#' @param serviceNetworkLogType The type of log that monitors your Amazon VPC Lattice service networks.
#' @param tags The tags for the access log subscription.
#'
#' @keywords internal
#'
#' @rdname vpclattice_create_access_log_subscription
vpclattice_create_access_log_subscription <- function(clientToken = NULL, destinationArn, resourceIdentifier, serviceNetworkLogType = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateAccessLogSubscription",
    http_method = "POST",
    http_path = "/accesslogsubscriptions",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$create_access_log_subscription_input(clientToken = clientToken, destinationArn = destinationArn, resourceIdentifier = resourceIdentifier, serviceNetworkLogType = serviceNetworkLogType, tags = tags)
  output <- .vpclattice$create_access_log_subscription_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$create_access_log_subscription <- vpclattice_create_access_log_subscription

#' Creates a listener for a service
#'
#' @description
#' Creates a listener for a service. Before you start using your Amazon VPC Lattice service, you must add one or more listeners. A listener is a process that checks for connection requests to your services. For more information, see [Listeners](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html) in the *Amazon VPC Lattice User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_create_listener/](https://www.paws-r-sdk.com/docs/vpclattice_create_listener/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you retry a request that completed
#' successfully using the same client token and parameters, the retry
#' succeeds without performing any actions. If the parameters aren't
#' identical, the retry fails.
#' @param defaultAction &#91;required&#93; The action for the default rule. Each listener has a default rule. The
#' default rule is used if no other rules match.
#' @param name &#91;required&#93; The name of the listener. A listener name must be unique within a
#' service. The valid characters are a-z, 0-9, and hyphens (-). You can't
#' use a hyphen as the first or last character, or immediately after
#' another hyphen.
#' @param port The listener port. You can specify a value from 1 to 65535. For HTTP,
#' the default is 80. For HTTPS, the default is 443.
#' @param protocol &#91;required&#93; The listener protocol.
#' @param serviceIdentifier &#91;required&#93; The ID or ARN of the service.
#' @param tags The tags for the listener.
#'
#' @keywords internal
#'
#' @rdname vpclattice_create_listener
vpclattice_create_listener <- function(clientToken = NULL, defaultAction, name, port = NULL, protocol, serviceIdentifier, tags = NULL) {
  op <- new_operation(
    name = "CreateListener",
    http_method = "POST",
    http_path = "/services/{serviceIdentifier}/listeners",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$create_listener_input(clientToken = clientToken, defaultAction = defaultAction, name = name, port = port, protocol = protocol, serviceIdentifier = serviceIdentifier, tags = tags)
  output <- .vpclattice$create_listener_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$create_listener <- vpclattice_create_listener

#' Creates a resource configuration
#'
#' @description
#' Creates a resource configuration. A resource configuration defines a specific resource. You can associate a resource configuration with a service network or a VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_create_resource_configuration/](https://www.paws-r-sdk.com/docs/vpclattice_create_resource_configuration/) for full documentation.
#'
#' @param allowAssociationToShareableServiceNetwork (SINGLE, GROUP, ARN) Specifies whether the resource configuration can be
#' associated with a sharable service network. The default is false.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you retry a request that completed
#' successfully using the same client token and parameters, the retry
#' succeeds without performing any actions. If the parameters aren't
#' identical, the retry fails.
#' @param name &#91;required&#93; The name of the resource configuration. The name must be unique within
#' the account. The valid characters are a-z, 0-9, and hyphens (-). You
#' can't use a hyphen as the first or last character, or immediately after
#' another hyphen.
#' @param portRanges (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to
#' access a resource configuration (for example: 1-65535). You can separate
#' port ranges using commas (for example: 1,2,22-30).
#' @param protocol (SINGLE, GROUP) The protocol accepted by the resource configuration.
#' @param resourceConfigurationDefinition (SINGLE, CHILD, ARN) The resource configuration.
#' @param resourceConfigurationGroupIdentifier (CHILD) The ID or ARN of the parent resource configuration (type is
#' `GROUP`). This is used to associate a child resource configuration with
#' a group resource configuration.
#' @param resourceGatewayIdentifier (SINGLE, GROUP, ARN) The ID or ARN of the resource gateway used to
#' connect to the resource configuration. For a child resource
#' configuration, this value is inherited from the parent resource
#' configuration.
#' @param tags The tags for the resource configuration.
#' @param type &#91;required&#93; The type of resource configuration.
#' 
#' -   `SINGLE` - A single resource.
#' 
#' -   `GROUP` - A group of resources. You must create a group resource
#'     configuration before you create a child resource configuration.
#' 
#' -   `CHILD` - A single resource that is part of a group resource
#'     configuration.
#' 
#' -   `ARN` - An Amazon Web Services resource.
#'
#' @keywords internal
#'
#' @rdname vpclattice_create_resource_configuration
vpclattice_create_resource_configuration <- function(allowAssociationToShareableServiceNetwork = NULL, clientToken = NULL, name, portRanges = NULL, protocol = NULL, resourceConfigurationDefinition = NULL, resourceConfigurationGroupIdentifier = NULL, resourceGatewayIdentifier = NULL, tags = NULL, type) {
  op <- new_operation(
    name = "CreateResourceConfiguration",
    http_method = "POST",
    http_path = "/resourceconfigurations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$create_resource_configuration_input(allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork, clientToken = clientToken, name = name, portRanges = portRanges, protocol = protocol, resourceConfigurationDefinition = resourceConfigurationDefinition, resourceConfigurationGroupIdentifier = resourceConfigurationGroupIdentifier, resourceGatewayIdentifier = resourceGatewayIdentifier, tags = tags, type = type)
  output <- .vpclattice$create_resource_configuration_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$create_resource_configuration <- vpclattice_create_resource_configuration

#' Creates a resource gateway
#'
#' @description
#' Creates a resource gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_create_resource_gateway/](https://www.paws-r-sdk.com/docs/vpclattice_create_resource_gateway/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you retry a request that completed
#' successfully using the same client token and parameters, the retry
#' succeeds without performing any actions. If the parameters aren't
#' identical, the retry fails.
#' @param ipAddressType The type of IP address used by the resource gateway.
#' @param name &#91;required&#93; The name of the resource gateway.
#' @param securityGroupIds The IDs of the security groups to apply to the resource gateway. The
#' security groups must be in the same VPC.
#' @param subnetIds &#91;required&#93; The IDs of the VPC subnets in which to create the resource gateway.
#' @param tags The tags for the resource gateway.
#' @param vpcIdentifier &#91;required&#93; The ID of the VPC for the resource gateway.
#'
#' @keywords internal
#'
#' @rdname vpclattice_create_resource_gateway
vpclattice_create_resource_gateway <- function(clientToken = NULL, ipAddressType = NULL, name, securityGroupIds = NULL, subnetIds, tags = NULL, vpcIdentifier) {
  op <- new_operation(
    name = "CreateResourceGateway",
    http_method = "POST",
    http_path = "/resourcegateways",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$create_resource_gateway_input(clientToken = clientToken, ipAddressType = ipAddressType, name = name, securityGroupIds = securityGroupIds, subnetIds = subnetIds, tags = tags, vpcIdentifier = vpcIdentifier)
  output <- .vpclattice$create_resource_gateway_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$create_resource_gateway <- vpclattice_create_resource_gateway

#' Creates a listener rule
#'
#' @description
#' Creates a listener rule. Each listener has a default rule for checking connection requests, but you can define additional rules. Each rule consists of a priority, one or more actions, and one or more conditions. For more information, see [Listener rules](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules) in the *Amazon VPC Lattice User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_create_rule/](https://www.paws-r-sdk.com/docs/vpclattice_create_rule/) for full documentation.
#'
#' @param action &#91;required&#93; The action for the default rule.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you retry a request that completed
#' successfully using the same client token and parameters, the retry
#' succeeds without performing any actions. If the parameters aren't
#' identical, the retry fails.
#' @param listenerIdentifier &#91;required&#93; The ID or ARN of the listener.
#' @param match &#91;required&#93; The rule match.
#' @param name &#91;required&#93; The name of the rule. The name must be unique within the listener. The
#' valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen
#' as the first or last character, or immediately after another hyphen.
#' @param priority &#91;required&#93; The priority assigned to the rule. Each rule for a specific listener
#' must have a unique priority. The lower the priority number the higher
#' the priority.
#' @param serviceIdentifier &#91;required&#93; The ID or ARN of the service.
#' @param tags The tags for the rule.
#'
#' @keywords internal
#'
#' @rdname vpclattice_create_rule
vpclattice_create_rule <- function(action, clientToken = NULL, listenerIdentifier, match, name, priority, serviceIdentifier, tags = NULL) {
  op <- new_operation(
    name = "CreateRule",
    http_method = "POST",
    http_path = "/services/{serviceIdentifier}/listeners/{listenerIdentifier}/rules",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$create_rule_input(action = action, clientToken = clientToken, listenerIdentifier = listenerIdentifier, match = match, name = name, priority = priority, serviceIdentifier = serviceIdentifier, tags = tags)
  output <- .vpclattice$create_rule_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$create_rule <- vpclattice_create_rule

#' Creates a service
#'
#' @description
#' Creates a service. A service is any software application that can run on instances containers, or serverless functions within an account or virtual private cloud (VPC).
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_create_service/](https://www.paws-r-sdk.com/docs/vpclattice_create_service/) for full documentation.
#'
#' @param authType The type of IAM policy.
#' 
#' -   `NONE`: The resource does not use an IAM policy. This is the
#'     default.
#' 
#' -   `AWS_IAM`: The resource uses an IAM policy. When this type is used,
#'     auth is enabled and an auth policy is required.
#' @param certificateArn The Amazon Resource Name (ARN) of the certificate.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you retry a request that completed
#' successfully using the same client token and parameters, the retry
#' succeeds without performing any actions. If the parameters aren't
#' identical, the retry fails.
#' @param customDomainName The custom domain name of the service.
#' @param name &#91;required&#93; The name of the service. The name must be unique within the account. The
#' valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen
#' as the first or last character, or immediately after another hyphen.
#' @param tags The tags for the service.
#'
#' @keywords internal
#'
#' @rdname vpclattice_create_service
vpclattice_create_service <- function(authType = NULL, certificateArn = NULL, clientToken = NULL, customDomainName = NULL, name, tags = NULL) {
  op <- new_operation(
    name = "CreateService",
    http_method = "POST",
    http_path = "/services",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$create_service_input(authType = authType, certificateArn = certificateArn, clientToken = clientToken, customDomainName = customDomainName, name = name, tags = tags)
  output <- .vpclattice$create_service_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$create_service <- vpclattice_create_service

#' Creates a service network
#'
#' @description
#' Creates a service network. A service network is a logical boundary for a collection of services. You can associate services and VPCs with a service network.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_create_service_network/](https://www.paws-r-sdk.com/docs/vpclattice_create_service_network/) for full documentation.
#'
#' @param authType The type of IAM policy.
#' 
#' -   `NONE`: The resource does not use an IAM policy. This is the
#'     default.
#' 
#' -   `AWS_IAM`: The resource uses an IAM policy. When this type is used,
#'     auth is enabled and an auth policy is required.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you retry a request that completed
#' successfully using the same client token and parameters, the retry
#' succeeds without performing any actions. If the parameters aren't
#' identical, the retry fails.
#' @param name &#91;required&#93; The name of the service network. The name must be unique to the account.
#' The valid characters are a-z, 0-9, and hyphens (-). You can't use a
#' hyphen as the first or last character, or immediately after another
#' hyphen.
#' @param sharingConfig Specify if the service network should be enabled for sharing.
#' @param tags The tags for the service network.
#'
#' @keywords internal
#'
#' @rdname vpclattice_create_service_network
vpclattice_create_service_network <- function(authType = NULL, clientToken = NULL, name, sharingConfig = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateServiceNetwork",
    http_method = "POST",
    http_path = "/servicenetworks",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$create_service_network_input(authType = authType, clientToken = clientToken, name = name, sharingConfig = sharingConfig, tags = tags)
  output <- .vpclattice$create_service_network_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$create_service_network <- vpclattice_create_service_network

#' Associates the specified service network with the specified resource
#' configuration
#'
#' @description
#' Associates the specified service network with the specified resource configuration. This allows the resource configuration to receive connections through the service network, including through a service network VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_create_service_network_resource_association/](https://www.paws-r-sdk.com/docs/vpclattice_create_service_network_resource_association/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you retry a request that completed
#' successfully using the same client token and parameters, the retry
#' succeeds without performing any actions. If the parameters aren't
#' identical, the retry fails.
#' @param resourceConfigurationIdentifier &#91;required&#93; The ID of the resource configuration to associate with the service
#' network.
#' @param serviceNetworkIdentifier &#91;required&#93; The ID of the service network to associate with the resource
#' configuration.
#' @param tags The tags for the association.
#'
#' @keywords internal
#'
#' @rdname vpclattice_create_service_network_resource_association
vpclattice_create_service_network_resource_association <- function(clientToken = NULL, resourceConfigurationIdentifier, serviceNetworkIdentifier, tags = NULL) {
  op <- new_operation(
    name = "CreateServiceNetworkResourceAssociation",
    http_method = "POST",
    http_path = "/servicenetworkresourceassociations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$create_service_network_resource_association_input(clientToken = clientToken, resourceConfigurationIdentifier = resourceConfigurationIdentifier, serviceNetworkIdentifier = serviceNetworkIdentifier, tags = tags)
  output <- .vpclattice$create_service_network_resource_association_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$create_service_network_resource_association <- vpclattice_create_service_network_resource_association

#' Associates the specified service with the specified service network
#'
#' @description
#' Associates the specified service with the specified service network. For more information, see [Manage service associations](https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-service-associations) in the *Amazon VPC Lattice User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_create_service_network_service_association/](https://www.paws-r-sdk.com/docs/vpclattice_create_service_network_service_association/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you retry a request that completed
#' successfully using the same client token and parameters, the retry
#' succeeds without performing any actions. If the parameters aren't
#' identical, the retry fails.
#' @param serviceIdentifier &#91;required&#93; The ID or ARN of the service.
#' @param serviceNetworkIdentifier &#91;required&#93; The ID or ARN of the service network. You must use an ARN if the
#' resources are in different accounts.
#' @param tags The tags for the association.
#'
#' @keywords internal
#'
#' @rdname vpclattice_create_service_network_service_association
vpclattice_create_service_network_service_association <- function(clientToken = NULL, serviceIdentifier, serviceNetworkIdentifier, tags = NULL) {
  op <- new_operation(
    name = "CreateServiceNetworkServiceAssociation",
    http_method = "POST",
    http_path = "/servicenetworkserviceassociations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$create_service_network_service_association_input(clientToken = clientToken, serviceIdentifier = serviceIdentifier, serviceNetworkIdentifier = serviceNetworkIdentifier, tags = tags)
  output <- .vpclattice$create_service_network_service_association_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$create_service_network_service_association <- vpclattice_create_service_network_service_association

#' Associates a VPC with a service network
#'
#' @description
#' Associates a VPC with a service network. When you associate a VPC with the service network, it enables all the resources within that VPC to be clients and communicate with other services in the service network. For more information, see [Manage VPC associations](https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-vpc-associations) in the *Amazon VPC Lattice User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_create_service_network_vpc_association/](https://www.paws-r-sdk.com/docs/vpclattice_create_service_network_vpc_association/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you retry a request that completed
#' successfully using the same client token and parameters, the retry
#' succeeds without performing any actions. If the parameters aren't
#' identical, the retry fails.
#' @param securityGroupIds The IDs of the security groups. Security groups aren't added by default.
#' You can add a security group to apply network level controls to control
#' which resources in a VPC are allowed to access the service network and
#' its services. For more information, see [Control traffic to resources
#' using security
#' groups](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-security-groups.html)
#' in the *Amazon VPC User Guide*.
#' @param serviceNetworkIdentifier &#91;required&#93; The ID or ARN of the service network. You must use an ARN if the
#' resources are in different accounts.
#' @param tags The tags for the association.
#' @param vpcIdentifier &#91;required&#93; The ID of the VPC.
#'
#' @keywords internal
#'
#' @rdname vpclattice_create_service_network_vpc_association
vpclattice_create_service_network_vpc_association <- function(clientToken = NULL, securityGroupIds = NULL, serviceNetworkIdentifier, tags = NULL, vpcIdentifier) {
  op <- new_operation(
    name = "CreateServiceNetworkVpcAssociation",
    http_method = "POST",
    http_path = "/servicenetworkvpcassociations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$create_service_network_vpc_association_input(clientToken = clientToken, securityGroupIds = securityGroupIds, serviceNetworkIdentifier = serviceNetworkIdentifier, tags = tags, vpcIdentifier = vpcIdentifier)
  output <- .vpclattice$create_service_network_vpc_association_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$create_service_network_vpc_association <- vpclattice_create_service_network_vpc_association

#' Creates a target group
#'
#' @description
#' Creates a target group. A target group is a collection of targets, or compute resources, that run your application or service. A target group can only be used by a single service.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_create_target_group/](https://www.paws-r-sdk.com/docs/vpclattice_create_target_group/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you retry a request that completed
#' successfully using the same client token and parameters, the retry
#' succeeds without performing any actions. If the parameters aren't
#' identical, the retry fails.
#' @param config The target group configuration.
#' @param name &#91;required&#93; The name of the target group. The name must be unique within the
#' account. The valid characters are a-z, 0-9, and hyphens (-). You can't
#' use a hyphen as the first or last character, or immediately after
#' another hyphen.
#' @param tags The tags for the target group.
#' @param type &#91;required&#93; The type of target group.
#'
#' @keywords internal
#'
#' @rdname vpclattice_create_target_group
vpclattice_create_target_group <- function(clientToken = NULL, config = NULL, name, tags = NULL, type) {
  op <- new_operation(
    name = "CreateTargetGroup",
    http_method = "POST",
    http_path = "/targetgroups",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$create_target_group_input(clientToken = clientToken, config = config, name = name, tags = tags, type = type)
  output <- .vpclattice$create_target_group_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$create_target_group <- vpclattice_create_target_group

#' Deletes the specified access log subscription
#'
#' @description
#' Deletes the specified access log subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_delete_access_log_subscription/](https://www.paws-r-sdk.com/docs/vpclattice_delete_access_log_subscription/) for full documentation.
#'
#' @param accessLogSubscriptionIdentifier &#91;required&#93; The ID or ARN of the access log subscription.
#'
#' @keywords internal
#'
#' @rdname vpclattice_delete_access_log_subscription
vpclattice_delete_access_log_subscription <- function(accessLogSubscriptionIdentifier) {
  op <- new_operation(
    name = "DeleteAccessLogSubscription",
    http_method = "DELETE",
    http_path = "/accesslogsubscriptions/{accessLogSubscriptionIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$delete_access_log_subscription_input(accessLogSubscriptionIdentifier = accessLogSubscriptionIdentifier)
  output <- .vpclattice$delete_access_log_subscription_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$delete_access_log_subscription <- vpclattice_delete_access_log_subscription

#' Deletes the specified auth policy
#'
#' @description
#' Deletes the specified auth policy. If an auth is set to `AWS_IAM` and the auth policy is deleted, all requests are denied. If you are trying to remove the auth policy completely, you must set the auth type to `NONE`. If auth is enabled on the resource, but no auth policy is set, all requests are denied.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_delete_auth_policy/](https://www.paws-r-sdk.com/docs/vpclattice_delete_auth_policy/) for full documentation.
#'
#' @param resourceIdentifier &#91;required&#93; The ID or ARN of the resource.
#'
#' @keywords internal
#'
#' @rdname vpclattice_delete_auth_policy
vpclattice_delete_auth_policy <- function(resourceIdentifier) {
  op <- new_operation(
    name = "DeleteAuthPolicy",
    http_method = "DELETE",
    http_path = "/authpolicy/{resourceIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$delete_auth_policy_input(resourceIdentifier = resourceIdentifier)
  output <- .vpclattice$delete_auth_policy_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$delete_auth_policy <- vpclattice_delete_auth_policy

#' Deletes the specified listener
#'
#' @description
#' Deletes the specified listener.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_delete_listener/](https://www.paws-r-sdk.com/docs/vpclattice_delete_listener/) for full documentation.
#'
#' @param listenerIdentifier &#91;required&#93; The ID or ARN of the listener.
#' @param serviceIdentifier &#91;required&#93; The ID or ARN of the service.
#'
#' @keywords internal
#'
#' @rdname vpclattice_delete_listener
vpclattice_delete_listener <- function(listenerIdentifier, serviceIdentifier) {
  op <- new_operation(
    name = "DeleteListener",
    http_method = "DELETE",
    http_path = "/services/{serviceIdentifier}/listeners/{listenerIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$delete_listener_input(listenerIdentifier = listenerIdentifier, serviceIdentifier = serviceIdentifier)
  output <- .vpclattice$delete_listener_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$delete_listener <- vpclattice_delete_listener

#' Deletes the specified resource configuration
#'
#' @description
#' Deletes the specified resource configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_delete_resource_configuration/](https://www.paws-r-sdk.com/docs/vpclattice_delete_resource_configuration/) for full documentation.
#'
#' @param resourceConfigurationIdentifier &#91;required&#93; The ID or ARN of the resource configuration.
#'
#' @keywords internal
#'
#' @rdname vpclattice_delete_resource_configuration
vpclattice_delete_resource_configuration <- function(resourceConfigurationIdentifier) {
  op <- new_operation(
    name = "DeleteResourceConfiguration",
    http_method = "DELETE",
    http_path = "/resourceconfigurations/{resourceConfigurationIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$delete_resource_configuration_input(resourceConfigurationIdentifier = resourceConfigurationIdentifier)
  output <- .vpclattice$delete_resource_configuration_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$delete_resource_configuration <- vpclattice_delete_resource_configuration

#' Disassociates the resource configuration from the resource VPC endpoint
#'
#' @description
#' Disassociates the resource configuration from the resource VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_delete_resource_endpoint_association/](https://www.paws-r-sdk.com/docs/vpclattice_delete_resource_endpoint_association/) for full documentation.
#'
#' @param resourceEndpointAssociationIdentifier &#91;required&#93; The ID or ARN of the association.
#'
#' @keywords internal
#'
#' @rdname vpclattice_delete_resource_endpoint_association
vpclattice_delete_resource_endpoint_association <- function(resourceEndpointAssociationIdentifier) {
  op <- new_operation(
    name = "DeleteResourceEndpointAssociation",
    http_method = "DELETE",
    http_path = "/resourceendpointassociations/{resourceEndpointAssociationIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$delete_resource_endpoint_association_input(resourceEndpointAssociationIdentifier = resourceEndpointAssociationIdentifier)
  output <- .vpclattice$delete_resource_endpoint_association_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$delete_resource_endpoint_association <- vpclattice_delete_resource_endpoint_association

#' Deletes the specified resource gateway
#'
#' @description
#' Deletes the specified resource gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_delete_resource_gateway/](https://www.paws-r-sdk.com/docs/vpclattice_delete_resource_gateway/) for full documentation.
#'
#' @param resourceGatewayIdentifier &#91;required&#93; The ID or ARN of the resource gateway.
#'
#' @keywords internal
#'
#' @rdname vpclattice_delete_resource_gateway
vpclattice_delete_resource_gateway <- function(resourceGatewayIdentifier) {
  op <- new_operation(
    name = "DeleteResourceGateway",
    http_method = "DELETE",
    http_path = "/resourcegateways/{resourceGatewayIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$delete_resource_gateway_input(resourceGatewayIdentifier = resourceGatewayIdentifier)
  output <- .vpclattice$delete_resource_gateway_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$delete_resource_gateway <- vpclattice_delete_resource_gateway

#' Deletes the specified resource policy
#'
#' @description
#' Deletes the specified resource policy.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_delete_resource_policy/](https://www.paws-r-sdk.com/docs/vpclattice_delete_resource_policy/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname vpclattice_delete_resource_policy
vpclattice_delete_resource_policy <- function(resourceArn) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "DELETE",
    http_path = "/resourcepolicy/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$delete_resource_policy_input(resourceArn = resourceArn)
  output <- .vpclattice$delete_resource_policy_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$delete_resource_policy <- vpclattice_delete_resource_policy

#' Deletes a listener rule
#'
#' @description
#' Deletes a listener rule. Each listener has a default rule for checking connection requests, but you can define additional rules. Each rule consists of a priority, one or more actions, and one or more conditions. You can delete additional listener rules, but you cannot delete the default rule.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_delete_rule/](https://www.paws-r-sdk.com/docs/vpclattice_delete_rule/) for full documentation.
#'
#' @param listenerIdentifier &#91;required&#93; The ID or ARN of the listener.
#' @param ruleIdentifier &#91;required&#93; The ID or ARN of the rule.
#' @param serviceIdentifier &#91;required&#93; The ID or ARN of the service.
#'
#' @keywords internal
#'
#' @rdname vpclattice_delete_rule
vpclattice_delete_rule <- function(listenerIdentifier, ruleIdentifier, serviceIdentifier) {
  op <- new_operation(
    name = "DeleteRule",
    http_method = "DELETE",
    http_path = "/services/{serviceIdentifier}/listeners/{listenerIdentifier}/rules/{ruleIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$delete_rule_input(listenerIdentifier = listenerIdentifier, ruleIdentifier = ruleIdentifier, serviceIdentifier = serviceIdentifier)
  output <- .vpclattice$delete_rule_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$delete_rule <- vpclattice_delete_rule

#' Deletes a service
#'
#' @description
#' Deletes a service. A service can't be deleted if it's associated with a service network. If you delete a service, all resources related to the service, such as the resource policy, auth policy, listeners, listener rules, and access log subscriptions, are also deleted. For more information, see [Delete a service](https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html#delete-service) in the *Amazon VPC Lattice User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_delete_service/](https://www.paws-r-sdk.com/docs/vpclattice_delete_service/) for full documentation.
#'
#' @param serviceIdentifier &#91;required&#93; The ID or ARN of the service.
#'
#' @keywords internal
#'
#' @rdname vpclattice_delete_service
vpclattice_delete_service <- function(serviceIdentifier) {
  op <- new_operation(
    name = "DeleteService",
    http_method = "DELETE",
    http_path = "/services/{serviceIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$delete_service_input(serviceIdentifier = serviceIdentifier)
  output <- .vpclattice$delete_service_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$delete_service <- vpclattice_delete_service

#' Deletes a service network
#'
#' @description
#' Deletes a service network. You can only delete the service network if there is no service or VPC associated with it. If you delete a service network, all resources related to the service network, such as the resource policy, auth policy, and access log subscriptions, are also deleted. For more information, see [Delete a service network](https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#delete-service-network) in the *Amazon VPC Lattice User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_delete_service_network/](https://www.paws-r-sdk.com/docs/vpclattice_delete_service_network/) for full documentation.
#'
#' @param serviceNetworkIdentifier &#91;required&#93; The ID or ARN of the service network.
#'
#' @keywords internal
#'
#' @rdname vpclattice_delete_service_network
vpclattice_delete_service_network <- function(serviceNetworkIdentifier) {
  op <- new_operation(
    name = "DeleteServiceNetwork",
    http_method = "DELETE",
    http_path = "/servicenetworks/{serviceNetworkIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$delete_service_network_input(serviceNetworkIdentifier = serviceNetworkIdentifier)
  output <- .vpclattice$delete_service_network_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$delete_service_network <- vpclattice_delete_service_network

#' Deletes the association between a service network and a resource
#' configuration
#'
#' @description
#' Deletes the association between a service network and a resource configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_delete_service_network_resource_association/](https://www.paws-r-sdk.com/docs/vpclattice_delete_service_network_resource_association/) for full documentation.
#'
#' @param serviceNetworkResourceAssociationIdentifier &#91;required&#93; The ID of the association.
#'
#' @keywords internal
#'
#' @rdname vpclattice_delete_service_network_resource_association
vpclattice_delete_service_network_resource_association <- function(serviceNetworkResourceAssociationIdentifier) {
  op <- new_operation(
    name = "DeleteServiceNetworkResourceAssociation",
    http_method = "DELETE",
    http_path = "/servicenetworkresourceassociations/{serviceNetworkResourceAssociationIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$delete_service_network_resource_association_input(serviceNetworkResourceAssociationIdentifier = serviceNetworkResourceAssociationIdentifier)
  output <- .vpclattice$delete_service_network_resource_association_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$delete_service_network_resource_association <- vpclattice_delete_service_network_resource_association

#' Deletes the association between a service and a service network
#'
#' @description
#' Deletes the association between a service and a service network. This operation fails if an association is still in progress.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_delete_service_network_service_association/](https://www.paws-r-sdk.com/docs/vpclattice_delete_service_network_service_association/) for full documentation.
#'
#' @param serviceNetworkServiceAssociationIdentifier &#91;required&#93; The ID or ARN of the association.
#'
#' @keywords internal
#'
#' @rdname vpclattice_delete_service_network_service_association
vpclattice_delete_service_network_service_association <- function(serviceNetworkServiceAssociationIdentifier) {
  op <- new_operation(
    name = "DeleteServiceNetworkServiceAssociation",
    http_method = "DELETE",
    http_path = "/servicenetworkserviceassociations/{serviceNetworkServiceAssociationIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$delete_service_network_service_association_input(serviceNetworkServiceAssociationIdentifier = serviceNetworkServiceAssociationIdentifier)
  output <- .vpclattice$delete_service_network_service_association_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$delete_service_network_service_association <- vpclattice_delete_service_network_service_association

#' Disassociates the VPC from the service network
#'
#' @description
#' Disassociates the VPC from the service network. You can't disassociate the VPC if there is a create or update association in progress.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_delete_service_network_vpc_association/](https://www.paws-r-sdk.com/docs/vpclattice_delete_service_network_vpc_association/) for full documentation.
#'
#' @param serviceNetworkVpcAssociationIdentifier &#91;required&#93; The ID or ARN of the association.
#'
#' @keywords internal
#'
#' @rdname vpclattice_delete_service_network_vpc_association
vpclattice_delete_service_network_vpc_association <- function(serviceNetworkVpcAssociationIdentifier) {
  op <- new_operation(
    name = "DeleteServiceNetworkVpcAssociation",
    http_method = "DELETE",
    http_path = "/servicenetworkvpcassociations/{serviceNetworkVpcAssociationIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$delete_service_network_vpc_association_input(serviceNetworkVpcAssociationIdentifier = serviceNetworkVpcAssociationIdentifier)
  output <- .vpclattice$delete_service_network_vpc_association_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$delete_service_network_vpc_association <- vpclattice_delete_service_network_vpc_association

#' Deletes a target group
#'
#' @description
#' Deletes a target group. You can't delete a target group if it is used in a listener rule or if the target group creation is in progress.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_delete_target_group/](https://www.paws-r-sdk.com/docs/vpclattice_delete_target_group/) for full documentation.
#'
#' @param targetGroupIdentifier &#91;required&#93; The ID or ARN of the target group.
#'
#' @keywords internal
#'
#' @rdname vpclattice_delete_target_group
vpclattice_delete_target_group <- function(targetGroupIdentifier) {
  op <- new_operation(
    name = "DeleteTargetGroup",
    http_method = "DELETE",
    http_path = "/targetgroups/{targetGroupIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$delete_target_group_input(targetGroupIdentifier = targetGroupIdentifier)
  output <- .vpclattice$delete_target_group_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$delete_target_group <- vpclattice_delete_target_group

#' Deregisters the specified targets from the specified target group
#'
#' @description
#' Deregisters the specified targets from the specified target group.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_deregister_targets/](https://www.paws-r-sdk.com/docs/vpclattice_deregister_targets/) for full documentation.
#'
#' @param targetGroupIdentifier &#91;required&#93; The ID or ARN of the target group.
#' @param targets &#91;required&#93; The targets to deregister.
#'
#' @keywords internal
#'
#' @rdname vpclattice_deregister_targets
vpclattice_deregister_targets <- function(targetGroupIdentifier, targets) {
  op <- new_operation(
    name = "DeregisterTargets",
    http_method = "POST",
    http_path = "/targetgroups/{targetGroupIdentifier}/deregistertargets",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$deregister_targets_input(targetGroupIdentifier = targetGroupIdentifier, targets = targets)
  output <- .vpclattice$deregister_targets_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$deregister_targets <- vpclattice_deregister_targets

#' Retrieves information about the specified access log subscription
#'
#' @description
#' Retrieves information about the specified access log subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_get_access_log_subscription/](https://www.paws-r-sdk.com/docs/vpclattice_get_access_log_subscription/) for full documentation.
#'
#' @param accessLogSubscriptionIdentifier &#91;required&#93; The ID or ARN of the access log subscription.
#'
#' @keywords internal
#'
#' @rdname vpclattice_get_access_log_subscription
vpclattice_get_access_log_subscription <- function(accessLogSubscriptionIdentifier) {
  op <- new_operation(
    name = "GetAccessLogSubscription",
    http_method = "GET",
    http_path = "/accesslogsubscriptions/{accessLogSubscriptionIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$get_access_log_subscription_input(accessLogSubscriptionIdentifier = accessLogSubscriptionIdentifier)
  output <- .vpclattice$get_access_log_subscription_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$get_access_log_subscription <- vpclattice_get_access_log_subscription

#' Retrieves information about the auth policy for the specified service or
#' service network
#'
#' @description
#' Retrieves information about the auth policy for the specified service or service network.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_get_auth_policy/](https://www.paws-r-sdk.com/docs/vpclattice_get_auth_policy/) for full documentation.
#'
#' @param resourceIdentifier &#91;required&#93; The ID or ARN of the service network or service.
#'
#' @keywords internal
#'
#' @rdname vpclattice_get_auth_policy
vpclattice_get_auth_policy <- function(resourceIdentifier) {
  op <- new_operation(
    name = "GetAuthPolicy",
    http_method = "GET",
    http_path = "/authpolicy/{resourceIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$get_auth_policy_input(resourceIdentifier = resourceIdentifier)
  output <- .vpclattice$get_auth_policy_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$get_auth_policy <- vpclattice_get_auth_policy

#' Retrieves information about the specified listener for the specified
#' service
#'
#' @description
#' Retrieves information about the specified listener for the specified service.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_get_listener/](https://www.paws-r-sdk.com/docs/vpclattice_get_listener/) for full documentation.
#'
#' @param listenerIdentifier &#91;required&#93; The ID or ARN of the listener.
#' @param serviceIdentifier &#91;required&#93; The ID or ARN of the service.
#'
#' @keywords internal
#'
#' @rdname vpclattice_get_listener
vpclattice_get_listener <- function(listenerIdentifier, serviceIdentifier) {
  op <- new_operation(
    name = "GetListener",
    http_method = "GET",
    http_path = "/services/{serviceIdentifier}/listeners/{listenerIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$get_listener_input(listenerIdentifier = listenerIdentifier, serviceIdentifier = serviceIdentifier)
  output <- .vpclattice$get_listener_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$get_listener <- vpclattice_get_listener

#' Retrieves information about the specified resource configuration
#'
#' @description
#' Retrieves information about the specified resource configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_get_resource_configuration/](https://www.paws-r-sdk.com/docs/vpclattice_get_resource_configuration/) for full documentation.
#'
#' @param resourceConfigurationIdentifier &#91;required&#93; The ID of the resource configuration.
#'
#' @keywords internal
#'
#' @rdname vpclattice_get_resource_configuration
vpclattice_get_resource_configuration <- function(resourceConfigurationIdentifier) {
  op <- new_operation(
    name = "GetResourceConfiguration",
    http_method = "GET",
    http_path = "/resourceconfigurations/{resourceConfigurationIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$get_resource_configuration_input(resourceConfigurationIdentifier = resourceConfigurationIdentifier)
  output <- .vpclattice$get_resource_configuration_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$get_resource_configuration <- vpclattice_get_resource_configuration

#' Retrieves information about the specified resource gateway
#'
#' @description
#' Retrieves information about the specified resource gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_get_resource_gateway/](https://www.paws-r-sdk.com/docs/vpclattice_get_resource_gateway/) for full documentation.
#'
#' @param resourceGatewayIdentifier &#91;required&#93; The ID of the resource gateway.
#'
#' @keywords internal
#'
#' @rdname vpclattice_get_resource_gateway
vpclattice_get_resource_gateway <- function(resourceGatewayIdentifier) {
  op <- new_operation(
    name = "GetResourceGateway",
    http_method = "GET",
    http_path = "/resourcegateways/{resourceGatewayIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$get_resource_gateway_input(resourceGatewayIdentifier = resourceGatewayIdentifier)
  output <- .vpclattice$get_resource_gateway_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$get_resource_gateway <- vpclattice_get_resource_gateway

#' Retrieves information about the specified resource policy
#'
#' @description
#' Retrieves information about the specified resource policy. The resource policy is an IAM policy created on behalf of the resource owner when they share a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_get_resource_policy/](https://www.paws-r-sdk.com/docs/vpclattice_get_resource_policy/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the service network or service.
#'
#' @keywords internal
#'
#' @rdname vpclattice_get_resource_policy
vpclattice_get_resource_policy <- function(resourceArn) {
  op <- new_operation(
    name = "GetResourcePolicy",
    http_method = "GET",
    http_path = "/resourcepolicy/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$get_resource_policy_input(resourceArn = resourceArn)
  output <- .vpclattice$get_resource_policy_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$get_resource_policy <- vpclattice_get_resource_policy

#' Retrieves information about the specified listener rules
#'
#' @description
#' Retrieves information about the specified listener rules. You can also retrieve information about the default listener rule. For more information, see [Listener rules](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules) in the *Amazon VPC Lattice User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_get_rule/](https://www.paws-r-sdk.com/docs/vpclattice_get_rule/) for full documentation.
#'
#' @param listenerIdentifier &#91;required&#93; The ID or ARN of the listener.
#' @param ruleIdentifier &#91;required&#93; The ID or ARN of the listener rule.
#' @param serviceIdentifier &#91;required&#93; The ID or ARN of the service.
#'
#' @keywords internal
#'
#' @rdname vpclattice_get_rule
vpclattice_get_rule <- function(listenerIdentifier, ruleIdentifier, serviceIdentifier) {
  op <- new_operation(
    name = "GetRule",
    http_method = "GET",
    http_path = "/services/{serviceIdentifier}/listeners/{listenerIdentifier}/rules/{ruleIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$get_rule_input(listenerIdentifier = listenerIdentifier, ruleIdentifier = ruleIdentifier, serviceIdentifier = serviceIdentifier)
  output <- .vpclattice$get_rule_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$get_rule <- vpclattice_get_rule

#' Retrieves information about the specified service
#'
#' @description
#' Retrieves information about the specified service.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_get_service/](https://www.paws-r-sdk.com/docs/vpclattice_get_service/) for full documentation.
#'
#' @param serviceIdentifier &#91;required&#93; The ID or ARN of the service.
#'
#' @keywords internal
#'
#' @rdname vpclattice_get_service
vpclattice_get_service <- function(serviceIdentifier) {
  op <- new_operation(
    name = "GetService",
    http_method = "GET",
    http_path = "/services/{serviceIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$get_service_input(serviceIdentifier = serviceIdentifier)
  output <- .vpclattice$get_service_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$get_service <- vpclattice_get_service

#' Retrieves information about the specified service network
#'
#' @description
#' Retrieves information about the specified service network.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_get_service_network/](https://www.paws-r-sdk.com/docs/vpclattice_get_service_network/) for full documentation.
#'
#' @param serviceNetworkIdentifier &#91;required&#93; The ID or ARN of the service network.
#'
#' @keywords internal
#'
#' @rdname vpclattice_get_service_network
vpclattice_get_service_network <- function(serviceNetworkIdentifier) {
  op <- new_operation(
    name = "GetServiceNetwork",
    http_method = "GET",
    http_path = "/servicenetworks/{serviceNetworkIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$get_service_network_input(serviceNetworkIdentifier = serviceNetworkIdentifier)
  output <- .vpclattice$get_service_network_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$get_service_network <- vpclattice_get_service_network

#' Retrieves information about the specified association between a service
#' network and a resource configuration
#'
#' @description
#' Retrieves information about the specified association between a service network and a resource configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_get_service_network_resource_association/](https://www.paws-r-sdk.com/docs/vpclattice_get_service_network_resource_association/) for full documentation.
#'
#' @param serviceNetworkResourceAssociationIdentifier &#91;required&#93; The ID of the association.
#'
#' @keywords internal
#'
#' @rdname vpclattice_get_service_network_resource_association
vpclattice_get_service_network_resource_association <- function(serviceNetworkResourceAssociationIdentifier) {
  op <- new_operation(
    name = "GetServiceNetworkResourceAssociation",
    http_method = "GET",
    http_path = "/servicenetworkresourceassociations/{serviceNetworkResourceAssociationIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$get_service_network_resource_association_input(serviceNetworkResourceAssociationIdentifier = serviceNetworkResourceAssociationIdentifier)
  output <- .vpclattice$get_service_network_resource_association_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$get_service_network_resource_association <- vpclattice_get_service_network_resource_association

#' Retrieves information about the specified association between a service
#' network and a service
#'
#' @description
#' Retrieves information about the specified association between a service network and a service.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_get_service_network_service_association/](https://www.paws-r-sdk.com/docs/vpclattice_get_service_network_service_association/) for full documentation.
#'
#' @param serviceNetworkServiceAssociationIdentifier &#91;required&#93; The ID or ARN of the association.
#'
#' @keywords internal
#'
#' @rdname vpclattice_get_service_network_service_association
vpclattice_get_service_network_service_association <- function(serviceNetworkServiceAssociationIdentifier) {
  op <- new_operation(
    name = "GetServiceNetworkServiceAssociation",
    http_method = "GET",
    http_path = "/servicenetworkserviceassociations/{serviceNetworkServiceAssociationIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$get_service_network_service_association_input(serviceNetworkServiceAssociationIdentifier = serviceNetworkServiceAssociationIdentifier)
  output <- .vpclattice$get_service_network_service_association_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$get_service_network_service_association <- vpclattice_get_service_network_service_association

#' Retrieves information about the specified association between a service
#' network and a VPC
#'
#' @description
#' Retrieves information about the specified association between a service network and a VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_get_service_network_vpc_association/](https://www.paws-r-sdk.com/docs/vpclattice_get_service_network_vpc_association/) for full documentation.
#'
#' @param serviceNetworkVpcAssociationIdentifier &#91;required&#93; The ID or ARN of the association.
#'
#' @keywords internal
#'
#' @rdname vpclattice_get_service_network_vpc_association
vpclattice_get_service_network_vpc_association <- function(serviceNetworkVpcAssociationIdentifier) {
  op <- new_operation(
    name = "GetServiceNetworkVpcAssociation",
    http_method = "GET",
    http_path = "/servicenetworkvpcassociations/{serviceNetworkVpcAssociationIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$get_service_network_vpc_association_input(serviceNetworkVpcAssociationIdentifier = serviceNetworkVpcAssociationIdentifier)
  output <- .vpclattice$get_service_network_vpc_association_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$get_service_network_vpc_association <- vpclattice_get_service_network_vpc_association

#' Retrieves information about the specified target group
#'
#' @description
#' Retrieves information about the specified target group.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_get_target_group/](https://www.paws-r-sdk.com/docs/vpclattice_get_target_group/) for full documentation.
#'
#' @param targetGroupIdentifier &#91;required&#93; The ID or ARN of the target group.
#'
#' @keywords internal
#'
#' @rdname vpclattice_get_target_group
vpclattice_get_target_group <- function(targetGroupIdentifier) {
  op <- new_operation(
    name = "GetTargetGroup",
    http_method = "GET",
    http_path = "/targetgroups/{targetGroupIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$get_target_group_input(targetGroupIdentifier = targetGroupIdentifier)
  output <- .vpclattice$get_target_group_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$get_target_group <- vpclattice_get_target_group

#' Lists the access log subscriptions for the specified service network or
#' service
#'
#' @description
#' Lists the access log subscriptions for the specified service network or service.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_list_access_log_subscriptions/](https://www.paws-r-sdk.com/docs/vpclattice_list_access_log_subscriptions/) for full documentation.
#'
#' @param maxResults The maximum number of results to return.
#' @param nextToken A pagination token for the next page of results.
#' @param resourceIdentifier &#91;required&#93; The ID or ARN of the service network or service.
#'
#' @keywords internal
#'
#' @rdname vpclattice_list_access_log_subscriptions
vpclattice_list_access_log_subscriptions <- function(maxResults = NULL, nextToken = NULL, resourceIdentifier) {
  op <- new_operation(
    name = "ListAccessLogSubscriptions",
    http_method = "GET",
    http_path = "/accesslogsubscriptions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .vpclattice$list_access_log_subscriptions_input(maxResults = maxResults, nextToken = nextToken, resourceIdentifier = resourceIdentifier)
  output <- .vpclattice$list_access_log_subscriptions_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$list_access_log_subscriptions <- vpclattice_list_access_log_subscriptions

#' Lists the listeners for the specified service
#'
#' @description
#' Lists the listeners for the specified service.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_list_listeners/](https://www.paws-r-sdk.com/docs/vpclattice_list_listeners/) for full documentation.
#'
#' @param maxResults The maximum number of results to return.
#' @param nextToken A pagination token for the next page of results.
#' @param serviceIdentifier &#91;required&#93; The ID or ARN of the service.
#'
#' @keywords internal
#'
#' @rdname vpclattice_list_listeners
vpclattice_list_listeners <- function(maxResults = NULL, nextToken = NULL, serviceIdentifier) {
  op <- new_operation(
    name = "ListListeners",
    http_method = "GET",
    http_path = "/services/{serviceIdentifier}/listeners",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .vpclattice$list_listeners_input(maxResults = maxResults, nextToken = nextToken, serviceIdentifier = serviceIdentifier)
  output <- .vpclattice$list_listeners_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$list_listeners <- vpclattice_list_listeners

#' Lists the resource configurations owned by or shared with this account
#'
#' @description
#' Lists the resource configurations owned by or shared with this account.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_list_resource_configurations/](https://www.paws-r-sdk.com/docs/vpclattice_list_resource_configurations/) for full documentation.
#'
#' @param maxResults The maximum page size.
#' @param nextToken A pagination token for the next page of results.
#' @param resourceConfigurationGroupIdentifier The ID of the group resource configuration.
#' @param resourceGatewayIdentifier The ID of the resource gateway for the resource configuration.
#'
#' @keywords internal
#'
#' @rdname vpclattice_list_resource_configurations
vpclattice_list_resource_configurations <- function(maxResults = NULL, nextToken = NULL, resourceConfigurationGroupIdentifier = NULL, resourceGatewayIdentifier = NULL) {
  op <- new_operation(
    name = "ListResourceConfigurations",
    http_method = "GET",
    http_path = "/resourceconfigurations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .vpclattice$list_resource_configurations_input(maxResults = maxResults, nextToken = nextToken, resourceConfigurationGroupIdentifier = resourceConfigurationGroupIdentifier, resourceGatewayIdentifier = resourceGatewayIdentifier)
  output <- .vpclattice$list_resource_configurations_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$list_resource_configurations <- vpclattice_list_resource_configurations

#' Lists the associations for the specified VPC endpoint
#'
#' @description
#' Lists the associations for the specified VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_list_resource_endpoint_associations/](https://www.paws-r-sdk.com/docs/vpclattice_list_resource_endpoint_associations/) for full documentation.
#'
#' @param maxResults The maximum page size.
#' @param nextToken A pagination token for the next page of results.
#' @param resourceConfigurationIdentifier &#91;required&#93; The ID for the resource configuration associated with the VPC endpoint.
#' @param resourceEndpointAssociationIdentifier The ID of the association.
#' @param vpcEndpointId The ID of the VPC endpoint in the association.
#' @param vpcEndpointOwner The owner of the VPC endpoint in the association.
#'
#' @keywords internal
#'
#' @rdname vpclattice_list_resource_endpoint_associations
vpclattice_list_resource_endpoint_associations <- function(maxResults = NULL, nextToken = NULL, resourceConfigurationIdentifier, resourceEndpointAssociationIdentifier = NULL, vpcEndpointId = NULL, vpcEndpointOwner = NULL) {
  op <- new_operation(
    name = "ListResourceEndpointAssociations",
    http_method = "GET",
    http_path = "/resourceendpointassociations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .vpclattice$list_resource_endpoint_associations_input(maxResults = maxResults, nextToken = nextToken, resourceConfigurationIdentifier = resourceConfigurationIdentifier, resourceEndpointAssociationIdentifier = resourceEndpointAssociationIdentifier, vpcEndpointId = vpcEndpointId, vpcEndpointOwner = vpcEndpointOwner)
  output <- .vpclattice$list_resource_endpoint_associations_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$list_resource_endpoint_associations <- vpclattice_list_resource_endpoint_associations

#' Lists the resource gateways that you own or that were shared with you
#'
#' @description
#' Lists the resource gateways that you own or that were shared with you.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_list_resource_gateways/](https://www.paws-r-sdk.com/docs/vpclattice_list_resource_gateways/) for full documentation.
#'
#' @param maxResults The maximum page size.
#' @param nextToken If there are additional results, a pagination token for the next page of
#' results.
#'
#' @keywords internal
#'
#' @rdname vpclattice_list_resource_gateways
vpclattice_list_resource_gateways <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListResourceGateways",
    http_method = "GET",
    http_path = "/resourcegateways",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .vpclattice$list_resource_gateways_input(maxResults = maxResults, nextToken = nextToken)
  output <- .vpclattice$list_resource_gateways_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$list_resource_gateways <- vpclattice_list_resource_gateways

#' Lists the rules for the specified listener
#'
#' @description
#' Lists the rules for the specified listener.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_list_rules/](https://www.paws-r-sdk.com/docs/vpclattice_list_rules/) for full documentation.
#'
#' @param listenerIdentifier &#91;required&#93; The ID or ARN of the listener.
#' @param maxResults The maximum number of results to return.
#' @param nextToken A pagination token for the next page of results.
#' @param serviceIdentifier &#91;required&#93; The ID or ARN of the service.
#'
#' @keywords internal
#'
#' @rdname vpclattice_list_rules
vpclattice_list_rules <- function(listenerIdentifier, maxResults = NULL, nextToken = NULL, serviceIdentifier) {
  op <- new_operation(
    name = "ListRules",
    http_method = "GET",
    http_path = "/services/{serviceIdentifier}/listeners/{listenerIdentifier}/rules",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .vpclattice$list_rules_input(listenerIdentifier = listenerIdentifier, maxResults = maxResults, nextToken = nextToken, serviceIdentifier = serviceIdentifier)
  output <- .vpclattice$list_rules_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$list_rules <- vpclattice_list_rules

#' Lists the associations between a service network and a resource
#' configuration
#'
#' @description
#' Lists the associations between a service network and a resource configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_list_service_network_resource_associations/](https://www.paws-r-sdk.com/docs/vpclattice_list_service_network_resource_associations/) for full documentation.
#'
#' @param maxResults The maximum page size.
#' @param nextToken If there are additional results, a pagination token for the next page of
#' results.
#' @param resourceConfigurationIdentifier The ID of the resource configurationk.
#' @param serviceNetworkIdentifier The ID of the service network.
#'
#' @keywords internal
#'
#' @rdname vpclattice_list_service_network_resource_associations
vpclattice_list_service_network_resource_associations <- function(maxResults = NULL, nextToken = NULL, resourceConfigurationIdentifier = NULL, serviceNetworkIdentifier = NULL) {
  op <- new_operation(
    name = "ListServiceNetworkResourceAssociations",
    http_method = "GET",
    http_path = "/servicenetworkresourceassociations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .vpclattice$list_service_network_resource_associations_input(maxResults = maxResults, nextToken = nextToken, resourceConfigurationIdentifier = resourceConfigurationIdentifier, serviceNetworkIdentifier = serviceNetworkIdentifier)
  output <- .vpclattice$list_service_network_resource_associations_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$list_service_network_resource_associations <- vpclattice_list_service_network_resource_associations

#' Lists the associations between a service network and a service
#'
#' @description
#' Lists the associations between a service network and a service. You can filter the list either by service or service network. You must provide either the service network identifier or the service identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_list_service_network_service_associations/](https://www.paws-r-sdk.com/docs/vpclattice_list_service_network_service_associations/) for full documentation.
#'
#' @param maxResults The maximum number of results to return.
#' @param nextToken A pagination token for the next page of results.
#' @param serviceIdentifier The ID or ARN of the service.
#' @param serviceNetworkIdentifier The ID or ARN of the service network.
#'
#' @keywords internal
#'
#' @rdname vpclattice_list_service_network_service_associations
vpclattice_list_service_network_service_associations <- function(maxResults = NULL, nextToken = NULL, serviceIdentifier = NULL, serviceNetworkIdentifier = NULL) {
  op <- new_operation(
    name = "ListServiceNetworkServiceAssociations",
    http_method = "GET",
    http_path = "/servicenetworkserviceassociations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .vpclattice$list_service_network_service_associations_input(maxResults = maxResults, nextToken = nextToken, serviceIdentifier = serviceIdentifier, serviceNetworkIdentifier = serviceNetworkIdentifier)
  output <- .vpclattice$list_service_network_service_associations_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$list_service_network_service_associations <- vpclattice_list_service_network_service_associations

#' Lists the associations between a service network and a VPC
#'
#' @description
#' Lists the associations between a service network and a VPC. You can filter the list either by VPC or service network. You must provide either the ID of the service network identifier or the ID of the VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_list_service_network_vpc_associations/](https://www.paws-r-sdk.com/docs/vpclattice_list_service_network_vpc_associations/) for full documentation.
#'
#' @param maxResults The maximum number of results to return.
#' @param nextToken A pagination token for the next page of results.
#' @param serviceNetworkIdentifier The ID or ARN of the service network.
#' @param vpcIdentifier The ID or ARN of the VPC.
#'
#' @keywords internal
#'
#' @rdname vpclattice_list_service_network_vpc_associations
vpclattice_list_service_network_vpc_associations <- function(maxResults = NULL, nextToken = NULL, serviceNetworkIdentifier = NULL, vpcIdentifier = NULL) {
  op <- new_operation(
    name = "ListServiceNetworkVpcAssociations",
    http_method = "GET",
    http_path = "/servicenetworkvpcassociations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .vpclattice$list_service_network_vpc_associations_input(maxResults = maxResults, nextToken = nextToken, serviceNetworkIdentifier = serviceNetworkIdentifier, vpcIdentifier = vpcIdentifier)
  output <- .vpclattice$list_service_network_vpc_associations_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$list_service_network_vpc_associations <- vpclattice_list_service_network_vpc_associations

#' Lists the associations between a service network and a VPC endpoint
#'
#' @description
#' Lists the associations between a service network and a VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_list_service_network_vpc_endpoint_associations/](https://www.paws-r-sdk.com/docs/vpclattice_list_service_network_vpc_endpoint_associations/) for full documentation.
#'
#' @param maxResults The maximum page size.
#' @param nextToken If there are additional results, a pagination token for the next page of
#' results.
#' @param serviceNetworkIdentifier &#91;required&#93; The ID of the service network associated with the VPC endpoint.
#'
#' @keywords internal
#'
#' @rdname vpclattice_list_service_network_vpc_endpoint_associations
vpclattice_list_service_network_vpc_endpoint_associations <- function(maxResults = NULL, nextToken = NULL, serviceNetworkIdentifier) {
  op <- new_operation(
    name = "ListServiceNetworkVpcEndpointAssociations",
    http_method = "GET",
    http_path = "/servicenetworkvpcendpointassociations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .vpclattice$list_service_network_vpc_endpoint_associations_input(maxResults = maxResults, nextToken = nextToken, serviceNetworkIdentifier = serviceNetworkIdentifier)
  output <- .vpclattice$list_service_network_vpc_endpoint_associations_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$list_service_network_vpc_endpoint_associations <- vpclattice_list_service_network_vpc_endpoint_associations

#' Lists the service networks owned by or shared with this account
#'
#' @description
#' Lists the service networks owned by or shared with this account. The account ID in the ARN shows which account owns the service network.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_list_service_networks/](https://www.paws-r-sdk.com/docs/vpclattice_list_service_networks/) for full documentation.
#'
#' @param maxResults The maximum number of results to return.
#' @param nextToken A pagination token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname vpclattice_list_service_networks
vpclattice_list_service_networks <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListServiceNetworks",
    http_method = "GET",
    http_path = "/servicenetworks",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .vpclattice$list_service_networks_input(maxResults = maxResults, nextToken = nextToken)
  output <- .vpclattice$list_service_networks_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$list_service_networks <- vpclattice_list_service_networks

#' Lists the services owned by the caller account or shared with the caller
#' account
#'
#' @description
#' Lists the services owned by the caller account or shared with the caller account.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_list_services/](https://www.paws-r-sdk.com/docs/vpclattice_list_services/) for full documentation.
#'
#' @param maxResults The maximum number of results to return.
#' @param nextToken A pagination token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname vpclattice_list_services
vpclattice_list_services <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListServices",
    http_method = "GET",
    http_path = "/services",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .vpclattice$list_services_input(maxResults = maxResults, nextToken = nextToken)
  output <- .vpclattice$list_services_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$list_services <- vpclattice_list_services

#' Lists the tags for the specified resource
#'
#' @description
#' Lists the tags for the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/vpclattice_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname vpclattice_list_tags_for_resource
vpclattice_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .vpclattice$list_tags_for_resource_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$list_tags_for_resource <- vpclattice_list_tags_for_resource

#' Lists your target groups
#'
#' @description
#' Lists your target groups. You can narrow your search by using the filters below in your request.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_list_target_groups/](https://www.paws-r-sdk.com/docs/vpclattice_list_target_groups/) for full documentation.
#'
#' @param maxResults The maximum number of results to return.
#' @param nextToken A pagination token for the next page of results.
#' @param targetGroupType The target group type.
#' @param vpcIdentifier The ID or ARN of the VPC.
#'
#' @keywords internal
#'
#' @rdname vpclattice_list_target_groups
vpclattice_list_target_groups <- function(maxResults = NULL, nextToken = NULL, targetGroupType = NULL, vpcIdentifier = NULL) {
  op <- new_operation(
    name = "ListTargetGroups",
    http_method = "GET",
    http_path = "/targetgroups",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .vpclattice$list_target_groups_input(maxResults = maxResults, nextToken = nextToken, targetGroupType = targetGroupType, vpcIdentifier = vpcIdentifier)
  output <- .vpclattice$list_target_groups_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$list_target_groups <- vpclattice_list_target_groups

#' Lists the targets for the target group
#'
#' @description
#' Lists the targets for the target group. By default, all targets are included. You can use this API to check the health status of targets. You can also filter the results by target.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_list_targets/](https://www.paws-r-sdk.com/docs/vpclattice_list_targets/) for full documentation.
#'
#' @param maxResults The maximum number of results to return.
#' @param nextToken A pagination token for the next page of results.
#' @param targetGroupIdentifier &#91;required&#93; The ID or ARN of the target group.
#' @param targets The targets.
#'
#' @keywords internal
#'
#' @rdname vpclattice_list_targets
vpclattice_list_targets <- function(maxResults = NULL, nextToken = NULL, targetGroupIdentifier, targets = NULL) {
  op <- new_operation(
    name = "ListTargets",
    http_method = "POST",
    http_path = "/targetgroups/{targetGroupIdentifier}/listtargets",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .vpclattice$list_targets_input(maxResults = maxResults, nextToken = nextToken, targetGroupIdentifier = targetGroupIdentifier, targets = targets)
  output <- .vpclattice$list_targets_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$list_targets <- vpclattice_list_targets

#' Creates or updates the auth policy
#'
#' @description
#' Creates or updates the auth policy. The policy string in JSON must not contain newlines or blank lines.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_put_auth_policy/](https://www.paws-r-sdk.com/docs/vpclattice_put_auth_policy/) for full documentation.
#'
#' @param policy &#91;required&#93; The auth policy. The policy string in JSON must not contain newlines or
#' blank lines.
#' @param resourceIdentifier &#91;required&#93; The ID or ARN of the service network or service for which the policy is
#' created.
#'
#' @keywords internal
#'
#' @rdname vpclattice_put_auth_policy
vpclattice_put_auth_policy <- function(policy, resourceIdentifier) {
  op <- new_operation(
    name = "PutAuthPolicy",
    http_method = "PUT",
    http_path = "/authpolicy/{resourceIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$put_auth_policy_input(policy = policy, resourceIdentifier = resourceIdentifier)
  output <- .vpclattice$put_auth_policy_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$put_auth_policy <- vpclattice_put_auth_policy

#' Attaches a resource-based permission policy to a service or service
#' network
#'
#' @description
#' Attaches a resource-based permission policy to a service or service network. The policy must contain the same actions and condition statements as the Amazon Web Services Resource Access Manager permission for sharing services and service networks.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_put_resource_policy/](https://www.paws-r-sdk.com/docs/vpclattice_put_resource_policy/) for full documentation.
#'
#' @param policy &#91;required&#93; An IAM policy. The policy string in JSON must not contain newlines or
#' blank lines.
#' @param resourceArn &#91;required&#93; The ID or ARN of the service network or service for which the policy is
#' created.
#'
#' @keywords internal
#'
#' @rdname vpclattice_put_resource_policy
vpclattice_put_resource_policy <- function(policy, resourceArn) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "PUT",
    http_path = "/resourcepolicy/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$put_resource_policy_input(policy = policy, resourceArn = resourceArn)
  output <- .vpclattice$put_resource_policy_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$put_resource_policy <- vpclattice_put_resource_policy

#' Registers the targets with the target group
#'
#' @description
#' Registers the targets with the target group. If it's a Lambda target, you can only have one target in a target group.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_register_targets/](https://www.paws-r-sdk.com/docs/vpclattice_register_targets/) for full documentation.
#'
#' @param targetGroupIdentifier &#91;required&#93; The ID or ARN of the target group.
#' @param targets &#91;required&#93; The targets.
#'
#' @keywords internal
#'
#' @rdname vpclattice_register_targets
vpclattice_register_targets <- function(targetGroupIdentifier, targets) {
  op <- new_operation(
    name = "RegisterTargets",
    http_method = "POST",
    http_path = "/targetgroups/{targetGroupIdentifier}/registertargets",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$register_targets_input(targetGroupIdentifier = targetGroupIdentifier, targets = targets)
  output <- .vpclattice$register_targets_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$register_targets <- vpclattice_register_targets

#' Adds the specified tags to the specified resource
#'
#' @description
#' Adds the specified tags to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_tag_resource/](https://www.paws-r-sdk.com/docs/vpclattice_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tags &#91;required&#93; The tags for the resource.
#'
#' @keywords internal
#'
#' @rdname vpclattice_tag_resource
vpclattice_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .vpclattice$tag_resource_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$tag_resource <- vpclattice_tag_resource

#' Removes the specified tags from the specified resource
#'
#' @description
#' Removes the specified tags from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_untag_resource/](https://www.paws-r-sdk.com/docs/vpclattice_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tagKeys &#91;required&#93; The tag keys of the tags to remove.
#'
#' @keywords internal
#'
#' @rdname vpclattice_untag_resource
vpclattice_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .vpclattice$untag_resource_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$untag_resource <- vpclattice_untag_resource

#' Updates the specified access log subscription
#'
#' @description
#' Updates the specified access log subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_update_access_log_subscription/](https://www.paws-r-sdk.com/docs/vpclattice_update_access_log_subscription/) for full documentation.
#'
#' @param accessLogSubscriptionIdentifier &#91;required&#93; The ID or ARN of the access log subscription.
#' @param destinationArn &#91;required&#93; The Amazon Resource Name (ARN) of the access log destination.
#'
#' @keywords internal
#'
#' @rdname vpclattice_update_access_log_subscription
vpclattice_update_access_log_subscription <- function(accessLogSubscriptionIdentifier, destinationArn) {
  op <- new_operation(
    name = "UpdateAccessLogSubscription",
    http_method = "PATCH",
    http_path = "/accesslogsubscriptions/{accessLogSubscriptionIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$update_access_log_subscription_input(accessLogSubscriptionIdentifier = accessLogSubscriptionIdentifier, destinationArn = destinationArn)
  output <- .vpclattice$update_access_log_subscription_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$update_access_log_subscription <- vpclattice_update_access_log_subscription

#' Updates the specified listener for the specified service
#'
#' @description
#' Updates the specified listener for the specified service.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_update_listener/](https://www.paws-r-sdk.com/docs/vpclattice_update_listener/) for full documentation.
#'
#' @param defaultAction &#91;required&#93; The action for the default rule.
#' @param listenerIdentifier &#91;required&#93; The ID or ARN of the listener.
#' @param serviceIdentifier &#91;required&#93; The ID or ARN of the service.
#'
#' @keywords internal
#'
#' @rdname vpclattice_update_listener
vpclattice_update_listener <- function(defaultAction, listenerIdentifier, serviceIdentifier) {
  op <- new_operation(
    name = "UpdateListener",
    http_method = "PATCH",
    http_path = "/services/{serviceIdentifier}/listeners/{listenerIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$update_listener_input(defaultAction = defaultAction, listenerIdentifier = listenerIdentifier, serviceIdentifier = serviceIdentifier)
  output <- .vpclattice$update_listener_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$update_listener <- vpclattice_update_listener

#' Updates the specified resource configuration
#'
#' @description
#' Updates the specified resource configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_update_resource_configuration/](https://www.paws-r-sdk.com/docs/vpclattice_update_resource_configuration/) for full documentation.
#'
#' @param allowAssociationToShareableServiceNetwork Indicates whether to add the resource configuration to service networks
#' that are shared with other accounts.
#' @param portRanges The TCP port ranges that a consumer can use to access a resource
#' configuration. You can separate port ranges with a comma. Example:
#' 1-65535 or 1,2,22-30
#' @param resourceConfigurationDefinition The resource configuration.
#' @param resourceConfigurationIdentifier &#91;required&#93; The ID of the resource configuration.
#'
#' @keywords internal
#'
#' @rdname vpclattice_update_resource_configuration
vpclattice_update_resource_configuration <- function(allowAssociationToShareableServiceNetwork = NULL, portRanges = NULL, resourceConfigurationDefinition = NULL, resourceConfigurationIdentifier) {
  op <- new_operation(
    name = "UpdateResourceConfiguration",
    http_method = "PATCH",
    http_path = "/resourceconfigurations/{resourceConfigurationIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$update_resource_configuration_input(allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork, portRanges = portRanges, resourceConfigurationDefinition = resourceConfigurationDefinition, resourceConfigurationIdentifier = resourceConfigurationIdentifier)
  output <- .vpclattice$update_resource_configuration_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$update_resource_configuration <- vpclattice_update_resource_configuration

#' Updates the specified resource gateway
#'
#' @description
#' Updates the specified resource gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_update_resource_gateway/](https://www.paws-r-sdk.com/docs/vpclattice_update_resource_gateway/) for full documentation.
#'
#' @param resourceGatewayIdentifier &#91;required&#93; The ID or ARN of the resource gateway.
#' @param securityGroupIds The IDs of the security groups associated with the resource gateway.
#'
#' @keywords internal
#'
#' @rdname vpclattice_update_resource_gateway
vpclattice_update_resource_gateway <- function(resourceGatewayIdentifier, securityGroupIds = NULL) {
  op <- new_operation(
    name = "UpdateResourceGateway",
    http_method = "PATCH",
    http_path = "/resourcegateways/{resourceGatewayIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$update_resource_gateway_input(resourceGatewayIdentifier = resourceGatewayIdentifier, securityGroupIds = securityGroupIds)
  output <- .vpclattice$update_resource_gateway_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$update_resource_gateway <- vpclattice_update_resource_gateway

#' Updates a specified rule for the listener
#'
#' @description
#' Updates a specified rule for the listener. You can't modify a default listener rule. To modify a default listener rule, use [`update_listener`][vpclattice_update_listener].
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_update_rule/](https://www.paws-r-sdk.com/docs/vpclattice_update_rule/) for full documentation.
#'
#' @param action Information about the action for the specified listener rule.
#' @param listenerIdentifier &#91;required&#93; The ID or ARN of the listener.
#' @param match The rule match.
#' @param priority The rule priority. A listener can't have multiple rules with the same
#' priority.
#' @param ruleIdentifier &#91;required&#93; The ID or ARN of the rule.
#' @param serviceIdentifier &#91;required&#93; The ID or ARN of the service.
#'
#' @keywords internal
#'
#' @rdname vpclattice_update_rule
vpclattice_update_rule <- function(action = NULL, listenerIdentifier, match = NULL, priority = NULL, ruleIdentifier, serviceIdentifier) {
  op <- new_operation(
    name = "UpdateRule",
    http_method = "PATCH",
    http_path = "/services/{serviceIdentifier}/listeners/{listenerIdentifier}/rules/{ruleIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$update_rule_input(action = action, listenerIdentifier = listenerIdentifier, match = match, priority = priority, ruleIdentifier = ruleIdentifier, serviceIdentifier = serviceIdentifier)
  output <- .vpclattice$update_rule_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$update_rule <- vpclattice_update_rule

#' Updates the specified service
#'
#' @description
#' Updates the specified service.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_update_service/](https://www.paws-r-sdk.com/docs/vpclattice_update_service/) for full documentation.
#'
#' @param authType The type of IAM policy.
#' 
#' -   `NONE`: The resource does not use an IAM policy. This is the
#'     default.
#' 
#' -   `AWS_IAM`: The resource uses an IAM policy. When this type is used,
#'     auth is enabled and an auth policy is required.
#' @param certificateArn The Amazon Resource Name (ARN) of the certificate.
#' @param serviceIdentifier &#91;required&#93; The ID or ARN of the service.
#'
#' @keywords internal
#'
#' @rdname vpclattice_update_service
vpclattice_update_service <- function(authType = NULL, certificateArn = NULL, serviceIdentifier) {
  op <- new_operation(
    name = "UpdateService",
    http_method = "PATCH",
    http_path = "/services/{serviceIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$update_service_input(authType = authType, certificateArn = certificateArn, serviceIdentifier = serviceIdentifier)
  output <- .vpclattice$update_service_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$update_service <- vpclattice_update_service

#' Updates the specified service network
#'
#' @description
#' Updates the specified service network.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_update_service_network/](https://www.paws-r-sdk.com/docs/vpclattice_update_service_network/) for full documentation.
#'
#' @param authType &#91;required&#93; The type of IAM policy.
#' 
#' -   `NONE`: The resource does not use an IAM policy. This is the
#'     default.
#' 
#' -   `AWS_IAM`: The resource uses an IAM policy. When this type is used,
#'     auth is enabled and an auth policy is required.
#' @param serviceNetworkIdentifier &#91;required&#93; The ID or ARN of the service network.
#'
#' @keywords internal
#'
#' @rdname vpclattice_update_service_network
vpclattice_update_service_network <- function(authType, serviceNetworkIdentifier) {
  op <- new_operation(
    name = "UpdateServiceNetwork",
    http_method = "PATCH",
    http_path = "/servicenetworks/{serviceNetworkIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$update_service_network_input(authType = authType, serviceNetworkIdentifier = serviceNetworkIdentifier)
  output <- .vpclattice$update_service_network_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$update_service_network <- vpclattice_update_service_network

#' Updates the service network and VPC association
#'
#' @description
#' Updates the service network and VPC association. If you add a security group to the service network and VPC association, the association must continue to have at least one security group. You can add or edit security groups at any time. However, to remove all security groups, you must first delete the association and then recreate it without security groups.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_update_service_network_vpc_association/](https://www.paws-r-sdk.com/docs/vpclattice_update_service_network_vpc_association/) for full documentation.
#'
#' @param securityGroupIds &#91;required&#93; The IDs of the security groups.
#' @param serviceNetworkVpcAssociationIdentifier &#91;required&#93; The ID or ARN of the association.
#'
#' @keywords internal
#'
#' @rdname vpclattice_update_service_network_vpc_association
vpclattice_update_service_network_vpc_association <- function(securityGroupIds, serviceNetworkVpcAssociationIdentifier) {
  op <- new_operation(
    name = "UpdateServiceNetworkVpcAssociation",
    http_method = "PATCH",
    http_path = "/servicenetworkvpcassociations/{serviceNetworkVpcAssociationIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$update_service_network_vpc_association_input(securityGroupIds = securityGroupIds, serviceNetworkVpcAssociationIdentifier = serviceNetworkVpcAssociationIdentifier)
  output <- .vpclattice$update_service_network_vpc_association_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$update_service_network_vpc_association <- vpclattice_update_service_network_vpc_association

#' Updates the specified target group
#'
#' @description
#' Updates the specified target group.
#'
#' See [https://www.paws-r-sdk.com/docs/vpclattice_update_target_group/](https://www.paws-r-sdk.com/docs/vpclattice_update_target_group/) for full documentation.
#'
#' @param healthCheck &#91;required&#93; The health check configuration.
#' @param targetGroupIdentifier &#91;required&#93; The ID or ARN of the target group.
#'
#' @keywords internal
#'
#' @rdname vpclattice_update_target_group
vpclattice_update_target_group <- function(healthCheck, targetGroupIdentifier) {
  op <- new_operation(
    name = "UpdateTargetGroup",
    http_method = "PATCH",
    http_path = "/targetgroups/{targetGroupIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .vpclattice$update_target_group_input(healthCheck = healthCheck, targetGroupIdentifier = targetGroupIdentifier)
  output <- .vpclattice$update_target_group_output()
  config <- get_config()
  svc <- .vpclattice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.vpclattice$operations$update_target_group <- vpclattice_update_target_group
