# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include route53resolver_service.R
NULL

#' Associates a FirewallRuleGroup with a VPC, to provide DNS filtering for
#' the VPC
#'
#' @description
#' Associates a FirewallRuleGroup with a VPC, to provide DNS filtering for the VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_associate_firewall_rule_group/](https://www.paws-r-sdk.com/docs/route53resolver_associate_firewall_rule_group/) for full documentation.
#'
#' @param CreatorRequestId &#91;required&#93; A unique string that identifies the request and that allows failed
#' requests to be retried without the risk of running the operation twice.
#' `CreatorRequestId` can be any unique string, for example, a date/time
#' stamp.
#' @param FirewallRuleGroupId &#91;required&#93; The unique identifier of the firewall rule group.
#' @param VpcId &#91;required&#93; The unique identifier of the VPC that you want to associate with the
#' rule group.
#' @param Priority &#91;required&#93; The setting that determines the processing order of the rule group among
#' the rule groups that you associate with the specified VPC. DNS Firewall
#' filters VPC traffic starting from the rule group with the lowest numeric
#' priority setting.
#' 
#' You must specify a unique priority for each rule group that you
#' associate with a single VPC. To make it easier to insert rule groups
#' later, leave space between the numbers, for example, use 101, 200, and
#' so on. You can change the priority setting for a rule group association
#' after you create it.
#' 
#' The allowed values for `Priority` are between 100 and 9900.
#' @param Name &#91;required&#93; A name that lets you identify the association, to manage and use it.
#' @param MutationProtection If enabled, this setting disallows modification or removal of the
#' association, to help prevent against accidentally altering DNS firewall
#' protections. When you create the association, the default setting is
#' `DISABLED`.
#' @param Tags A list of the tag keys and values that you want to associate with the
#' rule group association.
#'
#' @keywords internal
#'
#' @rdname route53resolver_associate_firewall_rule_group
route53resolver_associate_firewall_rule_group <- function(CreatorRequestId, FirewallRuleGroupId, VpcId, Priority, Name, MutationProtection = NULL, Tags = NULL) {
  op <- new_operation(
    name = "AssociateFirewallRuleGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$associate_firewall_rule_group_input(CreatorRequestId = CreatorRequestId, FirewallRuleGroupId = FirewallRuleGroupId, VpcId = VpcId, Priority = Priority, Name = Name, MutationProtection = MutationProtection, Tags = Tags)
  output <- .route53resolver$associate_firewall_rule_group_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$associate_firewall_rule_group <- route53resolver_associate_firewall_rule_group

#' Adds IP addresses to an inbound or an outbound Resolver endpoint
#'
#' @description
#' Adds IP addresses to an inbound or an outbound Resolver endpoint. If you want to add more than one IP address, submit one [`associate_resolver_endpoint_ip_address`][route53resolver_associate_resolver_endpoint_ip_address] request for each IP address.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_associate_resolver_endpoint_ip_address/](https://www.paws-r-sdk.com/docs/route53resolver_associate_resolver_endpoint_ip_address/) for full documentation.
#'
#' @param ResolverEndpointId &#91;required&#93; The ID of the Resolver endpoint that you want to associate IP addresses
#' with.
#' @param IpAddress &#91;required&#93; Either the IPv4 address that you want to add to a Resolver endpoint or a
#' subnet ID. If you specify a subnet ID, Resolver chooses an IP address
#' for you from the available IPs in the specified subnet.
#'
#' @keywords internal
#'
#' @rdname route53resolver_associate_resolver_endpoint_ip_address
route53resolver_associate_resolver_endpoint_ip_address <- function(ResolverEndpointId, IpAddress) {
  op <- new_operation(
    name = "AssociateResolverEndpointIpAddress",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$associate_resolver_endpoint_ip_address_input(ResolverEndpointId = ResolverEndpointId, IpAddress = IpAddress)
  output <- .route53resolver$associate_resolver_endpoint_ip_address_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$associate_resolver_endpoint_ip_address <- route53resolver_associate_resolver_endpoint_ip_address

#' Associates an Amazon VPC with a specified query logging configuration
#'
#' @description
#' Associates an Amazon VPC with a specified query logging configuration. Route 53 Resolver logs DNS queries that originate in all of the Amazon VPCs that are associated with a specified query logging configuration. To associate more than one VPC with a configuration, submit one [`associate_resolver_query_log_config`][route53resolver_associate_resolver_query_log_config] request for each VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_associate_resolver_query_log_config/](https://www.paws-r-sdk.com/docs/route53resolver_associate_resolver_query_log_config/) for full documentation.
#'
#' @param ResolverQueryLogConfigId &#91;required&#93; The ID of the query logging configuration that you want to associate a
#' VPC with.
#' @param ResourceId &#91;required&#93; The ID of an Amazon VPC that you want this query logging configuration
#' to log queries for.
#' 
#' The VPCs and the query logging configuration must be in the same Region.
#'
#' @keywords internal
#'
#' @rdname route53resolver_associate_resolver_query_log_config
route53resolver_associate_resolver_query_log_config <- function(ResolverQueryLogConfigId, ResourceId) {
  op <- new_operation(
    name = "AssociateResolverQueryLogConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$associate_resolver_query_log_config_input(ResolverQueryLogConfigId = ResolverQueryLogConfigId, ResourceId = ResourceId)
  output <- .route53resolver$associate_resolver_query_log_config_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$associate_resolver_query_log_config <- route53resolver_associate_resolver_query_log_config

#' Associates a Resolver rule with a VPC
#'
#' @description
#' Associates a Resolver rule with a VPC. When you associate a rule with a VPC, Resolver forwards all DNS queries for the domain name that is specified in the rule and that originate in the VPC. The queries are forwarded to the IP addresses for the DNS resolvers that are specified in the rule. For more information about rules, see [`create_resolver_rule`][route53resolver_create_resolver_rule].
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_associate_resolver_rule/](https://www.paws-r-sdk.com/docs/route53resolver_associate_resolver_rule/) for full documentation.
#'
#' @param ResolverRuleId &#91;required&#93; The ID of the Resolver rule that you want to associate with the VPC. To
#' list the existing Resolver rules, use
#' [`list_resolver_rules`][route53resolver_list_resolver_rules].
#' @param Name A name for the association that you're creating between a Resolver rule
#' and a VPC.
#' @param VPCId &#91;required&#93; The ID of the VPC that you want to associate the Resolver rule with.
#'
#' @keywords internal
#'
#' @rdname route53resolver_associate_resolver_rule
route53resolver_associate_resolver_rule <- function(ResolverRuleId, Name = NULL, VPCId) {
  op <- new_operation(
    name = "AssociateResolverRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$associate_resolver_rule_input(ResolverRuleId = ResolverRuleId, Name = Name, VPCId = VPCId)
  output <- .route53resolver$associate_resolver_rule_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$associate_resolver_rule <- route53resolver_associate_resolver_rule

#' Creates an empty firewall domain list for use in DNS Firewall rules
#'
#' @description
#' Creates an empty firewall domain list for use in DNS Firewall rules. You can populate the domains for the new list with a file, using [`import_firewall_domains`][route53resolver_import_firewall_domains], or with domain strings, using [`update_firewall_domains`][route53resolver_update_firewall_domains].
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_create_firewall_domain_list/](https://www.paws-r-sdk.com/docs/route53resolver_create_firewall_domain_list/) for full documentation.
#'
#' @param CreatorRequestId &#91;required&#93; A unique string that identifies the request and that allows you to retry
#' failed requests without the risk of running the operation twice.
#' `CreatorRequestId` can be any unique string, for example, a date/time
#' stamp.
#' @param Name &#91;required&#93; A name that lets you identify the domain list to manage and use it.
#' @param Tags A list of the tag keys and values that you want to associate with the
#' domain list.
#'
#' @keywords internal
#'
#' @rdname route53resolver_create_firewall_domain_list
route53resolver_create_firewall_domain_list <- function(CreatorRequestId, Name, Tags = NULL) {
  op <- new_operation(
    name = "CreateFirewallDomainList",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$create_firewall_domain_list_input(CreatorRequestId = CreatorRequestId, Name = Name, Tags = Tags)
  output <- .route53resolver$create_firewall_domain_list_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$create_firewall_domain_list <- route53resolver_create_firewall_domain_list

#' Creates a single DNS Firewall rule in the specified rule group, using
#' the specified domain list
#'
#' @description
#' Creates a single DNS Firewall rule in the specified rule group, using the specified domain list.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_create_firewall_rule/](https://www.paws-r-sdk.com/docs/route53resolver_create_firewall_rule/) for full documentation.
#'
#' @param CreatorRequestId &#91;required&#93; A unique string that identifies the request and that allows you to retry
#' failed requests without the risk of running the operation twice.
#' `CreatorRequestId` can be any unique string, for example, a date/time
#' stamp.
#' @param FirewallRuleGroupId &#91;required&#93; The unique identifier of the firewall rule group where you want to
#' create the rule.
#' @param FirewallDomainListId The ID of the domain list that you want to use in the rule. Can't be
#' used together with `DnsThreatProtecton`.
#' @param Priority &#91;required&#93; The setting that determines the processing order of the rule in the rule
#' group. DNS Firewall processes the rules in a rule group by order of
#' priority, starting from the lowest setting.
#' 
#' You must specify a unique priority for each rule in a rule group. To
#' make it easier to insert rules later, leave space between the numbers,
#' for example, use 100, 200, and so on. You can change the priority
#' setting for the rules in a rule group at any time.
#' @param Action &#91;required&#93; The action that DNS Firewall should take on a DNS query when it matches
#' one of the domains in the rule's domain list, or a threat in a DNS
#' Firewall Advanced rule:
#' 
#' -   `ALLOW` - Permit the request to go through. Not available for DNS
#'     Firewall Advanced rules.
#' 
#' -   `ALERT` - Permit the request and send metrics and logs to Cloud
#'     Watch.
#' 
#' -   `BLOCK` - Disallow the request. This option requires additional
#'     details in the rule's `BlockResponse`.
#' @param BlockResponse The way that you want DNS Firewall to block the request, used with the
#' rule action setting `BLOCK`.
#' 
#' -   `NODATA` - Respond indicating that the query was successful, but no
#'     response is available for it.
#' 
#' -   `NXDOMAIN` - Respond indicating that the domain name that's in the
#'     query doesn't exist.
#' 
#' -   `OVERRIDE` - Provide a custom override in the response. This option
#'     requires custom handling details in the rule's `BlockOverride*`
#'     settings.
#' 
#' This setting is required if the rule action setting is `BLOCK`.
#' @param BlockOverrideDomain The custom DNS record to send back in response to the query. Used for
#' the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
#' 
#' This setting is required if the `BlockResponse` setting is `OVERRIDE`.
#' @param BlockOverrideDnsType The DNS record's type. This determines the format of the record value
#' that you provided in `BlockOverrideDomain`. Used for the rule action
#' `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
#' 
#' This setting is required if the `BlockResponse` setting is `OVERRIDE`.
#' @param BlockOverrideTtl The recommended amount of time, in seconds, for the DNS resolver or web
#' browser to cache the provided override record. Used for the rule action
#' `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
#' 
#' This setting is required if the `BlockResponse` setting is `OVERRIDE`.
#' @param Name &#91;required&#93; A name that lets you identify the rule in the rule group.
#' @param FirewallDomainRedirectionAction How you want the the rule to evaluate DNS redirection in the DNS
#' redirection chain, such as CNAME or DNAME.
#' 
#' `INSPECT_REDIRECTION_DOMAIN`: (Default) inspects all domains in the
#' redirection chain. The individual domains in the redirection chain must
#' be added to the domain list.
#' 
#' `TRUST_REDIRECTION_DOMAIN`: Inspects only the first domain in the
#' redirection chain. You don't need to add the subsequent domains in the
#' domain in the redirection list to the domain list.
#' @param Qtype The DNS query type you want the rule to evaluate. Allowed values are;
#' 
#' -   A: Returns an IPv4 address.
#' 
#' -   AAAA: Returns an Ipv6 address.
#' 
#' -   CAA: Restricts CAs that can create SSL/TLS certifications for the
#'     domain.
#' 
#' -   CNAME: Returns another domain name.
#' 
#' -   DS: Record that identifies the DNSSEC signing key of a delegated
#'     zone.
#' 
#' -   MX: Specifies mail servers.
#' 
#' -   NAPTR: Regular-expression-based rewriting of domain names.
#' 
#' -   NS: Authoritative name servers.
#' 
#' -   PTR: Maps an IP address to a domain name.
#' 
#' -   SOA: Start of authority record for the zone.
#' 
#' -   SPF: Lists the servers authorized to send emails from a domain.
#' 
#' -   SRV: Application specific values that identify servers.
#' 
#' -   TXT: Verifies email senders and application-specific values.
#' 
#' -   A query type you define by using the DNS type ID, for example 28 for
#'     AAAA. The values must be defined as TYPENUMBER, where the NUMBER can
#'     be 1-65334, for example, TYPE28. For more information, see [List of
#'     DNS record
#'     types](https://en.wikipedia.org/wiki/List_of_DNS_record_types).
#' @param DnsThreatProtection Use to create a DNS Firewall Advanced rule.
#' @param ConfidenceThreshold The confidence threshold for DNS Firewall Advanced. You must provide
#' this value when you create a DNS Firewall Advanced rule. The confidence
#' level values mean:
#' 
#' -   `LOW`: Provides the highest detection rate for threats, but also
#'     increases false positives.
#' 
#' -   `MEDIUM`: Provides a balance between detecting threats and false
#'     positives.
#' 
#' -   `HIGH`: Detects only the most well corroborated threats with a low
#'     rate of false positives.
#'
#' @keywords internal
#'
#' @rdname route53resolver_create_firewall_rule
route53resolver_create_firewall_rule <- function(CreatorRequestId, FirewallRuleGroupId, FirewallDomainListId = NULL, Priority, Action, BlockResponse = NULL, BlockOverrideDomain = NULL, BlockOverrideDnsType = NULL, BlockOverrideTtl = NULL, Name, FirewallDomainRedirectionAction = NULL, Qtype = NULL, DnsThreatProtection = NULL, ConfidenceThreshold = NULL) {
  op <- new_operation(
    name = "CreateFirewallRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$create_firewall_rule_input(CreatorRequestId = CreatorRequestId, FirewallRuleGroupId = FirewallRuleGroupId, FirewallDomainListId = FirewallDomainListId, Priority = Priority, Action = Action, BlockResponse = BlockResponse, BlockOverrideDomain = BlockOverrideDomain, BlockOverrideDnsType = BlockOverrideDnsType, BlockOverrideTtl = BlockOverrideTtl, Name = Name, FirewallDomainRedirectionAction = FirewallDomainRedirectionAction, Qtype = Qtype, DnsThreatProtection = DnsThreatProtection, ConfidenceThreshold = ConfidenceThreshold)
  output <- .route53resolver$create_firewall_rule_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$create_firewall_rule <- route53resolver_create_firewall_rule

#' Creates an empty DNS Firewall rule group for filtering DNS network
#' traffic in a VPC
#'
#' @description
#' Creates an empty DNS Firewall rule group for filtering DNS network traffic in a VPC. You can add rules to the new rule group by calling [`create_firewall_rule`][route53resolver_create_firewall_rule].
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_create_firewall_rule_group/](https://www.paws-r-sdk.com/docs/route53resolver_create_firewall_rule_group/) for full documentation.
#'
#' @param CreatorRequestId &#91;required&#93; A unique string defined by you to identify the request. This allows you
#' to retry failed requests without the risk of running the operation
#' twice. This can be any unique string, for example, a timestamp.
#' @param Name &#91;required&#93; A name that lets you identify the rule group, to manage and use it.
#' @param Tags A list of the tag keys and values that you want to associate with the
#' rule group.
#'
#' @keywords internal
#'
#' @rdname route53resolver_create_firewall_rule_group
route53resolver_create_firewall_rule_group <- function(CreatorRequestId, Name, Tags = NULL) {
  op <- new_operation(
    name = "CreateFirewallRuleGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$create_firewall_rule_group_input(CreatorRequestId = CreatorRequestId, Name = Name, Tags = Tags)
  output <- .route53resolver$create_firewall_rule_group_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$create_firewall_rule_group <- route53resolver_create_firewall_rule_group

#' Creates a Route 53 Resolver on an Outpost
#'
#' @description
#' Creates a Route 53 Resolver on an Outpost.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_create_outpost_resolver/](https://www.paws-r-sdk.com/docs/route53resolver_create_outpost_resolver/) for full documentation.
#'
#' @param CreatorRequestId &#91;required&#93; A unique string that identifies the request and that allows failed
#' requests to be retried without the risk of running the operation twice.
#' 
#' `CreatorRequestId` can be any unique string, for example, a date/time
#' stamp.
#' @param Name &#91;required&#93; A friendly name that lets you easily find a configuration in the
#' Resolver dashboard in the Route 53 console.
#' @param InstanceCount Number of Amazon EC2 instances for the Resolver on Outpost. The default
#' and minimal value is 4.
#' @param PreferredInstanceType &#91;required&#93; The Amazon EC2 instance type. If you specify this, you must also specify
#' a value for the `OutpostArn`.
#' @param OutpostArn &#91;required&#93; The Amazon Resource Name (ARN) of the Outpost. If you specify this, you
#' must also specify a value for the `PreferredInstanceType`.
#' @param Tags A string that helps identify the Route 53 Resolvers on Outpost.
#'
#' @keywords internal
#'
#' @rdname route53resolver_create_outpost_resolver
route53resolver_create_outpost_resolver <- function(CreatorRequestId, Name, InstanceCount = NULL, PreferredInstanceType, OutpostArn, Tags = NULL) {
  op <- new_operation(
    name = "CreateOutpostResolver",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$create_outpost_resolver_input(CreatorRequestId = CreatorRequestId, Name = Name, InstanceCount = InstanceCount, PreferredInstanceType = PreferredInstanceType, OutpostArn = OutpostArn, Tags = Tags)
  output <- .route53resolver$create_outpost_resolver_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$create_outpost_resolver <- route53resolver_create_outpost_resolver

#' Creates a Resolver endpoint
#'
#' @description
#' Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound:
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_create_resolver_endpoint/](https://www.paws-r-sdk.com/docs/route53resolver_create_resolver_endpoint/) for full documentation.
#'
#' @param CreatorRequestId &#91;required&#93; A unique string that identifies the request and that allows failed
#' requests to be retried without the risk of running the operation twice.
#' `CreatorRequestId` can be any unique string, for example, a date/time
#' stamp.
#' @param Name A friendly name that lets you easily find a configuration in the
#' Resolver dashboard in the Route 53 console.
#' @param SecurityGroupIds &#91;required&#93; The ID of one or more security groups that you want to use to control
#' access to this VPC. The security group that you specify must include one
#' or more inbound rules (for inbound Resolver endpoints) or outbound rules
#' (for outbound Resolver endpoints). Inbound and outbound rules must allow
#' TCP and UDP access. For inbound access, open port 53. For outbound
#' access, open the port that you're using for DNS queries on your network.
#' 
#' Some security group rules will cause your connection to be tracked. For
#' outbound resolver endpoint, it can potentially impact the maximum
#' queries per second from outbound endpoint to your target name server.
#' For inbound resolver endpoint, it can bring down the overall maximum
#' queries per second per IP address to as low as 1500. To avoid connection
#' tracking caused by security group, see [Untracked
#' connections](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#untracked-connectionsl).
#' @param Direction &#91;required&#93; Specify the applicable value:
#' 
#' -   `INBOUND`: Resolver forwards DNS queries to the DNS service for a
#'     VPC from your network
#' 
#' -   `OUTBOUND`: Resolver forwards DNS queries from the DNS service for a
#'     VPC to your network
#' @param IpAddresses &#91;required&#93; The subnets and IP addresses in your VPC that DNS queries originate from
#' (for outbound endpoints) or that you forward DNS queries to (for inbound
#' endpoints). The subnet ID uniquely identifies a VPC.
#' 
#' Even though the minimum is 1, Route 53 requires that you create at least
#' two.
#' @param OutpostArn The Amazon Resource Name (ARN) of the Outpost. If you specify this, you
#' must also specify a value for the `PreferredInstanceType`.
#' @param PreferredInstanceType The instance type. If you specify this, you must also specify a value
#' for the `OutpostArn`.
#' @param Tags A list of the tag keys and values that you want to associate with the
#' endpoint.
#' @param ResolverEndpointType For the endpoint type you can choose either IPv4, IPv6, or dual-stack. A
#' dual-stack endpoint means that it will resolve via both IPv4 and IPv6.
#' This endpoint type is applied to all IP addresses.
#' @param Protocols The protocols you want to use for the endpoint. DoH-FIPS is applicable
#' for inbound endpoints only.
#' 
#' For an inbound endpoint you can apply the protocols as follows:
#' 
#' -   Do53 and DoH in combination.
#' 
#' -   Do53 and DoH-FIPS in combination.
#' 
#' -   Do53 alone.
#' 
#' -   DoH alone.
#' 
#' -   DoH-FIPS alone.
#' 
#' -   None, which is treated as Do53.
#' 
#' For an outbound endpoint you can apply the protocols as follows:
#' 
#' -   Do53 and DoH in combination.
#' 
#' -   Do53 alone.
#' 
#' -   DoH alone.
#' 
#' -   None, which is treated as Do53.
#'
#' @keywords internal
#'
#' @rdname route53resolver_create_resolver_endpoint
route53resolver_create_resolver_endpoint <- function(CreatorRequestId, Name = NULL, SecurityGroupIds, Direction, IpAddresses, OutpostArn = NULL, PreferredInstanceType = NULL, Tags = NULL, ResolverEndpointType = NULL, Protocols = NULL) {
  op <- new_operation(
    name = "CreateResolverEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$create_resolver_endpoint_input(CreatorRequestId = CreatorRequestId, Name = Name, SecurityGroupIds = SecurityGroupIds, Direction = Direction, IpAddresses = IpAddresses, OutpostArn = OutpostArn, PreferredInstanceType = PreferredInstanceType, Tags = Tags, ResolverEndpointType = ResolverEndpointType, Protocols = Protocols)
  output <- .route53resolver$create_resolver_endpoint_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$create_resolver_endpoint <- route53resolver_create_resolver_endpoint

#' Creates a Resolver query logging configuration, which defines where you
#' want Resolver to save DNS query logs that originate in your VPCs
#'
#' @description
#' Creates a Resolver query logging configuration, which defines where you want Resolver to save DNS query logs that originate in your VPCs. Resolver can log queries only for VPCs that are in the same Region as the query logging configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_create_resolver_query_log_config/](https://www.paws-r-sdk.com/docs/route53resolver_create_resolver_query_log_config/) for full documentation.
#'
#' @param Name &#91;required&#93; The name that you want to give the query logging configuration.
#' @param DestinationArn &#91;required&#93; The ARN of the resource that you want Resolver to send query logs. You
#' can send query logs to an S3 bucket, a CloudWatch Logs log group, or a
#' Kinesis Data Firehose delivery stream. Examples of valid values include
#' the following:
#' 
#' -   **S3 bucket**:
#' 
#'     `arn:aws:s3:::amzn-s3-demo-bucket`
#' 
#'     You can optionally append a file prefix to the end of the ARN.
#' 
#'     `arn:aws:s3:::amzn-s3-demo-bucket/development/`
#' 
#' -   **CloudWatch Logs log group**:
#' 
#'     `arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*`
#' 
#' -   **Kinesis Data Firehose delivery stream**:
#' 
#'     `arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name`
#' @param CreatorRequestId &#91;required&#93; A unique string that identifies the request and that allows failed
#' requests to be retried without the risk of running the operation twice.
#' `CreatorRequestId` can be any unique string, for example, a date/time
#' stamp.
#' @param Tags A list of the tag keys and values that you want to associate with the
#' query logging configuration.
#'
#' @keywords internal
#'
#' @rdname route53resolver_create_resolver_query_log_config
route53resolver_create_resolver_query_log_config <- function(Name, DestinationArn, CreatorRequestId, Tags = NULL) {
  op <- new_operation(
    name = "CreateResolverQueryLogConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$create_resolver_query_log_config_input(Name = Name, DestinationArn = DestinationArn, CreatorRequestId = CreatorRequestId, Tags = Tags)
  output <- .route53resolver$create_resolver_query_log_config_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$create_resolver_query_log_config <- route53resolver_create_resolver_query_log_config

#' For DNS queries that originate in your VPCs, specifies which Resolver
#' endpoint the queries pass through, one domain name that you want to
#' forward to your network, and the IP addresses of the DNS resolvers in
#' your network
#'
#' @description
#' For DNS queries that originate in your VPCs, specifies which Resolver endpoint the queries pass through, one domain name that you want to forward to your network, and the IP addresses of the DNS resolvers in your network.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_create_resolver_rule/](https://www.paws-r-sdk.com/docs/route53resolver_create_resolver_rule/) for full documentation.
#'
#' @param CreatorRequestId &#91;required&#93; A unique string that identifies the request and that allows failed
#' requests to be retried without the risk of running the operation twice.
#' `CreatorRequestId` can be any unique string, for example, a date/time
#' stamp.
#' @param Name A friendly name that lets you easily find a rule in the Resolver
#' dashboard in the Route 53 console.
#' @param RuleType &#91;required&#93; When you want to forward DNS queries for specified domain name to
#' resolvers on your network, specify `FORWARD`.
#' 
#' When you have a forwarding rule to forward DNS queries for a domain to
#' your network and you want Resolver to process queries for a subdomain of
#' that domain, specify `SYSTEM`.
#' 
#' For example, to forward DNS queries for example.com to resolvers on your
#' network, you create a rule and specify `FORWARD` for `RuleType`. To then
#' have Resolver process queries for apex.example.com, you create a rule
#' and specify `SYSTEM` for `RuleType`.
#' 
#' Currently, only Resolver can create rules that have a value of
#' `RECURSIVE` for `RuleType`.
#' @param DomainName DNS queries for this domain name are forwarded to the IP addresses that
#' you specify in `TargetIps`. If a query matches multiple Resolver rules
#' (example.com and www.example.com), outbound DNS queries are routed using
#' the Resolver rule that contains the most specific domain name
#' (www.example.com).
#' @param TargetIps The IPs that you want Resolver to forward DNS queries to. You can
#' specify either Ipv4 or Ipv6 addresses but not both in the same rule.
#' Separate IP addresses with a space.
#' 
#' `TargetIps` is available only when the value of `Rule type` is
#' `FORWARD`.
#' @param ResolverEndpointId The ID of the outbound Resolver endpoint that you want to use to route
#' DNS queries to the IP addresses that you specify in `TargetIps`.
#' @param Tags A list of the tag keys and values that you want to associate with the
#' endpoint.
#'
#' @keywords internal
#'
#' @rdname route53resolver_create_resolver_rule
route53resolver_create_resolver_rule <- function(CreatorRequestId, Name = NULL, RuleType, DomainName = NULL, TargetIps = NULL, ResolverEndpointId = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateResolverRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$create_resolver_rule_input(CreatorRequestId = CreatorRequestId, Name = Name, RuleType = RuleType, DomainName = DomainName, TargetIps = TargetIps, ResolverEndpointId = ResolverEndpointId, Tags = Tags)
  output <- .route53resolver$create_resolver_rule_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$create_resolver_rule <- route53resolver_create_resolver_rule

#' Deletes the specified domain list
#'
#' @description
#' Deletes the specified domain list.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_delete_firewall_domain_list/](https://www.paws-r-sdk.com/docs/route53resolver_delete_firewall_domain_list/) for full documentation.
#'
#' @param FirewallDomainListId &#91;required&#93; The ID of the domain list that you want to delete.
#'
#' @keywords internal
#'
#' @rdname route53resolver_delete_firewall_domain_list
route53resolver_delete_firewall_domain_list <- function(FirewallDomainListId) {
  op <- new_operation(
    name = "DeleteFirewallDomainList",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$delete_firewall_domain_list_input(FirewallDomainListId = FirewallDomainListId)
  output <- .route53resolver$delete_firewall_domain_list_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$delete_firewall_domain_list <- route53resolver_delete_firewall_domain_list

#' Deletes the specified firewall rule
#'
#' @description
#' Deletes the specified firewall rule.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_delete_firewall_rule/](https://www.paws-r-sdk.com/docs/route53resolver_delete_firewall_rule/) for full documentation.
#'
#' @param FirewallRuleGroupId &#91;required&#93; The unique identifier of the firewall rule group that you want to delete
#' the rule from.
#' @param FirewallDomainListId The ID of the domain list that's used in the rule.
#' @param FirewallThreatProtectionId The ID that is created for a DNS Firewall Advanced rule.
#' @param Qtype The DNS query type that the rule you are deleting evaluates. Allowed
#' values are;
#' 
#' -   A: Returns an IPv4 address.
#' 
#' -   AAAA: Returns an Ipv6 address.
#' 
#' -   CAA: Restricts CAs that can create SSL/TLS certifications for the
#'     domain.
#' 
#' -   CNAME: Returns another domain name.
#' 
#' -   DS: Record that identifies the DNSSEC signing key of a delegated
#'     zone.
#' 
#' -   MX: Specifies mail servers.
#' 
#' -   NAPTR: Regular-expression-based rewriting of domain names.
#' 
#' -   NS: Authoritative name servers.
#' 
#' -   PTR: Maps an IP address to a domain name.
#' 
#' -   SOA: Start of authority record for the zone.
#' 
#' -   SPF: Lists the servers authorized to send emails from a domain.
#' 
#' -   SRV: Application specific values that identify servers.
#' 
#' -   TXT: Verifies email senders and application-specific values.
#' 
#' -   A query type you define by using the DNS type ID, for example 28 for
#'     AAAA. The values must be defined as TYPENUMBER, where the NUMBER can
#'     be 1-65334, for example, TYPE28. For more information, see [List of
#'     DNS record
#'     types](https://en.wikipedia.org/wiki/List_of_DNS_record_types).
#'
#' @keywords internal
#'
#' @rdname route53resolver_delete_firewall_rule
route53resolver_delete_firewall_rule <- function(FirewallRuleGroupId, FirewallDomainListId = NULL, FirewallThreatProtectionId = NULL, Qtype = NULL) {
  op <- new_operation(
    name = "DeleteFirewallRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$delete_firewall_rule_input(FirewallRuleGroupId = FirewallRuleGroupId, FirewallDomainListId = FirewallDomainListId, FirewallThreatProtectionId = FirewallThreatProtectionId, Qtype = Qtype)
  output <- .route53resolver$delete_firewall_rule_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$delete_firewall_rule <- route53resolver_delete_firewall_rule

#' Deletes the specified firewall rule group
#'
#' @description
#' Deletes the specified firewall rule group.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_delete_firewall_rule_group/](https://www.paws-r-sdk.com/docs/route53resolver_delete_firewall_rule_group/) for full documentation.
#'
#' @param FirewallRuleGroupId &#91;required&#93; The unique identifier of the firewall rule group that you want to
#' delete.
#'
#' @keywords internal
#'
#' @rdname route53resolver_delete_firewall_rule_group
route53resolver_delete_firewall_rule_group <- function(FirewallRuleGroupId) {
  op <- new_operation(
    name = "DeleteFirewallRuleGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$delete_firewall_rule_group_input(FirewallRuleGroupId = FirewallRuleGroupId)
  output <- .route53resolver$delete_firewall_rule_group_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$delete_firewall_rule_group <- route53resolver_delete_firewall_rule_group

#' Deletes a Resolver on the Outpost
#'
#' @description
#' Deletes a Resolver on the Outpost.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_delete_outpost_resolver/](https://www.paws-r-sdk.com/docs/route53resolver_delete_outpost_resolver/) for full documentation.
#'
#' @param Id &#91;required&#93; A unique string that identifies the Resolver on the Outpost.
#'
#' @keywords internal
#'
#' @rdname route53resolver_delete_outpost_resolver
route53resolver_delete_outpost_resolver <- function(Id) {
  op <- new_operation(
    name = "DeleteOutpostResolver",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$delete_outpost_resolver_input(Id = Id)
  output <- .route53resolver$delete_outpost_resolver_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$delete_outpost_resolver <- route53resolver_delete_outpost_resolver

#' Deletes a Resolver endpoint
#'
#' @description
#' Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends on whether it's an inbound or an outbound Resolver endpoint:
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_delete_resolver_endpoint/](https://www.paws-r-sdk.com/docs/route53resolver_delete_resolver_endpoint/) for full documentation.
#'
#' @param ResolverEndpointId &#91;required&#93; The ID of the Resolver endpoint that you want to delete.
#'
#' @keywords internal
#'
#' @rdname route53resolver_delete_resolver_endpoint
route53resolver_delete_resolver_endpoint <- function(ResolverEndpointId) {
  op <- new_operation(
    name = "DeleteResolverEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$delete_resolver_endpoint_input(ResolverEndpointId = ResolverEndpointId)
  output <- .route53resolver$delete_resolver_endpoint_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$delete_resolver_endpoint <- route53resolver_delete_resolver_endpoint

#' Deletes a query logging configuration
#'
#' @description
#' Deletes a query logging configuration. When you delete a configuration, Resolver stops logging DNS queries for all of the Amazon VPCs that are associated with the configuration. This also applies if the query logging configuration is shared with other Amazon Web Services accounts, and the other accounts have associated VPCs with the shared configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_delete_resolver_query_log_config/](https://www.paws-r-sdk.com/docs/route53resolver_delete_resolver_query_log_config/) for full documentation.
#'
#' @param ResolverQueryLogConfigId &#91;required&#93; The ID of the query logging configuration that you want to delete.
#'
#' @keywords internal
#'
#' @rdname route53resolver_delete_resolver_query_log_config
route53resolver_delete_resolver_query_log_config <- function(ResolverQueryLogConfigId) {
  op <- new_operation(
    name = "DeleteResolverQueryLogConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$delete_resolver_query_log_config_input(ResolverQueryLogConfigId = ResolverQueryLogConfigId)
  output <- .route53resolver$delete_resolver_query_log_config_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$delete_resolver_query_log_config <- route53resolver_delete_resolver_query_log_config

#' Deletes a Resolver rule
#'
#' @description
#' Deletes a Resolver rule. Before you can delete a Resolver rule, you must disassociate it from all the VPCs that you associated the Resolver rule with. For more information, see [`disassociate_resolver_rule`][route53resolver_disassociate_resolver_rule].
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_delete_resolver_rule/](https://www.paws-r-sdk.com/docs/route53resolver_delete_resolver_rule/) for full documentation.
#'
#' @param ResolverRuleId &#91;required&#93; The ID of the Resolver rule that you want to delete.
#'
#' @keywords internal
#'
#' @rdname route53resolver_delete_resolver_rule
route53resolver_delete_resolver_rule <- function(ResolverRuleId) {
  op <- new_operation(
    name = "DeleteResolverRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$delete_resolver_rule_input(ResolverRuleId = ResolverRuleId)
  output <- .route53resolver$delete_resolver_rule_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$delete_resolver_rule <- route53resolver_delete_resolver_rule

#' Disassociates a FirewallRuleGroup from a VPC, to remove DNS filtering
#' from the VPC
#'
#' @description
#' Disassociates a FirewallRuleGroup from a VPC, to remove DNS filtering from the VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_disassociate_firewall_rule_group/](https://www.paws-r-sdk.com/docs/route53resolver_disassociate_firewall_rule_group/) for full documentation.
#'
#' @param FirewallRuleGroupAssociationId &#91;required&#93; The identifier of the FirewallRuleGroupAssociation.
#'
#' @keywords internal
#'
#' @rdname route53resolver_disassociate_firewall_rule_group
route53resolver_disassociate_firewall_rule_group <- function(FirewallRuleGroupAssociationId) {
  op <- new_operation(
    name = "DisassociateFirewallRuleGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$disassociate_firewall_rule_group_input(FirewallRuleGroupAssociationId = FirewallRuleGroupAssociationId)
  output <- .route53resolver$disassociate_firewall_rule_group_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$disassociate_firewall_rule_group <- route53resolver_disassociate_firewall_rule_group

#' Removes IP addresses from an inbound or an outbound Resolver endpoint
#'
#' @description
#' Removes IP addresses from an inbound or an outbound Resolver endpoint. If you want to remove more than one IP address, submit one [`disassociate_resolver_endpoint_ip_address`][route53resolver_disassociate_resolver_endpoint_ip_address] request for each IP address.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_disassociate_resolver_endpoint_ip_address/](https://www.paws-r-sdk.com/docs/route53resolver_disassociate_resolver_endpoint_ip_address/) for full documentation.
#'
#' @param ResolverEndpointId &#91;required&#93; The ID of the Resolver endpoint that you want to disassociate an IP
#' address from.
#' @param IpAddress &#91;required&#93; The IPv4 address that you want to remove from a Resolver endpoint.
#'
#' @keywords internal
#'
#' @rdname route53resolver_disassociate_resolver_endpoint_ip_address
route53resolver_disassociate_resolver_endpoint_ip_address <- function(ResolverEndpointId, IpAddress) {
  op <- new_operation(
    name = "DisassociateResolverEndpointIpAddress",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$disassociate_resolver_endpoint_ip_address_input(ResolverEndpointId = ResolverEndpointId, IpAddress = IpAddress)
  output <- .route53resolver$disassociate_resolver_endpoint_ip_address_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$disassociate_resolver_endpoint_ip_address <- route53resolver_disassociate_resolver_endpoint_ip_address

#' Disassociates a VPC from a query logging configuration
#'
#' @description
#' Disassociates a VPC from a query logging configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_disassociate_resolver_query_log_config/](https://www.paws-r-sdk.com/docs/route53resolver_disassociate_resolver_query_log_config/) for full documentation.
#'
#' @param ResolverQueryLogConfigId &#91;required&#93; The ID of the query logging configuration that you want to disassociate
#' a specified VPC from.
#' @param ResourceId &#91;required&#93; The ID of the Amazon VPC that you want to disassociate from a specified
#' query logging configuration.
#'
#' @keywords internal
#'
#' @rdname route53resolver_disassociate_resolver_query_log_config
route53resolver_disassociate_resolver_query_log_config <- function(ResolverQueryLogConfigId, ResourceId) {
  op <- new_operation(
    name = "DisassociateResolverQueryLogConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$disassociate_resolver_query_log_config_input(ResolverQueryLogConfigId = ResolverQueryLogConfigId, ResourceId = ResourceId)
  output <- .route53resolver$disassociate_resolver_query_log_config_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$disassociate_resolver_query_log_config <- route53resolver_disassociate_resolver_query_log_config

#' Removes the association between a specified Resolver rule and a
#' specified VPC
#'
#' @description
#' Removes the association between a specified Resolver rule and a specified VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_disassociate_resolver_rule/](https://www.paws-r-sdk.com/docs/route53resolver_disassociate_resolver_rule/) for full documentation.
#'
#' @param VPCId &#91;required&#93; The ID of the VPC that you want to disassociate the Resolver rule from.
#' @param ResolverRuleId &#91;required&#93; The ID of the Resolver rule that you want to disassociate from the
#' specified VPC.
#'
#' @keywords internal
#'
#' @rdname route53resolver_disassociate_resolver_rule
route53resolver_disassociate_resolver_rule <- function(VPCId, ResolverRuleId) {
  op <- new_operation(
    name = "DisassociateResolverRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$disassociate_resolver_rule_input(VPCId = VPCId, ResolverRuleId = ResolverRuleId)
  output <- .route53resolver$disassociate_resolver_rule_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$disassociate_resolver_rule <- route53resolver_disassociate_resolver_rule

#' Retrieves the configuration of the firewall behavior provided by DNS
#' Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC)
#'
#' @description
#' Retrieves the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC).
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_get_firewall_config/](https://www.paws-r-sdk.com/docs/route53resolver_get_firewall_config/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The ID of the VPC from Amazon VPC that the configuration is for.
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_firewall_config
route53resolver_get_firewall_config <- function(ResourceId) {
  op <- new_operation(
    name = "GetFirewallConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$get_firewall_config_input(ResourceId = ResourceId)
  output <- .route53resolver$get_firewall_config_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_firewall_config <- route53resolver_get_firewall_config

#' Retrieves the specified firewall domain list
#'
#' @description
#' Retrieves the specified firewall domain list.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_get_firewall_domain_list/](https://www.paws-r-sdk.com/docs/route53resolver_get_firewall_domain_list/) for full documentation.
#'
#' @param FirewallDomainListId &#91;required&#93; The ID of the domain list.
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_firewall_domain_list
route53resolver_get_firewall_domain_list <- function(FirewallDomainListId) {
  op <- new_operation(
    name = "GetFirewallDomainList",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$get_firewall_domain_list_input(FirewallDomainListId = FirewallDomainListId)
  output <- .route53resolver$get_firewall_domain_list_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_firewall_domain_list <- route53resolver_get_firewall_domain_list

#' Retrieves the specified firewall rule group
#'
#' @description
#' Retrieves the specified firewall rule group.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_get_firewall_rule_group/](https://www.paws-r-sdk.com/docs/route53resolver_get_firewall_rule_group/) for full documentation.
#'
#' @param FirewallRuleGroupId &#91;required&#93; The unique identifier of the firewall rule group.
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_firewall_rule_group
route53resolver_get_firewall_rule_group <- function(FirewallRuleGroupId) {
  op <- new_operation(
    name = "GetFirewallRuleGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$get_firewall_rule_group_input(FirewallRuleGroupId = FirewallRuleGroupId)
  output <- .route53resolver$get_firewall_rule_group_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_firewall_rule_group <- route53resolver_get_firewall_rule_group

#' Retrieves a firewall rule group association, which enables DNS filtering
#' for a VPC with one rule group
#'
#' @description
#' Retrieves a firewall rule group association, which enables DNS filtering for a VPC with one rule group. A VPC can have more than one firewall rule group association, and a rule group can be associated with more than one VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_get_firewall_rule_group_association/](https://www.paws-r-sdk.com/docs/route53resolver_get_firewall_rule_group_association/) for full documentation.
#'
#' @param FirewallRuleGroupAssociationId &#91;required&#93; The identifier of the FirewallRuleGroupAssociation.
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_firewall_rule_group_association
route53resolver_get_firewall_rule_group_association <- function(FirewallRuleGroupAssociationId) {
  op <- new_operation(
    name = "GetFirewallRuleGroupAssociation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$get_firewall_rule_group_association_input(FirewallRuleGroupAssociationId = FirewallRuleGroupAssociationId)
  output <- .route53resolver$get_firewall_rule_group_association_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_firewall_rule_group_association <- route53resolver_get_firewall_rule_group_association

#' Returns the Identity and Access Management (Amazon Web Services IAM)
#' policy for sharing the specified rule group
#'
#' @description
#' Returns the Identity and Access Management (Amazon Web Services IAM) policy for sharing the specified rule group. You can use the policy to share the rule group using Resource Access Manager (RAM).
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_get_firewall_rule_group_policy/](https://www.paws-r-sdk.com/docs/route53resolver_get_firewall_rule_group_policy/) for full documentation.
#'
#' @param Arn &#91;required&#93; The ARN (Amazon Resource Name) for the rule group.
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_firewall_rule_group_policy
route53resolver_get_firewall_rule_group_policy <- function(Arn) {
  op <- new_operation(
    name = "GetFirewallRuleGroupPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$get_firewall_rule_group_policy_input(Arn = Arn)
  output <- .route53resolver$get_firewall_rule_group_policy_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_firewall_rule_group_policy <- route53resolver_get_firewall_rule_group_policy

#' Gets information about a specified Resolver on the Outpost, such as its
#' instance count and type, name, and the current status of the Resolver
#'
#' @description
#' Gets information about a specified Resolver on the Outpost, such as its instance count and type, name, and the current status of the Resolver.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_get_outpost_resolver/](https://www.paws-r-sdk.com/docs/route53resolver_get_outpost_resolver/) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the Resolver on the Outpost.
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_outpost_resolver
route53resolver_get_outpost_resolver <- function(Id) {
  op <- new_operation(
    name = "GetOutpostResolver",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$get_outpost_resolver_input(Id = Id)
  output <- .route53resolver$get_outpost_resolver_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_outpost_resolver <- route53resolver_get_outpost_resolver

#' Retrieves the behavior configuration of Route 53 Resolver behavior for a
#' single VPC from Amazon Virtual Private Cloud
#'
#' @description
#' Retrieves the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private Cloud.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_config/](https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_config/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; Resource ID of the Amazon VPC that you want to get information about.
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_resolver_config
route53resolver_get_resolver_config <- function(ResourceId) {
  op <- new_operation(
    name = "GetResolverConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$get_resolver_config_input(ResourceId = ResourceId)
  output <- .route53resolver$get_resolver_config_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_resolver_config <- route53resolver_get_resolver_config

#' Gets DNSSEC validation information for a specified resource
#'
#' @description
#' Gets DNSSEC validation information for a specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_dnssec_config/](https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_dnssec_config/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The ID of the virtual private cloud (VPC) for the DNSSEC validation
#' status.
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_resolver_dnssec_config
route53resolver_get_resolver_dnssec_config <- function(ResourceId) {
  op <- new_operation(
    name = "GetResolverDnssecConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$get_resolver_dnssec_config_input(ResourceId = ResourceId)
  output <- .route53resolver$get_resolver_dnssec_config_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_resolver_dnssec_config <- route53resolver_get_resolver_dnssec_config

#' Gets information about a specified Resolver endpoint, such as whether
#' it's an inbound or an outbound Resolver endpoint, and the current status
#' of the endpoint
#'
#' @description
#' Gets information about a specified Resolver endpoint, such as whether it's an inbound or an outbound Resolver endpoint, and the current status of the endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_endpoint/](https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_endpoint/) for full documentation.
#'
#' @param ResolverEndpointId &#91;required&#93; The ID of the Resolver endpoint that you want to get information about.
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_resolver_endpoint
route53resolver_get_resolver_endpoint <- function(ResolverEndpointId) {
  op <- new_operation(
    name = "GetResolverEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$get_resolver_endpoint_input(ResolverEndpointId = ResolverEndpointId)
  output <- .route53resolver$get_resolver_endpoint_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_resolver_endpoint <- route53resolver_get_resolver_endpoint

#' Gets information about a specified Resolver query logging configuration,
#' such as the number of VPCs that the configuration is logging queries for
#' and the location that logs are sent to
#'
#' @description
#' Gets information about a specified Resolver query logging configuration, such as the number of VPCs that the configuration is logging queries for and the location that logs are sent to.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_query_log_config/](https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_query_log_config/) for full documentation.
#'
#' @param ResolverQueryLogConfigId &#91;required&#93; The ID of the Resolver query logging configuration that you want to get
#' information about.
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_resolver_query_log_config
route53resolver_get_resolver_query_log_config <- function(ResolverQueryLogConfigId) {
  op <- new_operation(
    name = "GetResolverQueryLogConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$get_resolver_query_log_config_input(ResolverQueryLogConfigId = ResolverQueryLogConfigId)
  output <- .route53resolver$get_resolver_query_log_config_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_resolver_query_log_config <- route53resolver_get_resolver_query_log_config

#' Gets information about a specified association between a Resolver query
#' logging configuration and an Amazon VPC
#'
#' @description
#' Gets information about a specified association between a Resolver query logging configuration and an Amazon VPC. When you associate a VPC with a query logging configuration, Resolver logs DNS queries that originate in that VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_query_log_config_association/](https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_query_log_config_association/) for full documentation.
#'
#' @param ResolverQueryLogConfigAssociationId &#91;required&#93; The ID of the Resolver query logging configuration association that you
#' want to get information about.
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_resolver_query_log_config_association
route53resolver_get_resolver_query_log_config_association <- function(ResolverQueryLogConfigAssociationId) {
  op <- new_operation(
    name = "GetResolverQueryLogConfigAssociation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$get_resolver_query_log_config_association_input(ResolverQueryLogConfigAssociationId = ResolverQueryLogConfigAssociationId)
  output <- .route53resolver$get_resolver_query_log_config_association_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_resolver_query_log_config_association <- route53resolver_get_resolver_query_log_config_association

#' Gets information about a query logging policy
#'
#' @description
#' Gets information about a query logging policy. A query logging policy specifies the Resolver query logging operations and resources that you want to allow another Amazon Web Services account to be able to use.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_query_log_config_policy/](https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_query_log_config_policy/) for full documentation.
#'
#' @param Arn &#91;required&#93; The ARN of the query logging configuration that you want to get the
#' query logging policy for.
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_resolver_query_log_config_policy
route53resolver_get_resolver_query_log_config_policy <- function(Arn) {
  op <- new_operation(
    name = "GetResolverQueryLogConfigPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$get_resolver_query_log_config_policy_input(Arn = Arn)
  output <- .route53resolver$get_resolver_query_log_config_policy_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_resolver_query_log_config_policy <- route53resolver_get_resolver_query_log_config_policy

#' Gets information about a specified Resolver rule, such as the domain
#' name that the rule forwards DNS queries for and the ID of the outbound
#' Resolver endpoint that the rule is associated with
#'
#' @description
#' Gets information about a specified Resolver rule, such as the domain name that the rule forwards DNS queries for and the ID of the outbound Resolver endpoint that the rule is associated with.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_rule/](https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_rule/) for full documentation.
#'
#' @param ResolverRuleId &#91;required&#93; The ID of the Resolver rule that you want to get information about.
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_resolver_rule
route53resolver_get_resolver_rule <- function(ResolverRuleId) {
  op <- new_operation(
    name = "GetResolverRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$get_resolver_rule_input(ResolverRuleId = ResolverRuleId)
  output <- .route53resolver$get_resolver_rule_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_resolver_rule <- route53resolver_get_resolver_rule

#' Gets information about an association between a specified Resolver rule
#' and a VPC
#'
#' @description
#' Gets information about an association between a specified Resolver rule and a VPC. You associate a Resolver rule and a VPC using [`associate_resolver_rule`][route53resolver_associate_resolver_rule].
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_rule_association/](https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_rule_association/) for full documentation.
#'
#' @param ResolverRuleAssociationId &#91;required&#93; The ID of the Resolver rule association that you want to get information
#' about.
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_resolver_rule_association
route53resolver_get_resolver_rule_association <- function(ResolverRuleAssociationId) {
  op <- new_operation(
    name = "GetResolverRuleAssociation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$get_resolver_rule_association_input(ResolverRuleAssociationId = ResolverRuleAssociationId)
  output <- .route53resolver$get_resolver_rule_association_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_resolver_rule_association <- route53resolver_get_resolver_rule_association

#' Gets information about the Resolver rule policy for a specified rule
#'
#' @description
#' Gets information about the Resolver rule policy for a specified rule. A Resolver rule policy includes the rule that you want to share with another account, the account that you want to share the rule with, and the Resolver operations that you want to allow the account to use.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_rule_policy/](https://www.paws-r-sdk.com/docs/route53resolver_get_resolver_rule_policy/) for full documentation.
#'
#' @param Arn &#91;required&#93; The ID of the Resolver rule that you want to get the Resolver rule
#' policy for.
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_resolver_rule_policy
route53resolver_get_resolver_rule_policy <- function(Arn) {
  op <- new_operation(
    name = "GetResolverRulePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$get_resolver_rule_policy_input(Arn = Arn)
  output <- .route53resolver$get_resolver_rule_policy_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_resolver_rule_policy <- route53resolver_get_resolver_rule_policy

#' Imports domain names from a file into a domain list, for use in a DNS
#' firewall rule group
#'
#' @description
#' Imports domain names from a file into a domain list, for use in a DNS firewall rule group.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_import_firewall_domains/](https://www.paws-r-sdk.com/docs/route53resolver_import_firewall_domains/) for full documentation.
#'
#' @param FirewallDomainListId &#91;required&#93; The ID of the domain list that you want to modify with the import
#' operation.
#' @param Operation &#91;required&#93; What you want DNS Firewall to do with the domains that are listed in the
#' file. This must be set to `REPLACE`, which updates the domain list to
#' exactly match the list in the file.
#' @param DomainFileUrl &#91;required&#93; The fully qualified URL or URI of the file stored in Amazon Simple
#' Storage Service (Amazon S3) that contains the list of domains to import.
#' 
#' The file must be in an S3 bucket that's in the same Region as your DNS
#' Firewall. The file must be a text file and must contain a single domain
#' per line.
#'
#' @keywords internal
#'
#' @rdname route53resolver_import_firewall_domains
route53resolver_import_firewall_domains <- function(FirewallDomainListId, Operation, DomainFileUrl) {
  op <- new_operation(
    name = "ImportFirewallDomains",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$import_firewall_domains_input(FirewallDomainListId = FirewallDomainListId, Operation = Operation, DomainFileUrl = DomainFileUrl)
  output <- .route53resolver$import_firewall_domains_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$import_firewall_domains <- route53resolver_import_firewall_domains

#' Retrieves the firewall configurations that you have defined
#'
#' @description
#' Retrieves the firewall configurations that you have defined. DNS Firewall uses the configurations to manage firewall behavior for your VPCs.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_list_firewall_configs/](https://www.paws-r-sdk.com/docs/route53resolver_list_firewall_configs/) for full documentation.
#'
#' @param MaxResults The maximum number of objects that you want Resolver to return for this
#' request. If more objects are available, in the response, Resolver
#' provides a `NextToken` value that you can use in a subsequent call to
#' get the next batch of objects.
#' 
#' If you don't specify a value for `MaxResults`, Resolver returns up to
#' 100 objects.
#' @param NextToken For the first call to this list request, omit this value.
#' 
#' When you request a list of objects, Resolver returns at most the number
#' of objects specified in `MaxResults`. If more objects are available for
#' retrieval, Resolver returns a `NextToken` value in the response. To
#' retrieve the next batch of objects, use the token that was returned for
#' the prior request in your next request.
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_firewall_configs
route53resolver_list_firewall_configs <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFirewallConfigs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "FirewallConfigs"),
    stream_api = FALSE
  )
  input <- .route53resolver$list_firewall_configs_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53resolver$list_firewall_configs_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_firewall_configs <- route53resolver_list_firewall_configs

#' Retrieves the firewall domain lists that you have defined
#'
#' @description
#' Retrieves the firewall domain lists that you have defined. For each firewall domain list, you can retrieve the domains that are defined for a list by calling [`list_firewall_domains`][route53resolver_list_firewall_domains].
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_list_firewall_domain_lists/](https://www.paws-r-sdk.com/docs/route53resolver_list_firewall_domain_lists/) for full documentation.
#'
#' @param MaxResults The maximum number of objects that you want Resolver to return for this
#' request. If more objects are available, in the response, Resolver
#' provides a `NextToken` value that you can use in a subsequent call to
#' get the next batch of objects.
#' 
#' If you don't specify a value for `MaxResults`, Resolver returns up to
#' 100 objects.
#' @param NextToken For the first call to this list request, omit this value.
#' 
#' When you request a list of objects, Resolver returns at most the number
#' of objects specified in `MaxResults`. If more objects are available for
#' retrieval, Resolver returns a `NextToken` value in the response. To
#' retrieve the next batch of objects, use the token that was returned for
#' the prior request in your next request.
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_firewall_domain_lists
route53resolver_list_firewall_domain_lists <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFirewallDomainLists",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "FirewallDomainLists"),
    stream_api = FALSE
  )
  input <- .route53resolver$list_firewall_domain_lists_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53resolver$list_firewall_domain_lists_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_firewall_domain_lists <- route53resolver_list_firewall_domain_lists

#' Retrieves the domains that you have defined for the specified firewall
#' domain list
#'
#' @description
#' Retrieves the domains that you have defined for the specified firewall domain list.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_list_firewall_domains/](https://www.paws-r-sdk.com/docs/route53resolver_list_firewall_domains/) for full documentation.
#'
#' @param FirewallDomainListId &#91;required&#93; The ID of the domain list whose domains you want to retrieve.
#' @param MaxResults The maximum number of objects that you want Resolver to return for this
#' request. If more objects are available, in the response, Resolver
#' provides a `NextToken` value that you can use in a subsequent call to
#' get the next batch of objects.
#' 
#' If you don't specify a value for `MaxResults`, Resolver returns up to
#' 100 objects.
#' @param NextToken For the first call to this list request, omit this value.
#' 
#' When you request a list of objects, Resolver returns at most the number
#' of objects specified in `MaxResults`. If more objects are available for
#' retrieval, Resolver returns a `NextToken` value in the response. To
#' retrieve the next batch of objects, use the token that was returned for
#' the prior request in your next request.
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_firewall_domains
route53resolver_list_firewall_domains <- function(FirewallDomainListId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFirewallDomains",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Domains"),
    stream_api = FALSE
  )
  input <- .route53resolver$list_firewall_domains_input(FirewallDomainListId = FirewallDomainListId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53resolver$list_firewall_domains_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_firewall_domains <- route53resolver_list_firewall_domains

#' Retrieves the firewall rule group associations that you have defined
#'
#' @description
#' Retrieves the firewall rule group associations that you have defined. Each association enables DNS filtering for a VPC with one rule group.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_list_firewall_rule_group_associations/](https://www.paws-r-sdk.com/docs/route53resolver_list_firewall_rule_group_associations/) for full documentation.
#'
#' @param FirewallRuleGroupId The unique identifier of the firewall rule group that you want to
#' retrieve the associations for. Leave this blank to retrieve associations
#' for any rule group.
#' @param VpcId The unique identifier of the VPC that you want to retrieve the
#' associations for. Leave this blank to retrieve associations for any VPC.
#' @param Priority The setting that determines the processing order of the rule group among
#' the rule groups that are associated with a single VPC. DNS Firewall
#' filters VPC traffic starting from the rule group with the lowest numeric
#' priority setting.
#' @param Status The association `Status` setting that you want DNS Firewall to filter on
#' for the list. If you don't specify this, then DNS Firewall returns all
#' associations, regardless of status.
#' @param MaxResults The maximum number of objects that you want Resolver to return for this
#' request. If more objects are available, in the response, Resolver
#' provides a `NextToken` value that you can use in a subsequent call to
#' get the next batch of objects.
#' 
#' If you don't specify a value for `MaxResults`, Resolver returns up to
#' 100 objects.
#' @param NextToken For the first call to this list request, omit this value.
#' 
#' When you request a list of objects, Resolver returns at most the number
#' of objects specified in `MaxResults`. If more objects are available for
#' retrieval, Resolver returns a `NextToken` value in the response. To
#' retrieve the next batch of objects, use the token that was returned for
#' the prior request in your next request.
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_firewall_rule_group_associations
route53resolver_list_firewall_rule_group_associations <- function(FirewallRuleGroupId = NULL, VpcId = NULL, Priority = NULL, Status = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFirewallRuleGroupAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "FirewallRuleGroupAssociations"),
    stream_api = FALSE
  )
  input <- .route53resolver$list_firewall_rule_group_associations_input(FirewallRuleGroupId = FirewallRuleGroupId, VpcId = VpcId, Priority = Priority, Status = Status, MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53resolver$list_firewall_rule_group_associations_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_firewall_rule_group_associations <- route53resolver_list_firewall_rule_group_associations

#' Retrieves the minimal high-level information for the rule groups that
#' you have defined
#'
#' @description
#' Retrieves the minimal high-level information for the rule groups that you have defined.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_list_firewall_rule_groups/](https://www.paws-r-sdk.com/docs/route53resolver_list_firewall_rule_groups/) for full documentation.
#'
#' @param MaxResults The maximum number of objects that you want Resolver to return for this
#' request. If more objects are available, in the response, Resolver
#' provides a `NextToken` value that you can use in a subsequent call to
#' get the next batch of objects.
#' 
#' If you don't specify a value for `MaxResults`, Resolver returns up to
#' 100 objects.
#' @param NextToken For the first call to this list request, omit this value.
#' 
#' When you request a list of objects, Resolver returns at most the number
#' of objects specified in `MaxResults`. If more objects are available for
#' retrieval, Resolver returns a `NextToken` value in the response. To
#' retrieve the next batch of objects, use the token that was returned for
#' the prior request in your next request.
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_firewall_rule_groups
route53resolver_list_firewall_rule_groups <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFirewallRuleGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "FirewallRuleGroups"),
    stream_api = FALSE
  )
  input <- .route53resolver$list_firewall_rule_groups_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53resolver$list_firewall_rule_groups_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_firewall_rule_groups <- route53resolver_list_firewall_rule_groups

#' Retrieves the firewall rules that you have defined for the specified
#' firewall rule group
#'
#' @description
#' Retrieves the firewall rules that you have defined for the specified firewall rule group. DNS Firewall uses the rules in a rule group to filter DNS network traffic for a VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_list_firewall_rules/](https://www.paws-r-sdk.com/docs/route53resolver_list_firewall_rules/) for full documentation.
#'
#' @param FirewallRuleGroupId &#91;required&#93; The unique identifier of the firewall rule group that you want to
#' retrieve the rules for.
#' @param Priority Optional additional filter for the rules to retrieve.
#' 
#' The setting that determines the processing order of the rules in a rule
#' group. DNS Firewall processes the rules in a rule group by order of
#' priority, starting from the lowest setting.
#' @param Action Optional additional filter for the rules to retrieve.
#' 
#' The action that DNS Firewall should take on a DNS query when it matches
#' one of the domains in the rule's domain list, or a threat in a DNS
#' Firewall Advanced rule:
#' 
#' -   `ALLOW` - Permit the request to go through. Not availabe for DNS
#'     Firewall Advanced rules.
#' 
#' -   `ALERT` - Permit the request to go through but send an alert to the
#'     logs.
#' 
#' -   `BLOCK` - Disallow the request. If this is specified, additional
#'     handling details are provided in the rule's `BlockResponse` setting.
#' @param MaxResults The maximum number of objects that you want Resolver to return for this
#' request. If more objects are available, in the response, Resolver
#' provides a `NextToken` value that you can use in a subsequent call to
#' get the next batch of objects.
#' 
#' If you don't specify a value for `MaxResults`, Resolver returns up to
#' 100 objects.
#' @param NextToken For the first call to this list request, omit this value.
#' 
#' When you request a list of objects, Resolver returns at most the number
#' of objects specified in `MaxResults`. If more objects are available for
#' retrieval, Resolver returns a `NextToken` value in the response. To
#' retrieve the next batch of objects, use the token that was returned for
#' the prior request in your next request.
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_firewall_rules
route53resolver_list_firewall_rules <- function(FirewallRuleGroupId, Priority = NULL, Action = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFirewallRules",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "FirewallRules"),
    stream_api = FALSE
  )
  input <- .route53resolver$list_firewall_rules_input(FirewallRuleGroupId = FirewallRuleGroupId, Priority = Priority, Action = Action, MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53resolver$list_firewall_rules_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_firewall_rules <- route53resolver_list_firewall_rules

#' Lists all the Resolvers on Outposts that were created using the current
#' Amazon Web Services account
#'
#' @description
#' Lists all the Resolvers on Outposts that were created using the current Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_list_outpost_resolvers/](https://www.paws-r-sdk.com/docs/route53resolver_list_outpost_resolvers/) for full documentation.
#'
#' @param OutpostArn The Amazon Resource Name (ARN) of the Outpost.
#' @param MaxResults The maximum number of Resolvers on the Outpost that you want to return
#' in the response to a `ListOutpostResolver` request. If you don't specify
#' a value for `MaxResults`, the request returns up to 100 Resolvers.
#' @param NextToken For the first `ListOutpostResolver` request, omit this value.
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_outpost_resolvers
route53resolver_list_outpost_resolvers <- function(OutpostArn = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListOutpostResolvers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "OutpostResolvers"),
    stream_api = FALSE
  )
  input <- .route53resolver$list_outpost_resolvers_input(OutpostArn = OutpostArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53resolver$list_outpost_resolvers_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_outpost_resolvers <- route53resolver_list_outpost_resolvers

#' Retrieves the Resolver configurations that you have defined
#'
#' @description
#' Retrieves the Resolver configurations that you have defined. Route 53 Resolver uses the configurations to manage DNS resolution behavior for your VPCs.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_configs/](https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_configs/) for full documentation.
#'
#' @param MaxResults The maximum number of Resolver configurations that you want to return in
#' the response to a
#' [`list_resolver_configs`][route53resolver_list_resolver_configs]
#' request. If you don't specify a value for `MaxResults`, up to 100
#' Resolver configurations are returned.
#' @param NextToken (Optional) If the current Amazon Web Services account has more than
#' `MaxResults` Resolver configurations, use `NextToken` to get the second
#' and subsequent pages of results.
#' 
#' For the first
#' [`list_resolver_configs`][route53resolver_list_resolver_configs]
#' request, omit this value.
#' 
#' For the second and subsequent requests, get the value of `NextToken`
#' from the previous response and specify that value for `NextToken` in the
#' request.
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_resolver_configs
route53resolver_list_resolver_configs <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListResolverConfigs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ResolverConfigs"),
    stream_api = FALSE
  )
  input <- .route53resolver$list_resolver_configs_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53resolver$list_resolver_configs_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_resolver_configs <- route53resolver_list_resolver_configs

#' Lists the configurations for DNSSEC validation that are associated with
#' the current Amazon Web Services account
#'
#' @description
#' Lists the configurations for DNSSEC validation that are associated with the current Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_dnssec_configs/](https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_dnssec_configs/) for full documentation.
#'
#' @param MaxResults *Optional*: An integer that specifies the maximum number of DNSSEC
#' configuration results that you want Amazon Route 53 to return. If you
#' don't specify a value for `MaxResults`, Route 53 returns up to 100
#' configuration per page.
#' @param NextToken (Optional) If the current Amazon Web Services account has more than
#' `MaxResults` DNSSEC configurations, use `NextToken` to get the second
#' and subsequent pages of results.
#' 
#' For the first
#' [`list_resolver_dnssec_configs`][route53resolver_list_resolver_dnssec_configs]
#' request, omit this value.
#' 
#' For the second and subsequent requests, get the value of `NextToken`
#' from the previous response and specify that value for `NextToken` in the
#' request.
#' @param Filters An optional specification to return a subset of objects.
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_resolver_dnssec_configs
route53resolver_list_resolver_dnssec_configs <- function(MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListResolverDnssecConfigs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ResolverDnssecConfigs"),
    stream_api = FALSE
  )
  input <- .route53resolver$list_resolver_dnssec_configs_input(MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .route53resolver$list_resolver_dnssec_configs_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_resolver_dnssec_configs <- route53resolver_list_resolver_dnssec_configs

#' Gets the IP addresses for a specified Resolver endpoint
#'
#' @description
#' Gets the IP addresses for a specified Resolver endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_endpoint_ip_addresses/](https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_endpoint_ip_addresses/) for full documentation.
#'
#' @param ResolverEndpointId &#91;required&#93; The ID of the Resolver endpoint that you want to get IP addresses for.
#' @param MaxResults The maximum number of IP addresses that you want to return in the
#' response to a
#' [`list_resolver_endpoint_ip_addresses`][route53resolver_list_resolver_endpoint_ip_addresses]
#' request. If you don't specify a value for `MaxResults`, Resolver returns
#' up to 100 IP addresses.
#' @param NextToken For the first
#' [`list_resolver_endpoint_ip_addresses`][route53resolver_list_resolver_endpoint_ip_addresses]
#' request, omit this value.
#' 
#' If the specified Resolver endpoint has more than `MaxResults` IP
#' addresses, you can submit another
#' [`list_resolver_endpoint_ip_addresses`][route53resolver_list_resolver_endpoint_ip_addresses]
#' request to get the next group of IP addresses. In the next request,
#' specify the value of `NextToken` from the previous response.
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_resolver_endpoint_ip_addresses
route53resolver_list_resolver_endpoint_ip_addresses <- function(ResolverEndpointId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListResolverEndpointIpAddresses",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "IpAddresses"),
    stream_api = FALSE
  )
  input <- .route53resolver$list_resolver_endpoint_ip_addresses_input(ResolverEndpointId = ResolverEndpointId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53resolver$list_resolver_endpoint_ip_addresses_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_resolver_endpoint_ip_addresses <- route53resolver_list_resolver_endpoint_ip_addresses

#' Lists all the Resolver endpoints that were created using the current
#' Amazon Web Services account
#'
#' @description
#' Lists all the Resolver endpoints that were created using the current Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_endpoints/](https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_endpoints/) for full documentation.
#'
#' @param MaxResults The maximum number of Resolver endpoints that you want to return in the
#' response to a
#' [`list_resolver_endpoints`][route53resolver_list_resolver_endpoints]
#' request. If you don't specify a value for `MaxResults`, Resolver returns
#' up to 100 Resolver endpoints.
#' @param NextToken For the first
#' [`list_resolver_endpoints`][route53resolver_list_resolver_endpoints]
#' request, omit this value.
#' 
#' If you have more than `MaxResults` Resolver endpoints, you can submit
#' another
#' [`list_resolver_endpoints`][route53resolver_list_resolver_endpoints]
#' request to get the next group of Resolver endpoints. In the next
#' request, specify the value of `NextToken` from the previous response.
#' @param Filters An optional specification to return a subset of Resolver endpoints, such
#' as all inbound Resolver endpoints.
#' 
#' If you submit a second or subsequent
#' [`list_resolver_endpoints`][route53resolver_list_resolver_endpoints]
#' request and specify the `NextToken` parameter, you must use the same
#' values for `Filters`, if any, as in the previous request.
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_resolver_endpoints
route53resolver_list_resolver_endpoints <- function(MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListResolverEndpoints",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ResolverEndpoints"),
    stream_api = FALSE
  )
  input <- .route53resolver$list_resolver_endpoints_input(MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .route53resolver$list_resolver_endpoints_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_resolver_endpoints <- route53resolver_list_resolver_endpoints

#' Lists information about associations between Amazon VPCs and query
#' logging configurations
#'
#' @description
#' Lists information about associations between Amazon VPCs and query logging configurations.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_query_log_config_associations/](https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_query_log_config_associations/) for full documentation.
#'
#' @param MaxResults The maximum number of query logging associations that you want to return
#' in the response to a
#' [`list_resolver_query_log_config_associations`][route53resolver_list_resolver_query_log_config_associations]
#' request. If you don't specify a value for `MaxResults`, Resolver returns
#' up to 100 query logging associations.
#' @param NextToken For the first
#' [`list_resolver_query_log_config_associations`][route53resolver_list_resolver_query_log_config_associations]
#' request, omit this value.
#' 
#' If there are more than `MaxResults` query logging associations that
#' match the values that you specify for `Filters`, you can submit another
#' [`list_resolver_query_log_config_associations`][route53resolver_list_resolver_query_log_config_associations]
#' request to get the next group of associations. In the next request,
#' specify the value of `NextToken` from the previous response.
#' @param Filters An optional specification to return a subset of query logging
#' associations.
#' 
#' If you submit a second or subsequent
#' [`list_resolver_query_log_config_associations`][route53resolver_list_resolver_query_log_config_associations]
#' request and specify the `NextToken` parameter, you must use the same
#' values for `Filters`, if any, as in the previous request.
#' @param SortBy The element that you want Resolver to sort query logging associations
#' by.
#' 
#' If you submit a second or subsequent
#' [`list_resolver_query_log_config_associations`][route53resolver_list_resolver_query_log_config_associations]
#' request and specify the `NextToken` parameter, you must use the same
#' value for `SortBy`, if any, as in the previous request.
#' 
#' Valid values include the following elements:
#' 
#' -   `CreationTime`: The ID of the query logging association.
#' 
#' -   `Error`: If the value of `Status` is `FAILED`, the value of `Error`
#'     indicates the cause:
#' 
#'     -   `DESTINATION_NOT_FOUND`: The specified destination (for example,
#'         an Amazon S3 bucket) was deleted.
#' 
#'     -   `ACCESS_DENIED`: Permissions don't allow sending logs to the
#'         destination.
#' 
#'     If `Status` is a value other than `FAILED`, `ERROR` is null.
#' 
#' -   `Id`: The ID of the query logging association
#' 
#' -   `ResolverQueryLogConfigId`: The ID of the query logging
#'     configuration
#' 
#' -   `ResourceId`: The ID of the VPC that is associated with the query
#'     logging configuration
#' 
#' -   `Status`: The current status of the configuration. Valid values
#'     include the following:
#' 
#'     -   `CREATING`: Resolver is creating an association between an
#'         Amazon VPC and a query logging configuration.
#' 
#'     -   `CREATED`: The association between an Amazon VPC and a query
#'         logging configuration was successfully created. Resolver is
#'         logging queries that originate in the specified VPC.
#' 
#'     -   `DELETING`: Resolver is deleting this query logging association.
#' 
#'     -   `FAILED`: Resolver either couldn't create or couldn't delete the
#'         query logging association. Here are two common causes:
#' 
#'         -   The specified destination (for example, an Amazon S3 bucket)
#'             was deleted.
#' 
#'         -   Permissions don't allow sending logs to the destination.
#' @param SortOrder If you specified a value for `SortBy`, the order that you want query
#' logging associations to be listed in, `ASCENDING` or `DESCENDING`.
#' 
#' If you submit a second or subsequent
#' [`list_resolver_query_log_config_associations`][route53resolver_list_resolver_query_log_config_associations]
#' request and specify the `NextToken` parameter, you must use the same
#' value for `SortOrder`, if any, as in the previous request.
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_resolver_query_log_config_associations
route53resolver_list_resolver_query_log_config_associations <- function(MaxResults = NULL, NextToken = NULL, Filters = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListResolverQueryLogConfigAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ResolverQueryLogConfigAssociations"),
    stream_api = FALSE
  )
  input <- .route53resolver$list_resolver_query_log_config_associations_input(MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, SortBy = SortBy, SortOrder = SortOrder)
  output <- .route53resolver$list_resolver_query_log_config_associations_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_resolver_query_log_config_associations <- route53resolver_list_resolver_query_log_config_associations

#' Lists information about the specified query logging configurations
#'
#' @description
#' Lists information about the specified query logging configurations. Each configuration defines where you want Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_query_log_configs/](https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_query_log_configs/) for full documentation.
#'
#' @param MaxResults The maximum number of query logging configurations that you want to
#' return in the response to a
#' [`list_resolver_query_log_configs`][route53resolver_list_resolver_query_log_configs]
#' request. If you don't specify a value for `MaxResults`, Resolver returns
#' up to 100 query logging configurations.
#' @param NextToken For the first
#' [`list_resolver_query_log_configs`][route53resolver_list_resolver_query_log_configs]
#' request, omit this value.
#' 
#' If there are more than `MaxResults` query logging configurations that
#' match the values that you specify for `Filters`, you can submit another
#' [`list_resolver_query_log_configs`][route53resolver_list_resolver_query_log_configs]
#' request to get the next group of configurations. In the next request,
#' specify the value of `NextToken` from the previous response.
#' @param Filters An optional specification to return a subset of query logging
#' configurations.
#' 
#' If you submit a second or subsequent
#' [`list_resolver_query_log_configs`][route53resolver_list_resolver_query_log_configs]
#' request and specify the `NextToken` parameter, you must use the same
#' values for `Filters`, if any, as in the previous request.
#' @param SortBy The element that you want Resolver to sort query logging configurations
#' by.
#' 
#' If you submit a second or subsequent
#' [`list_resolver_query_log_configs`][route53resolver_list_resolver_query_log_configs]
#' request and specify the `NextToken` parameter, you must use the same
#' value for `SortBy`, if any, as in the previous request.
#' 
#' Valid values include the following elements:
#' 
#' -   `Arn`: The ARN of the query logging configuration
#' 
#' -   `AssociationCount`: The number of VPCs that are associated with the
#'     specified configuration
#' 
#' -   `CreationTime`: The date and time that Resolver returned when the
#'     configuration was created
#' 
#' -   `CreatorRequestId`: The value that was specified for
#'     `CreatorRequestId` when the configuration was created
#' 
#' -   `DestinationArn`: The location that logs are sent to
#' 
#' -   `Id`: The ID of the configuration
#' 
#' -   `Name`: The name of the configuration
#' 
#' -   `OwnerId`: The Amazon Web Services account number of the account
#'     that created the configuration
#' 
#' -   `ShareStatus`: Whether the configuration is shared with other Amazon
#'     Web Services accounts or shared with the current account by another
#'     Amazon Web Services account. Sharing is configured through Resource
#'     Access Manager (RAM).
#' 
#' -   `Status`: The current status of the configuration. Valid values
#'     include the following:
#' 
#'     -   `CREATING`: Resolver is creating the query logging
#'         configuration.
#' 
#'     -   `CREATED`: The query logging configuration was successfully
#'         created. Resolver is logging queries that originate in the
#'         specified VPC.
#' 
#'     -   `DELETING`: Resolver is deleting this query logging
#'         configuration.
#' 
#'     -   `FAILED`: Resolver either couldn't create or couldn't delete the
#'         query logging configuration. Here are two common causes:
#' 
#'         -   The specified destination (for example, an Amazon S3 bucket)
#'             was deleted.
#' 
#'         -   Permissions don't allow sending logs to the destination.
#' @param SortOrder If you specified a value for `SortBy`, the order that you want query
#' logging configurations to be listed in, `ASCENDING` or `DESCENDING`.
#' 
#' If you submit a second or subsequent
#' [`list_resolver_query_log_configs`][route53resolver_list_resolver_query_log_configs]
#' request and specify the `NextToken` parameter, you must use the same
#' value for `SortOrder`, if any, as in the previous request.
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_resolver_query_log_configs
route53resolver_list_resolver_query_log_configs <- function(MaxResults = NULL, NextToken = NULL, Filters = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListResolverQueryLogConfigs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ResolverQueryLogConfigs"),
    stream_api = FALSE
  )
  input <- .route53resolver$list_resolver_query_log_configs_input(MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, SortBy = SortBy, SortOrder = SortOrder)
  output <- .route53resolver$list_resolver_query_log_configs_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_resolver_query_log_configs <- route53resolver_list_resolver_query_log_configs

#' Lists the associations that were created between Resolver rules and VPCs
#' using the current Amazon Web Services account
#'
#' @description
#' Lists the associations that were created between Resolver rules and VPCs using the current Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_rule_associations/](https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_rule_associations/) for full documentation.
#'
#' @param MaxResults The maximum number of rule associations that you want to return in the
#' response to a
#' [`list_resolver_rule_associations`][route53resolver_list_resolver_rule_associations]
#' request. If you don't specify a value for `MaxResults`, Resolver returns
#' up to 100 rule associations.
#' @param NextToken For the first `ListResolverRuleAssociation` request, omit this value.
#' 
#' If you have more than `MaxResults` rule associations, you can submit
#' another `ListResolverRuleAssociation` request to get the next group of
#' rule associations. In the next request, specify the value of `NextToken`
#' from the previous response.
#' @param Filters An optional specification to return a subset of Resolver rules, such as
#' Resolver rules that are associated with the same VPC ID.
#' 
#' If you submit a second or subsequent
#' [`list_resolver_rule_associations`][route53resolver_list_resolver_rule_associations]
#' request and specify the `NextToken` parameter, you must use the same
#' values for `Filters`, if any, as in the previous request.
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_resolver_rule_associations
route53resolver_list_resolver_rule_associations <- function(MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListResolverRuleAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ResolverRuleAssociations"),
    stream_api = FALSE
  )
  input <- .route53resolver$list_resolver_rule_associations_input(MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .route53resolver$list_resolver_rule_associations_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_resolver_rule_associations <- route53resolver_list_resolver_rule_associations

#' Lists the Resolver rules that were created using the current Amazon Web
#' Services account
#'
#' @description
#' Lists the Resolver rules that were created using the current Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_rules/](https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_rules/) for full documentation.
#'
#' @param MaxResults The maximum number of Resolver rules that you want to return in the
#' response to a
#' [`list_resolver_rules`][route53resolver_list_resolver_rules] request. If
#' you don't specify a value for `MaxResults`, Resolver returns up to 100
#' Resolver rules.
#' @param NextToken For the first
#' [`list_resolver_rules`][route53resolver_list_resolver_rules] request,
#' omit this value.
#' 
#' If you have more than `MaxResults` Resolver rules, you can submit
#' another [`list_resolver_rules`][route53resolver_list_resolver_rules]
#' request to get the next group of Resolver rules. In the next request,
#' specify the value of `NextToken` from the previous response.
#' @param Filters An optional specification to return a subset of Resolver rules, such as
#' all Resolver rules that are associated with the same Resolver endpoint.
#' 
#' If you submit a second or subsequent
#' [`list_resolver_rules`][route53resolver_list_resolver_rules] request and
#' specify the `NextToken` parameter, you must use the same values for
#' `Filters`, if any, as in the previous request.
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_resolver_rules
route53resolver_list_resolver_rules <- function(MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListResolverRules",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ResolverRules"),
    stream_api = FALSE
  )
  input <- .route53resolver$list_resolver_rules_input(MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .route53resolver$list_resolver_rules_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_resolver_rules <- route53resolver_list_resolver_rules

#' Lists the tags that you associated with the specified resource
#'
#' @description
#' Lists the tags that you associated with the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/route53resolver_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource that you want to list
#' tags for.
#' @param MaxResults The maximum number of tags that you want to return in the response to a
#' [`list_tags_for_resource`][route53resolver_list_tags_for_resource]
#' request. If you don't specify a value for `MaxResults`, Resolver returns
#' up to 100 tags.
#' @param NextToken For the first
#' [`list_tags_for_resource`][route53resolver_list_tags_for_resource]
#' request, omit this value.
#' 
#' If you have more than `MaxResults` tags, you can submit another
#' [`list_tags_for_resource`][route53resolver_list_tags_for_resource]
#' request to get the next group of tags for the resource. In the next
#' request, specify the value of `NextToken` from the previous response.
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_tags_for_resource
route53resolver_list_tags_for_resource <- function(ResourceArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Tags"),
    stream_api = FALSE
  )
  input <- .route53resolver$list_tags_for_resource_input(ResourceArn = ResourceArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53resolver$list_tags_for_resource_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_tags_for_resource <- route53resolver_list_tags_for_resource

#' Attaches an Identity and Access Management (Amazon Web Services IAM)
#' policy for sharing the rule group
#'
#' @description
#' Attaches an Identity and Access Management (Amazon Web Services IAM) policy for sharing the rule group. You can use the policy to share the rule group using Resource Access Manager (RAM).
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_put_firewall_rule_group_policy/](https://www.paws-r-sdk.com/docs/route53resolver_put_firewall_rule_group_policy/) for full documentation.
#'
#' @param Arn &#91;required&#93; The ARN (Amazon Resource Name) for the rule group that you want to
#' share.
#' @param FirewallRuleGroupPolicy &#91;required&#93; The Identity and Access Management (Amazon Web Services IAM) policy to
#' attach to the rule group.
#'
#' @keywords internal
#'
#' @rdname route53resolver_put_firewall_rule_group_policy
route53resolver_put_firewall_rule_group_policy <- function(Arn, FirewallRuleGroupPolicy) {
  op <- new_operation(
    name = "PutFirewallRuleGroupPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$put_firewall_rule_group_policy_input(Arn = Arn, FirewallRuleGroupPolicy = FirewallRuleGroupPolicy)
  output <- .route53resolver$put_firewall_rule_group_policy_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$put_firewall_rule_group_policy <- route53resolver_put_firewall_rule_group_policy

#' Specifies an Amazon Web Services account that you want to share a query
#' logging configuration with, the query logging configuration that you
#' want to share, and the operations that you want the account to be able
#' to perform on the configuration
#'
#' @description
#' Specifies an Amazon Web Services account that you want to share a query logging configuration with, the query logging configuration that you want to share, and the operations that you want the account to be able to perform on the configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_put_resolver_query_log_config_policy/](https://www.paws-r-sdk.com/docs/route53resolver_put_resolver_query_log_config_policy/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the account that you want to share
#' rules with.
#' @param ResolverQueryLogConfigPolicy &#91;required&#93; An Identity and Access Management policy statement that lists the query
#' logging configurations that you want to share with another Amazon Web
#' Services account and the operations that you want the account to be able
#' to perform. You can specify the following operations in the `Actions`
#' section of the statement:
#' 
#' -   `route53resolver:AssociateResolverQueryLogConfig`
#' 
#' -   `route53resolver:DisassociateResolverQueryLogConfig`
#' 
#' -   `route53resolver:ListResolverQueryLogConfigs`
#' 
#' In the `Resource` section of the statement, you specify the ARNs for the
#' query logging configurations that you want to share with the account
#' that you specified in `Arn`.
#'
#' @keywords internal
#'
#' @rdname route53resolver_put_resolver_query_log_config_policy
route53resolver_put_resolver_query_log_config_policy <- function(Arn, ResolverQueryLogConfigPolicy) {
  op <- new_operation(
    name = "PutResolverQueryLogConfigPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$put_resolver_query_log_config_policy_input(Arn = Arn, ResolverQueryLogConfigPolicy = ResolverQueryLogConfigPolicy)
  output <- .route53resolver$put_resolver_query_log_config_policy_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$put_resolver_query_log_config_policy <- route53resolver_put_resolver_query_log_config_policy

#' Specifies an Amazon Web Services rule that you want to share with
#' another account, the account that you want to share the rule with, and
#' the operations that you want the account to be able to perform on the
#' rule
#'
#' @description
#' Specifies an Amazon Web Services rule that you want to share with another account, the account that you want to share the rule with, and the operations that you want the account to be able to perform on the rule.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_put_resolver_rule_policy/](https://www.paws-r-sdk.com/docs/route53resolver_put_resolver_rule_policy/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the rule that you want to share with
#' another account.
#' @param ResolverRulePolicy &#91;required&#93; An Identity and Access Management policy statement that lists the rules
#' that you want to share with another Amazon Web Services account and the
#' operations that you want the account to be able to perform. You can
#' specify the following operations in the `Action` section of the
#' statement:
#' 
#' -   `route53resolver:GetResolverRule`
#' 
#' -   `route53resolver:AssociateResolverRule`
#' 
#' -   `route53resolver:DisassociateResolverRule`
#' 
#' -   `route53resolver:ListResolverRules`
#' 
#' -   `route53resolver:ListResolverRuleAssociations`
#' 
#' In the `Resource` section of the statement, specify the ARN for the rule
#' that you want to share with another account. Specify the same ARN that
#' you specified in `Arn`.
#'
#' @keywords internal
#'
#' @rdname route53resolver_put_resolver_rule_policy
route53resolver_put_resolver_rule_policy <- function(Arn, ResolverRulePolicy) {
  op <- new_operation(
    name = "PutResolverRulePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$put_resolver_rule_policy_input(Arn = Arn, ResolverRulePolicy = ResolverRulePolicy)
  output <- .route53resolver$put_resolver_rule_policy_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$put_resolver_rule_policy <- route53resolver_put_resolver_rule_policy

#' Adds one or more tags to a specified resource
#'
#' @description
#' Adds one or more tags to a specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_tag_resource/](https://www.paws-r-sdk.com/docs/route53resolver_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource that you want to add
#' tags to. To get the ARN for a resource, use the applicable `Get` or
#' `List` command:
#' 
#' -   [`get_resolver_endpoint`][route53resolver_get_resolver_endpoint]
#' 
#' -   [`get_resolver_rule`][route53resolver_get_resolver_rule]
#' 
#' -   [`get_resolver_rule_association`][route53resolver_get_resolver_rule_association]
#' 
#' -   [`list_resolver_endpoints`][route53resolver_list_resolver_endpoints]
#' 
#' -   [`list_resolver_rule_associations`][route53resolver_list_resolver_rule_associations]
#' 
#' -   [`list_resolver_rules`][route53resolver_list_resolver_rules]
#' @param Tags &#91;required&#93; The tags that you want to add to the specified resource.
#'
#' @keywords internal
#'
#' @rdname route53resolver_tag_resource
route53resolver_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .route53resolver$tag_resource_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$tag_resource <- route53resolver_tag_resource

#' Removes one or more tags from a specified resource
#'
#' @description
#' Removes one or more tags from a specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_untag_resource/](https://www.paws-r-sdk.com/docs/route53resolver_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource that you want to remove
#' tags from. To get the ARN for a resource, use the applicable `Get` or
#' `List` command:
#' 
#' -   [`get_resolver_endpoint`][route53resolver_get_resolver_endpoint]
#' 
#' -   [`get_resolver_rule`][route53resolver_get_resolver_rule]
#' 
#' -   [`get_resolver_rule_association`][route53resolver_get_resolver_rule_association]
#' 
#' -   [`list_resolver_endpoints`][route53resolver_list_resolver_endpoints]
#' 
#' -   [`list_resolver_rule_associations`][route53resolver_list_resolver_rule_associations]
#' 
#' -   [`list_resolver_rules`][route53resolver_list_resolver_rules]
#' @param TagKeys &#91;required&#93; The tags that you want to remove to the specified resource.
#'
#' @keywords internal
#'
#' @rdname route53resolver_untag_resource
route53resolver_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .route53resolver$untag_resource_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$untag_resource <- route53resolver_untag_resource

#' Updates the configuration of the firewall behavior provided by DNS
#' Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC)
#'
#' @description
#' Updates the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC).
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_update_firewall_config/](https://www.paws-r-sdk.com/docs/route53resolver_update_firewall_config/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The ID of the VPC that the configuration is for.
#' @param FirewallFailOpen &#91;required&#93; Determines how Route 53 Resolver handles queries during failures, for
#' example when all traffic that is sent to DNS Firewall fails to receive a
#' reply.
#' 
#' -   By default, fail open is disabled, which means the failure mode is
#'     closed. This approach favors security over availability. DNS
#'     Firewall blocks queries that it is unable to evaluate properly.
#' 
#' -   If you enable this option, the failure mode is open. This approach
#'     favors availability over security. DNS Firewall allows queries to
#'     proceed if it is unable to properly evaluate them.
#' 
#' This behavior is only enforced for VPCs that have at least one DNS
#' Firewall rule group association.
#'
#' @keywords internal
#'
#' @rdname route53resolver_update_firewall_config
route53resolver_update_firewall_config <- function(ResourceId, FirewallFailOpen) {
  op <- new_operation(
    name = "UpdateFirewallConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$update_firewall_config_input(ResourceId = ResourceId, FirewallFailOpen = FirewallFailOpen)
  output <- .route53resolver$update_firewall_config_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$update_firewall_config <- route53resolver_update_firewall_config

#' Updates the firewall domain list from an array of domain specifications
#'
#' @description
#' Updates the firewall domain list from an array of domain specifications.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_update_firewall_domains/](https://www.paws-r-sdk.com/docs/route53resolver_update_firewall_domains/) for full documentation.
#'
#' @param FirewallDomainListId &#91;required&#93; The ID of the domain list whose domains you want to update.
#' @param Operation &#91;required&#93; What you want DNS Firewall to do with the domains that you are
#' providing:
#' 
#' -   `ADD` - Add the domains to the ones that are already in the domain
#'     list.
#' 
#' -   `REMOVE` - Search the domain list for the domains and remove them
#'     from the list.
#' 
#' -   `REPLACE` - Update the domain list to exactly match the list that
#'     you are providing.
#' @param Domains &#91;required&#93; A list of domains to use in the update operation.
#' 
#' There is a limit of 1000 domains per request.
#' 
#' Each domain specification in your domain list must satisfy the following
#' requirements:
#' 
#' -   It can optionally start with `*` (asterisk).
#' 
#' -   With the exception of the optional starting asterisk, it must only
#'     contain the following characters: `A-Z`, `a-z`, `0-9`, `-` (hyphen).
#' 
#' -   It must be from 1-255 characters in length.
#'
#' @keywords internal
#'
#' @rdname route53resolver_update_firewall_domains
route53resolver_update_firewall_domains <- function(FirewallDomainListId, Operation, Domains) {
  op <- new_operation(
    name = "UpdateFirewallDomains",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$update_firewall_domains_input(FirewallDomainListId = FirewallDomainListId, Operation = Operation, Domains = Domains)
  output <- .route53resolver$update_firewall_domains_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$update_firewall_domains <- route53resolver_update_firewall_domains

#' Updates the specified firewall rule
#'
#' @description
#' Updates the specified firewall rule.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_update_firewall_rule/](https://www.paws-r-sdk.com/docs/route53resolver_update_firewall_rule/) for full documentation.
#'
#' @param FirewallRuleGroupId &#91;required&#93; The unique identifier of the firewall rule group for the rule.
#' @param FirewallDomainListId The ID of the domain list to use in the rule.
#' @param FirewallThreatProtectionId The DNS Firewall Advanced rule ID.
#' @param Priority The setting that determines the processing order of the rule in the rule
#' group. DNS Firewall processes the rules in a rule group by order of
#' priority, starting from the lowest setting.
#' 
#' You must specify a unique priority for each rule in a rule group. To
#' make it easier to insert rules later, leave space between the numbers,
#' for example, use 100, 200, and so on. You can change the priority
#' setting for the rules in a rule group at any time.
#' @param Action The action that DNS Firewall should take on a DNS query when it matches
#' one of the domains in the rule's domain list, or a threat in a DNS
#' Firewall Advanced rule:
#' 
#' -   `ALLOW` - Permit the request to go through. Not available for DNS
#'     Firewall Advanced rules.
#' 
#' -   `ALERT` - Permit the request to go through but send an alert to the
#'     logs.
#' 
#' -   `BLOCK` - Disallow the request. This option requires additional
#'     details in the rule's `BlockResponse`.
#' @param BlockResponse The way that you want DNS Firewall to block the request. Used for the
#' rule action setting `BLOCK`.
#' 
#' -   `NODATA` - Respond indicating that the query was successful, but no
#'     response is available for it.
#' 
#' -   `NXDOMAIN` - Respond indicating that the domain name that's in the
#'     query doesn't exist.
#' 
#' -   `OVERRIDE` - Provide a custom override in the response. This option
#'     requires custom handling details in the rule's `BlockOverride*`
#'     settings.
#' @param BlockOverrideDomain The custom DNS record to send back in response to the query. Used for
#' the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
#' @param BlockOverrideDnsType The DNS record's type. This determines the format of the record value
#' that you provided in `BlockOverrideDomain`. Used for the rule action
#' `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
#' @param BlockOverrideTtl The recommended amount of time, in seconds, for the DNS resolver or web
#' browser to cache the provided override record. Used for the rule action
#' `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
#' @param Name The name of the rule.
#' @param FirewallDomainRedirectionAction How you want the the rule to evaluate DNS redirection in the DNS
#' redirection chain, such as CNAME or DNAME.
#' 
#' `INSPECT_REDIRECTION_DOMAIN`: (Default) inspects all domains in the
#' redirection chain. The individual domains in the redirection chain must
#' be added to the domain list.
#' 
#' `TRUST_REDIRECTION_DOMAIN`: Inspects only the first domain in the
#' redirection chain. You don't need to add the subsequent domains in the
#' domain in the redirection list to the domain list.
#' @param Qtype The DNS query type you want the rule to evaluate. Allowed values are;
#' 
#' -   A: Returns an IPv4 address.
#' 
#' -   AAAA: Returns an Ipv6 address.
#' 
#' -   CAA: Restricts CAs that can create SSL/TLS certifications for the
#'     domain.
#' 
#' -   CNAME: Returns another domain name.
#' 
#' -   DS: Record that identifies the DNSSEC signing key of a delegated
#'     zone.
#' 
#' -   MX: Specifies mail servers.
#' 
#' -   NAPTR: Regular-expression-based rewriting of domain names.
#' 
#' -   NS: Authoritative name servers.
#' 
#' -   PTR: Maps an IP address to a domain name.
#' 
#' -   SOA: Start of authority record for the zone.
#' 
#' -   SPF: Lists the servers authorized to send emails from a domain.
#' 
#' -   SRV: Application specific values that identify servers.
#' 
#' -   TXT: Verifies email senders and application-specific values.
#' 
#' -   A query type you define by using the DNS type ID, for example 28 for
#'     AAAA. The values must be defined as TYPENUMBER, where the NUMBER can
#'     be 1-65334, for example, TYPE28. For more information, see [List of
#'     DNS record
#'     types](https://en.wikipedia.org/wiki/List_of_DNS_record_types).
#' 
#'     If you set up a firewall BLOCK rule with action NXDOMAIN on query
#'     type equals AAAA, this action will not be applied to synthetic IPv6
#'     addresses generated when DNS64 is enabled.
#' @param DnsThreatProtection The type of the DNS Firewall Advanced rule. Valid values are:
#' 
#' -   `DGA`: Domain generation algorithms detection. DGAs are used by
#'     attackers to generate a large number of domains to to launch malware
#'     attacks.
#' 
#' -   `DNS_TUNNELING`: DNS tunneling detection. DNS tunneling is used by
#'     attackers to exfiltrate data from the client by using the DNS tunnel
#'     without making a network connection to the client.
#' @param ConfidenceThreshold The confidence threshold for DNS Firewall Advanced. You must provide
#' this value when you create a DNS Firewall Advanced rule. The confidence
#' level values mean:
#' 
#' -   `LOW`: Provides the highest detection rate for threats, but also
#'     increases false positives.
#' 
#' -   `MEDIUM`: Provides a balance between detecting threats and false
#'     positives.
#' 
#' -   `HIGH`: Detects only the most well corroborated threats with a low
#'     rate of false positives.
#'
#' @keywords internal
#'
#' @rdname route53resolver_update_firewall_rule
route53resolver_update_firewall_rule <- function(FirewallRuleGroupId, FirewallDomainListId = NULL, FirewallThreatProtectionId = NULL, Priority = NULL, Action = NULL, BlockResponse = NULL, BlockOverrideDomain = NULL, BlockOverrideDnsType = NULL, BlockOverrideTtl = NULL, Name = NULL, FirewallDomainRedirectionAction = NULL, Qtype = NULL, DnsThreatProtection = NULL, ConfidenceThreshold = NULL) {
  op <- new_operation(
    name = "UpdateFirewallRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$update_firewall_rule_input(FirewallRuleGroupId = FirewallRuleGroupId, FirewallDomainListId = FirewallDomainListId, FirewallThreatProtectionId = FirewallThreatProtectionId, Priority = Priority, Action = Action, BlockResponse = BlockResponse, BlockOverrideDomain = BlockOverrideDomain, BlockOverrideDnsType = BlockOverrideDnsType, BlockOverrideTtl = BlockOverrideTtl, Name = Name, FirewallDomainRedirectionAction = FirewallDomainRedirectionAction, Qtype = Qtype, DnsThreatProtection = DnsThreatProtection, ConfidenceThreshold = ConfidenceThreshold)
  output <- .route53resolver$update_firewall_rule_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$update_firewall_rule <- route53resolver_update_firewall_rule

#' Changes the association of a FirewallRuleGroup with a VPC
#'
#' @description
#' Changes the association of a FirewallRuleGroup with a VPC. The association enables DNS filtering for the VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_update_firewall_rule_group_association/](https://www.paws-r-sdk.com/docs/route53resolver_update_firewall_rule_group_association/) for full documentation.
#'
#' @param FirewallRuleGroupAssociationId &#91;required&#93; The identifier of the FirewallRuleGroupAssociation.
#' @param Priority The setting that determines the processing order of the rule group among
#' the rule groups that you associate with the specified VPC. DNS Firewall
#' filters VPC traffic starting from the rule group with the lowest numeric
#' priority setting.
#' 
#' You must specify a unique priority for each rule group that you
#' associate with a single VPC. To make it easier to insert rule groups
#' later, leave space between the numbers, for example, use 100, 200, and
#' so on. You can change the priority setting for a rule group association
#' after you create it.
#' @param MutationProtection If enabled, this setting disallows modification or removal of the
#' association, to help prevent against accidentally altering DNS firewall
#' protections.
#' @param Name The name of the rule group association.
#'
#' @keywords internal
#'
#' @rdname route53resolver_update_firewall_rule_group_association
route53resolver_update_firewall_rule_group_association <- function(FirewallRuleGroupAssociationId, Priority = NULL, MutationProtection = NULL, Name = NULL) {
  op <- new_operation(
    name = "UpdateFirewallRuleGroupAssociation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$update_firewall_rule_group_association_input(FirewallRuleGroupAssociationId = FirewallRuleGroupAssociationId, Priority = Priority, MutationProtection = MutationProtection, Name = Name)
  output <- .route53resolver$update_firewall_rule_group_association_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$update_firewall_rule_group_association <- route53resolver_update_firewall_rule_group_association

#' You can use UpdateOutpostResolver to update the instance count, type, or
#' name of a Resolver on an Outpost
#'
#' @description
#' You can use [`update_outpost_resolver`][route53resolver_update_outpost_resolver] to update the instance count, type, or name of a Resolver on an Outpost.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_update_outpost_resolver/](https://www.paws-r-sdk.com/docs/route53resolver_update_outpost_resolver/) for full documentation.
#'
#' @param Id &#91;required&#93; A unique string that identifies Resolver on an Outpost.
#' @param Name Name of the Resolver on the Outpost.
#' @param InstanceCount The Amazon EC2 instance count for a Resolver on the Outpost.
#' @param PreferredInstanceType Amazon EC2 instance type.
#'
#' @keywords internal
#'
#' @rdname route53resolver_update_outpost_resolver
route53resolver_update_outpost_resolver <- function(Id, Name = NULL, InstanceCount = NULL, PreferredInstanceType = NULL) {
  op <- new_operation(
    name = "UpdateOutpostResolver",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$update_outpost_resolver_input(Id = Id, Name = Name, InstanceCount = InstanceCount, PreferredInstanceType = PreferredInstanceType)
  output <- .route53resolver$update_outpost_resolver_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$update_outpost_resolver <- route53resolver_update_outpost_resolver

#' Updates the behavior configuration of Route 53 Resolver behavior for a
#' single VPC from Amazon Virtual Private Cloud
#'
#' @description
#' Updates the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private Cloud.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_update_resolver_config/](https://www.paws-r-sdk.com/docs/route53resolver_update_resolver_config/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; Resource ID of the Amazon VPC that you want to update the Resolver
#' configuration for.
#' @param AutodefinedReverseFlag &#91;required&#93; Indicates whether or not the Resolver will create autodefined rules for
#' reverse DNS lookups. This is enabled by default. Disabling this option
#' will also affect EC2-Classic instances using ClassicLink. For more
#' information, see
#' [ClassicLink](https://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/)
#' in the *Amazon EC2 guide*.
#' 
#' We are retiring EC2-Classic on August 15, 2022. We recommend that you
#' migrate from EC2-Classic to a VPC. For more information, see [Migrate
#' from EC2-Classic to a
#' VPC](https://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/)
#' in the *Amazon EC2 guide* and the blog [EC2-Classic Networking is
#' Retiring – Here’s How to
#' Prepare](https://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/).
#' 
#' It can take some time for the status change to be completed.
#'
#' @keywords internal
#'
#' @rdname route53resolver_update_resolver_config
route53resolver_update_resolver_config <- function(ResourceId, AutodefinedReverseFlag) {
  op <- new_operation(
    name = "UpdateResolverConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$update_resolver_config_input(ResourceId = ResourceId, AutodefinedReverseFlag = AutodefinedReverseFlag)
  output <- .route53resolver$update_resolver_config_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$update_resolver_config <- route53resolver_update_resolver_config

#' Updates an existing DNSSEC validation configuration
#'
#' @description
#' Updates an existing DNSSEC validation configuration. If there is no existing DNSSEC validation configuration, one is created.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_update_resolver_dnssec_config/](https://www.paws-r-sdk.com/docs/route53resolver_update_resolver_dnssec_config/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The ID of the virtual private cloud (VPC) that you're updating the
#' DNSSEC validation status for.
#' @param Validation &#91;required&#93; The new value that you are specifying for DNSSEC validation for the VPC.
#' The value can be `ENABLE` or `DISABLE`. Be aware that it can take time
#' for a validation status change to be completed.
#'
#' @keywords internal
#'
#' @rdname route53resolver_update_resolver_dnssec_config
route53resolver_update_resolver_dnssec_config <- function(ResourceId, Validation) {
  op <- new_operation(
    name = "UpdateResolverDnssecConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$update_resolver_dnssec_config_input(ResourceId = ResourceId, Validation = Validation)
  output <- .route53resolver$update_resolver_dnssec_config_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$update_resolver_dnssec_config <- route53resolver_update_resolver_dnssec_config

#' Updates the name, or endpoint type for an inbound or an outbound
#' Resolver endpoint
#'
#' @description
#' Updates the name, or endpoint type for an inbound or an outbound Resolver endpoint. You can only update between IPV4 and DUALSTACK, IPV6 endpoint type can't be updated to other type.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_update_resolver_endpoint/](https://www.paws-r-sdk.com/docs/route53resolver_update_resolver_endpoint/) for full documentation.
#'
#' @param ResolverEndpointId &#91;required&#93; The ID of the Resolver endpoint that you want to update.
#' @param Name The name of the Resolver endpoint that you want to update.
#' @param ResolverEndpointType Specifies the endpoint type for what type of IP address the endpoint
#' uses to forward DNS queries.
#' 
#' Updating to `IPV6` type isn't currently supported.
#' @param UpdateIpAddresses Specifies the IPv6 address when you update the Resolver endpoint from
#' IPv4 to dual-stack. If you don't specify an IPv6 address, one will be
#' automatically chosen from your subnet.
#' @param Protocols The protocols you want to use for the endpoint. DoH-FIPS is applicable
#' for inbound endpoints only.
#' 
#' For an inbound endpoint you can apply the protocols as follows:
#' 
#' -   Do53 and DoH in combination.
#' 
#' -   Do53 and DoH-FIPS in combination.
#' 
#' -   Do53 alone.
#' 
#' -   DoH alone.
#' 
#' -   DoH-FIPS alone.
#' 
#' -   None, which is treated as Do53.
#' 
#' For an outbound endpoint you can apply the protocols as follows:
#' 
#' -   Do53 and DoH in combination.
#' 
#' -   Do53 alone.
#' 
#' -   DoH alone.
#' 
#' -   None, which is treated as Do53.
#' 
#' You can't change the protocol of an inbound endpoint directly from only
#' Do53 to only DoH, or DoH-FIPS. This is to prevent a sudden disruption to
#' incoming traffic that relies on Do53. To change the protocol from Do53
#' to DoH, or DoH-FIPS, you must first enable both Do53 and DoH, or Do53
#' and DoH-FIPS, to make sure that all incoming traffic has transferred to
#' using the DoH protocol, or DoH-FIPS, and then remove the Do53.
#'
#' @keywords internal
#'
#' @rdname route53resolver_update_resolver_endpoint
route53resolver_update_resolver_endpoint <- function(ResolverEndpointId, Name = NULL, ResolverEndpointType = NULL, UpdateIpAddresses = NULL, Protocols = NULL) {
  op <- new_operation(
    name = "UpdateResolverEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$update_resolver_endpoint_input(ResolverEndpointId = ResolverEndpointId, Name = Name, ResolverEndpointType = ResolverEndpointType, UpdateIpAddresses = UpdateIpAddresses, Protocols = Protocols)
  output <- .route53resolver$update_resolver_endpoint_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$update_resolver_endpoint <- route53resolver_update_resolver_endpoint

#' Updates settings for a specified Resolver rule
#'
#' @description
#' Updates settings for a specified Resolver rule. `ResolverRuleId` is required, and all other parameters are optional. If you don't specify a parameter, it retains its current value.
#'
#' See [https://www.paws-r-sdk.com/docs/route53resolver_update_resolver_rule/](https://www.paws-r-sdk.com/docs/route53resolver_update_resolver_rule/) for full documentation.
#'
#' @param ResolverRuleId &#91;required&#93; The ID of the Resolver rule that you want to update.
#' @param Config &#91;required&#93; The new settings for the Resolver rule.
#'
#' @keywords internal
#'
#' @rdname route53resolver_update_resolver_rule
route53resolver_update_resolver_rule <- function(ResolverRuleId, Config) {
  op <- new_operation(
    name = "UpdateResolverRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53resolver$update_resolver_rule_input(ResolverRuleId = ResolverRuleId, Config = Config)
  output <- .route53resolver$update_resolver_rule_output()
  config <- get_config()
  svc <- .route53resolver$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$update_resolver_rule <- route53resolver_update_resolver_rule
