% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkfirewall_operations.R
\name{networkfirewall_update_firewall_delete_protection}
\alias{networkfirewall_update_firewall_delete_protection}
\title{Modifies the flag, DeleteProtection, which indicates whether it is
possible to delete the firewall}
\usage{
networkfirewall_update_firewall_delete_protection(
  UpdateToken = NULL,
  FirewallArn = NULL,
  FirewallName = NULL,
  DeleteProtection
)
}
\arguments{
\item{UpdateToken}{An optional token that you can use for optimistic locking. Network
Firewall returns a token to your requests that access the firewall. The
token marks the state of the firewall resource at the time of the
request.

To make an unconditional change to the firewall, omit the token in your
update request. Without the token, Network Firewall performs your
updates regardless of whether the firewall has changed since you last
retrieved it.

To make a conditional change to the firewall, provide the token in your
update request. Network Firewall uses the token to ensure that the
firewall hasn't changed since you last retrieved it. If it has changed,
the operation fails with an \code{InvalidTokenException}. If this happens,
retrieve the firewall again to get a current copy of it with a new
token. Reapply your changes as needed, then try the operation again
using the new token.}

\item{FirewallArn}{The Amazon Resource Name (ARN) of the firewall.

You must specify the ARN or the name, and you can specify both.}

\item{FirewallName}{The descriptive name of the firewall. You can't change the name of a
firewall after you create it.

You must specify the ARN or the name, and you can specify both.}

\item{DeleteProtection}{[required] A flag indicating whether it is possible to delete the firewall. A
setting of \code{TRUE} indicates that the firewall is protected against
deletion. Use this setting to protect against accidentally deleting a
firewall that is in use. When you create a firewall, the operation
initializes this flag to \code{TRUE}.}
}
\description{
Modifies the flag, \code{DeleteProtection}, which indicates whether it is possible to delete the firewall. If the flag is set to \code{TRUE}, the firewall is protected against deletion. This setting helps protect against accidentally deleting a firewall that's in use.

See \url{https://www.paws-r-sdk.com/docs/networkfirewall_update_firewall_delete_protection/} for full documentation.
}
\keyword{internal}
