% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53recoverycontrolconfig_operations.R
\name{route53recoverycontrolconfig_create_control_panel}
\alias{route53recoverycontrolconfig_create_control_panel}
\title{Creates a new control panel}
\usage{
route53recoverycontrolconfig_create_control_panel(
  ClientToken = NULL,
  ClusterArn,
  ControlPanelName,
  Tags = NULL
)
}
\arguments{
\item{ClientToken}{A unique, case-sensitive string of up to 64 ASCII characters. To make an
idempotent API request with an action, specify a client token in the
request.}

\item{ClusterArn}{[required] The Amazon Resource Name (ARN) of the cluster for the control panel.}

\item{ControlPanelName}{[required] The name of the control panel.}

\item{Tags}{The tags associated with the control panel.}
}
\description{
Creates a new control panel. A control panel represents a group of routing controls that can be changed together in a single transaction. You can use a control panel to centrally view the operational status of applications across your organization, and trigger multi-app failovers in a single transaction, for example, to fail over an Availability Zone or Amazon Web Services Region.

See \url{https://paws-r.github.io/docs/route53recoverycontrolconfig/create_control_panel.html} for full documentation.
}
\keyword{internal}
