% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_list_traffic_policy_instances_by_hosted_zone}
\alias{route53_list_traffic_policy_instances_by_hosted_zone}
\title{Gets information about the traffic policy instances that you created in
a specified hosted zone}
\usage{
route53_list_traffic_policy_instances_by_hosted_zone(
  HostedZoneId,
  TrafficPolicyInstanceNameMarker = NULL,
  TrafficPolicyInstanceTypeMarker = NULL,
  MaxItems = NULL
)
}
\arguments{
\item{HostedZoneId}{[required] The ID of the hosted zone that you want to list traffic policy instances
for.}

\item{TrafficPolicyInstanceNameMarker}{If the value of \code{IsTruncated} in the previous response is true, you have
more traffic policy instances. To get more traffic policy instances,
submit another
\code{\link[=route53_list_traffic_policy_instances]{list_traffic_policy_instances}}
request. For the value of \code{trafficpolicyinstancename}, specify the value
of \code{TrafficPolicyInstanceNameMarker} from the previous response, which
is the name of the first traffic policy instance in the next group of
traffic policy instances.

If the value of \code{IsTruncated} in the previous response was \code{false},
there are no more traffic policy instances to get.}

\item{TrafficPolicyInstanceTypeMarker}{If the value of \code{IsTruncated} in the previous response is true, you have
more traffic policy instances. To get more traffic policy instances,
submit another
\code{\link[=route53_list_traffic_policy_instances]{list_traffic_policy_instances}}
request. For the value of \code{trafficpolicyinstancetype}, specify the value
of \code{TrafficPolicyInstanceTypeMarker} from the previous response, which
is the type of the first traffic policy instance in the next group of
traffic policy instances.

If the value of \code{IsTruncated} in the previous response was \code{false},
there are no more traffic policy instances to get.}

\item{MaxItems}{The maximum number of traffic policy instances to be included in the
response body for this request. If you have more than \code{MaxItems} traffic
policy instances, the value of the \code{IsTruncated} element in the response
is \code{true}, and the values of \code{HostedZoneIdMarker},
\code{TrafficPolicyInstanceNameMarker}, and \code{TrafficPolicyInstanceTypeMarker}
represent the first traffic policy instance that Amazon Route 53 will
return if you submit another request.}
}
\description{
Gets information about the traffic policy instances that you created in a specified hosted zone.

See \url{https://paws-r.github.io/docs/route53/list_traffic_policy_instances_by_hosted_zone.html} for full documentation.
}
\keyword{internal}
