% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_tag_resource}
\alias{globalaccelerator_tag_resource}
\title{Add tags to an accelerator resource}
\usage{
globalaccelerator_tag_resource(ResourceArn, Tags)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the Global Accelerator resource to add
tags to. An ARN uniquely identifies a resource.}

\item{Tags}{[required] The tags to add to a resource. A tag consists of a key and a value that
you define.}
}
\value{
An empty list.
}
\description{
Add tags to an accelerator resource.

For more information, see \href{https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html}{Tagging in AWS Global Accelerator}
in the \emph{AWS Global Accelerator Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  ResourceArn = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
