% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_list_distributions_by_web_acl_id}
\alias{cloudfront_list_distributions_by_web_acl_id}
\title{List the distributions that are associated with a specified AWS WAF web
ACL}
\usage{
cloudfront_list_distributions_by_web_acl_id(Marker, MaxItems, WebACLId)
}
\arguments{
\item{Marker}{Use \code{Marker} and \code{MaxItems} to control pagination of results. If you
have more than \code{MaxItems} distributions that satisfy the request, the
response includes a \code{NextMarker} element. To get the next page of
results, submit another request. For the value of \code{Marker}, specify the
value of \code{NextMarker} from the last response. (For the first request,
omit \code{Marker}.)}

\item{MaxItems}{The maximum number of distributions that you want CloudFront to return
in the response body. The maximum and default values are both 100.}

\item{WebACLId}{[required] The ID of the AWS WAF web ACL that you want to list the associated
distributions. If you specify "null" for the ID, the request returns a
list of the distributions that aren't associated with a web ACL.}
}
\value{
A list with the following syntax:\preformatted{list(
  DistributionList = list(
    Marker = "string",
    NextMarker = "string",
    MaxItems = 123,
    IsTruncated = TRUE|FALSE,
    Quantity = 123,
    Items = list(
      list(
        Id = "string",
        ARN = "string",
        Status = "string",
        LastModifiedTime = as.POSIXct(
          "2015-01-01"
        ),
        DomainName = "string",
        Aliases = list(
          Quantity = 123,
          Items = list(
            "string"
          )
        ),
        Origins = list(
          Quantity = 123,
          Items = list(
            list(
              Id = "string",
              DomainName = "string",
              OriginPath = "string",
              CustomHeaders = list(
                Quantity = 123,
                Items = list(
                  list(
                    HeaderName = "string",
                    HeaderValue = "string"
                  )
                )
              ),
              S3OriginConfig = list(
                OriginAccessIdentity = "string"
              ),
              CustomOriginConfig = list(
                HTTPPort = 123,
                HTTPSPort = 123,
                OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
                OriginSslProtocols = list(
                  Quantity = 123,
                  Items = list(
                    "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
                  )
                ),
                OriginReadTimeout = 123,
                OriginKeepaliveTimeout = 123
              ),
              ConnectionAttempts = 123,
              ConnectionTimeout = 123,
              OriginShield = list(
                Enabled = TRUE|FALSE,
                OriginShieldRegion = "string"
              )
            )
          )
        ),
        OriginGroups = list(
          Quantity = 123,
          Items = list(
            list(
              Id = "string",
              FailoverCriteria = list(
                StatusCodes = list(
                  Quantity = 123,
                  Items = list(
                    123
                  )
                )
              ),
              Members = list(
                Quantity = 123,
                Items = list(
                  list(
                    OriginId = "string"
                  )
                )
              )
            )
          )
        ),
        DefaultCacheBehavior = list(
          TargetOriginId = "string",
          TrustedSigners = list(
            Enabled = TRUE|FALSE,
            Quantity = 123,
            Items = list(
              "string"
            )
          ),
          TrustedKeyGroups = list(
            Enabled = TRUE|FALSE,
            Quantity = 123,
            Items = list(
              "string"
            )
          ),
          ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
          AllowedMethods = list(
            Quantity = 123,
            Items = list(
              "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
            ),
            CachedMethods = list(
              Quantity = 123,
              Items = list(
                "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
              )
            )
          ),
          SmoothStreaming = TRUE|FALSE,
          Compress = TRUE|FALSE,
          LambdaFunctionAssociations = list(
            Quantity = 123,
            Items = list(
              list(
                LambdaFunctionARN = "string",
                EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
                IncludeBody = TRUE|FALSE
              )
            )
          ),
          FieldLevelEncryptionId = "string",
          RealtimeLogConfigArn = "string",
          CachePolicyId = "string",
          OriginRequestPolicyId = "string",
          ForwardedValues = list(
            QueryString = TRUE|FALSE,
            Cookies = list(
              Forward = "none"|"whitelist"|"all",
              WhitelistedNames = list(
                Quantity = 123,
                Items = list(
                  "string"
                )
              )
            ),
            Headers = list(
              Quantity = 123,
              Items = list(
                "string"
              )
            ),
            QueryStringCacheKeys = list(
              Quantity = 123,
              Items = list(
                "string"
              )
            )
          ),
          MinTTL = 123,
          DefaultTTL = 123,
          MaxTTL = 123
        ),
        CacheBehaviors = list(
          Quantity = 123,
          Items = list(
            list(
              PathPattern = "string",
              TargetOriginId = "string",
              TrustedSigners = list(
                Enabled = TRUE|FALSE,
                Quantity = 123,
                Items = list(
                  "string"
                )
              ),
              TrustedKeyGroups = list(
                Enabled = TRUE|FALSE,
                Quantity = 123,
                Items = list(
                  "string"
                )
              ),
              ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
              AllowedMethods = list(
                Quantity = 123,
                Items = list(
                  "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
                ),
                CachedMethods = list(
                  Quantity = 123,
                  Items = list(
                    "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
                  )
                )
              ),
              SmoothStreaming = TRUE|FALSE,
              Compress = TRUE|FALSE,
              LambdaFunctionAssociations = list(
                Quantity = 123,
                Items = list(
                  list(
                    LambdaFunctionARN = "string",
                    EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
                    IncludeBody = TRUE|FALSE
                  )
                )
              ),
              FieldLevelEncryptionId = "string",
              RealtimeLogConfigArn = "string",
              CachePolicyId = "string",
              OriginRequestPolicyId = "string",
              ForwardedValues = list(
                QueryString = TRUE|FALSE,
                Cookies = list(
                  Forward = "none"|"whitelist"|"all",
                  WhitelistedNames = list(
                    Quantity = 123,
                    Items = list(
                      "string"
                    )
                  )
                ),
                Headers = list(
                  Quantity = 123,
                  Items = list(
                    "string"
                  )
                ),
                QueryStringCacheKeys = list(
                  Quantity = 123,
                  Items = list(
                    "string"
                  )
                )
              ),
              MinTTL = 123,
              DefaultTTL = 123,
              MaxTTL = 123
            )
          )
        ),
        CustomErrorResponses = list(
          Quantity = 123,
          Items = list(
            list(
              ErrorCode = 123,
              ResponsePagePath = "string",
              ResponseCode = "string",
              ErrorCachingMinTTL = 123
            )
          )
        ),
        Comment = "string",
        PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
        Enabled = TRUE|FALSE,
        ViewerCertificate = list(
          CloudFrontDefaultCertificate = TRUE|FALSE,
          IAMCertificateId = "string",
          ACMCertificateArn = "string",
          SSLSupportMethod = "sni-only"|"vip"|"static-ip",
          MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018"|"TLSv1.2_2019",
          Certificate = "string",
          CertificateSource = "cloudfront"|"iam"|"acm"
        ),
        Restrictions = list(
          GeoRestriction = list(
            RestrictionType = "blacklist"|"whitelist"|"none",
            Quantity = 123,
            Items = list(
              "string"
            )
          )
        ),
        WebACLId = "string",
        HttpVersion = "http1.1"|"http2",
        IsIPV6Enabled = TRUE|FALSE,
        AliasICPRecordals = list(
          list(
            CNAME = "string",
            ICPRecordalStatus = "APPROVED"|"SUSPENDED"|"PENDING"
          )
        )
      )
    )
  )
)
}
}
\description{
List the distributions that are associated with a specified AWS WAF web
ACL.
}
\section{Request syntax}{
\preformatted{svc$list_distributions_by_web_acl_id(
  Marker = "string",
  MaxItems = "string",
  WebACLId = "string"
)
}
}

\keyword{internal}
