% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_put_method}
\alias{apigateway_put_method}
\title{Add a method to an existing Resource resource}
\usage{
apigateway_put_method(restApiId, resourceId, httpMethod,
  authorizationType, authorizerId, apiKeyRequired, operationName,
  requestParameters, requestModels, requestValidatorId,
  authorizationScopes)
}
\arguments{
\item{restApiId}{[required] [Required] The string identifier of the associated RestApi.}

\item{resourceId}{[required] [Required] The Resource identifier for the new Method resource.}

\item{httpMethod}{[required] [Required] Specifies the method request's HTTP method type.}

\item{authorizationType}{[required] [Required] The method's authorization type. Valid values are \code{NONE}
for open access, \code{AWS_IAM} for using AWS IAM permissions, \code{CUSTOM} for
using a custom authorizer, or \code{COGNITO_USER_POOLS} for using a Cognito
user pool.}

\item{authorizerId}{Specifies the identifier of an Authorizer to use on this Method, if the
type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is
generated by API Gateway when you created the authorizer.}

\item{apiKeyRequired}{Specifies whether the method required a valid ApiKey.}

\item{operationName}{A human-friendly operation identifier for the method. For example, you
can assign the \code{operationName} of \code{ListPets} for the \code{GET /pets} method
in the \code{PetStore} example.}

\item{requestParameters}{A key-value map defining required or optional method request parameters
that can be accepted by API Gateway. A key defines a method request
parameter name matching the pattern of
\verb{method.request.\{location\}.\{name\}}, where \code{location} is \code{querystring},
\code{path}, or \code{header} and \code{name} is a valid and unique parameter name. The
value associated with the key is a Boolean flag indicating whether the
parameter is required (\code{true}) or optional (\code{false}). The method request
parameter names defined here are available in Integration to be mapped
to integration request parameters or body-mapping templates.}

\item{requestModels}{Specifies the Model resources used for the request's content type.
Request models are represented as a key/value map, with a content type
as the key and a Model name as the value.}

\item{requestValidatorId}{The identifier of a RequestValidator for validating the method request.}

\item{authorizationScopes}{A list of authorization scopes configured on the method. The scopes are
used with a \code{COGNITO_USER_POOLS} authorizer to authorize the method
invocation. The authorization works by matching the method scopes
against the scopes parsed from the access token in the incoming request.
The method invocation is authorized if any method scopes matches a
claimed scope in the access token. Otherwise, the invocation is not
authorized. When the method scope is configured, the client must provide
an access token instead of an identity token for authorization purposes.}
}
\value{
A list with the following syntax:\preformatted{list(
  httpMethod = "string",
  authorizationType = "string",
  authorizerId = "string",
  apiKeyRequired = TRUE|FALSE,
  requestValidatorId = "string",
  operationName = "string",
  requestParameters = list(
    TRUE|FALSE
  ),
  requestModels = list(
    "string"
  ),
  methodResponses = list(
    list(
      statusCode = "string",
      responseParameters = list(
        TRUE|FALSE
      ),
      responseModels = list(
        "string"
      )
    )
  ),
  methodIntegration = list(
    type = "HTTP"|"AWS"|"MOCK"|"HTTP_PROXY"|"AWS_PROXY",
    httpMethod = "string",
    uri = "string",
    connectionType = "INTERNET"|"VPC_LINK",
    connectionId = "string",
    credentials = "string",
    requestParameters = list(
      "string"
    ),
    requestTemplates = list(
      "string"
    ),
    passthroughBehavior = "string",
    contentHandling = "CONVERT_TO_BINARY"|"CONVERT_TO_TEXT",
    timeoutInMillis = 123,
    cacheNamespace = "string",
    cacheKeyParameters = list(
      "string"
    ),
    integrationResponses = list(
      list(
        statusCode = "string",
        selectionPattern = "string",
        responseParameters = list(
          "string"
        ),
        responseTemplates = list(
          "string"
        ),
        contentHandling = "CONVERT_TO_BINARY"|"CONVERT_TO_TEXT"
      )
    ),
    tlsConfig = list(
      insecureSkipVerification = TRUE|FALSE
    )
  ),
  authorizationScopes = list(
    "string"
  )
)
}
}
\description{
Add a method to an existing Resource resource.
}
\section{Request syntax}{
\preformatted{svc$put_method(
  restApiId = "string",
  resourceId = "string",
  httpMethod = "string",
  authorizationType = "string",
  authorizerId = "string",
  apiKeyRequired = TRUE|FALSE,
  operationName = "string",
  requestParameters = list(
    TRUE|FALSE
  ),
  requestModels = list(
    "string"
  ),
  requestValidatorId = "string",
  authorizationScopes = list(
    "string"
  )
)
}
}

\keyword{internal}
