% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_list_custom_routing_accelerators}
\alias{globalaccelerator_list_custom_routing_accelerators}
\title{List the custom routing accelerators for an AWS account}
\usage{
globalaccelerator_list_custom_routing_accelerators(MaxResults,
  NextToken)
}
\arguments{
\item{MaxResults}{The number of custom routing Global Accelerator objects that you want to
return with this call. The default value is 10.}

\item{NextToken}{The token for the next set of results. You receive this token from a
previous call.}
}
\value{
A list with the following syntax:\preformatted{list(
  Accelerators = list(
    list(
      AcceleratorArn = "string",
      Name = "string",
      IpAddressType = "IPV4",
      Enabled = TRUE|FALSE,
      IpSets = list(
        list(
          IpFamily = "string",
          IpAddresses = list(
            "string"
          )
        )
      ),
      DnsName = "string",
      Status = "DEPLOYED"|"IN_PROGRESS",
      CreatedTime = as.POSIXct(
        "2015-01-01"
      ),
      LastModifiedTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
List the custom routing accelerators for an AWS account.
}
\section{Request syntax}{
\preformatted{svc$list_custom_routing_accelerators(
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
