% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_operations.R
\name{elb_describe_load_balancers}
\alias{elb_describe_load_balancers}
\title{Describes the specified the load balancers}
\usage{
elb_describe_load_balancers(LoadBalancerNames, Marker, PageSize)
}
\arguments{
\item{LoadBalancerNames}{The names of the load balancers.}

\item{Marker}{The marker for the next set of results. (You received this marker from a
previous call.)}

\item{PageSize}{The maximum number of results to return with this call (a number from 1
to 400). The default is 400.}
}
\value{
A list with the following syntax:\preformatted{list(
  LoadBalancerDescriptions = list(
    list(
      LoadBalancerName = "string",
      DNSName = "string",
      CanonicalHostedZoneName = "string",
      CanonicalHostedZoneNameID = "string",
      ListenerDescriptions = list(
        list(
          Listener = list(
            Protocol = "string",
            LoadBalancerPort = 123,
            InstanceProtocol = "string",
            InstancePort = 123,
            SSLCertificateId = "string"
          ),
          PolicyNames = list(
            "string"
          )
        )
      ),
      Policies = list(
        AppCookieStickinessPolicies = list(
          list(
            PolicyName = "string",
            CookieName = "string"
          )
        ),
        LBCookieStickinessPolicies = list(
          list(
            PolicyName = "string",
            CookieExpirationPeriod = 123
          )
        ),
        OtherPolicies = list(
          "string"
        )
      ),
      BackendServerDescriptions = list(
        list(
          InstancePort = 123,
          PolicyNames = list(
            "string"
          )
        )
      ),
      AvailabilityZones = list(
        "string"
      ),
      Subnets = list(
        "string"
      ),
      VPCId = "string",
      Instances = list(
        list(
          InstanceId = "string"
        )
      ),
      HealthCheck = list(
        Target = "string",
        Interval = 123,
        Timeout = 123,
        UnhealthyThreshold = 123,
        HealthyThreshold = 123
      ),
      SourceSecurityGroup = list(
        OwnerAlias = "string",
        GroupName = "string"
      ),
      SecurityGroups = list(
        "string"
      ),
      CreatedTime = as.POSIXct(
        "2015-01-01"
      ),
      Scheme = "string"
    )
  ),
  NextMarker = "string"
)
}
}
\description{
Describes the specified the load balancers. If no load balancers are
specified, the call describes all of your load balancers.
}
\section{Request syntax}{
\preformatted{svc$describe_load_balancers(
  LoadBalancerNames = list(
    "string"
  ),
  Marker = "string",
  PageSize = 123
)
}
}

\examples{
\dontrun{
# This example describes the specified load balancer.
svc$describe_load_balancers(
  LoadBalancerNames = list(
    "my-load-balancer"
  )
)
}

}
\keyword{internal}
