% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_update_authorizer}
\alias{apigateway_update_authorizer}
\title{Updates an existing Authorizer resource}
\usage{
apigateway_update_authorizer(restApiId, authorizerId, patchOperations)
}
\arguments{
\item{restApiId}{[required] [Required] The string identifier of the associated RestApi.}

\item{authorizerId}{[required] [Required] The identifier of the Authorizer resource.}

\item{patchOperations}{A list of update operations to be applied to the specified resource and
in the order specified in this list.}
}
\value{
A list with the following syntax:\preformatted{list(
  id = "string",
  name = "string",
  type = "TOKEN"|"REQUEST"|"COGNITO_USER_POOLS",
  providerARNs = list(
    "string"
  ),
  authType = "string",
  authorizerUri = "string",
  authorizerCredentials = "string",
  identitySource = "string",
  identityValidationExpression = "string",
  authorizerResultTtlInSeconds = 123
)
}
}
\description{
Updates an existing Authorizer resource.<div class="seeAlso">


\href{https://docs.aws.amazon.com/cli/latest/reference/apigateway/update-authorizer.html}{AWS CLI}</div>
}
\section{Request syntax}{
\preformatted{svc$update_authorizer(
  restApiId = "string",
  authorizerId = "string",
  patchOperations = list(
    list(
      op = "add"|"remove"|"replace"|"move"|"copy"|"test",
      path = "string",
      value = "string",
      from = "string"
    )
  )
)
}
}

\keyword{internal}
