% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_get_domain_name}
\alias{apigateway_get_domain_name}
\title{Represents a domain name that is contained in a simpler, more intuitive
URL that can be called}
\usage{
apigateway_get_domain_name(domainName)
}
\arguments{
\item{domainName}{[required] [Required] The name of the DomainName resource.}
}
\value{
A list with the following syntax:\preformatted{list(
  domainName = "string",
  certificateName = "string",
  certificateArn = "string",
  certificateUploadDate = as.POSIXct(
    "2015-01-01"
  ),
  regionalDomainName = "string",
  regionalHostedZoneId = "string",
  regionalCertificateName = "string",
  regionalCertificateArn = "string",
  distributionDomainName = "string",
  distributionHostedZoneId = "string",
  endpointConfiguration = list(
    types = list(
      "REGIONAL"|"EDGE"|"PRIVATE"
    ),
    vpcEndpointIds = list(
      "string"
    )
  ),
  domainNameStatus = "AVAILABLE"|"UPDATING"|"PENDING",
  domainNameStatusMessage = "string",
  securityPolicy = "TLS_1_0"|"TLS_1_2",
  tags = list(
    "string"
  ),
  mutualTlsAuthentication = list(
    truststoreUri = "string",
    truststoreVersion = "string",
    truststoreWarnings = list(
      "string"
    )
  )
)
}
}
\description{
Represents a domain name that is contained in a simpler, more intuitive
URL that can be called.
}
\section{Request syntax}{
\preformatted{svc$get_domain_name(
  domainName = "string"
)
}
}

\keyword{internal}
