% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_set_security_groups}
\alias{elbv2_set_security_groups}
\title{Associates the specified security groups with the specified Application
Load Balancer}
\usage{
elbv2_set_security_groups(LoadBalancerArn, SecurityGroups)
}
\arguments{
\item{LoadBalancerArn}{[required] The Amazon Resource Name (ARN) of the load balancer.}

\item{SecurityGroups}{[required] The IDs of the security groups.}
}
\description{
Associates the specified security groups with the specified Application
Load Balancer. The specified security groups override the previously
associated security groups.

You can't specify a security group for a Network Load Balancer or
Gateway Load Balancer.
}
\section{Request syntax}{
\preformatted{svc$set_security_groups(
  LoadBalancerArn = "string",
  SecurityGroups = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# This example associates the specified security group with the specified
# load balancer.
svc$set_security_groups(
  LoadBalancerArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my...",
  SecurityGroups = list(
    "sg-5943793c"
  )
)
}

}
\keyword{internal}
