% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_operations.R
\name{elb_set_load_balancer_listener_ssl_certificate}
\alias{elb_set_load_balancer_listener_ssl_certificate}
\title{Sets the certificate that terminates the specified listener's SSL
connections}
\usage{
elb_set_load_balancer_listener_ssl_certificate(LoadBalancerName,
  LoadBalancerPort, SSLCertificateId)
}
\arguments{
\item{LoadBalancerName}{[required] The name of the load balancer.}

\item{LoadBalancerPort}{[required] The port that uses the specified SSL certificate.}

\item{SSLCertificateId}{[required] The Amazon Resource Name (ARN) of the SSL certificate.}
}
\description{
Sets the certificate that terminates the specified listener's SSL
connections. The specified certificate replaces any prior certificate
that was used on the same load balancer and port.

For more information about updating your SSL certificate, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-update-ssl-cert.html}{Replace the SSL Certificate for Your Load Balancer}
in the \emph{Classic Load Balancers Guide}.
}
\section{Request syntax}{
\preformatted{svc$set_load_balancer_listener_ssl_certificate(
  LoadBalancerName = "string",
  LoadBalancerPort = 123,
  SSLCertificateId = "string"
)
}
}

\examples{
\dontrun{
# This example replaces the existing SSL certificate for the specified
# HTTPS listener.
svc$set_load_balancer_listener_ssl_certificate(
  LoadBalancerName = "my-load-balancer",
  LoadBalancerPort = 443L,
  SSLCertificateId = "arn:aws:iam::123456789012:server-certificate/new-server-cert"
)
}

}
\keyword{internal}
