% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_operations.R
\name{elb_configure_health_check}
\alias{elb_configure_health_check}
\title{Specifies the health check settings to use when evaluating the health
state of your EC2 instances}
\usage{
elb_configure_health_check(LoadBalancerName, HealthCheck)
}
\arguments{
\item{LoadBalancerName}{[required] The name of the load balancer.}

\item{HealthCheck}{[required] The configuration information.}
}
\description{
Specifies the health check settings to use when evaluating the health
state of your EC2 instances.

For more information, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-healthchecks.html}{Configure Health Checks for Your Load Balancer}
in the \emph{Classic Load Balancers Guide}.
}
\section{Request syntax}{
\preformatted{svc$configure_health_check(
  LoadBalancerName = "string",
  HealthCheck = list(
    Target = "string",
    Interval = 123,
    Timeout = 123,
    UnhealthyThreshold = 123,
    HealthyThreshold = 123
  )
)
}
}

\examples{
\dontrun{
# This example specifies the health check settings used to evaluate the
# health of your backend EC2 instances.
svc$configure_health_check(
  HealthCheck = list(
    HealthyThreshold = 2L,
    Interval = 30L,
    Target = "HTTP:80/png",
    Timeout = 3L,
    UnhealthyThreshold = 2L
  ),
  LoadBalancerName = "my-load-balancer"
)
}

}
\keyword{internal}
