% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_put_gateway_response}
\alias{apigateway_put_gateway_response}
\title{Creates a customization of a GatewayResponse of a specified response
type and status code on the given RestApi}
\usage{
apigateway_put_gateway_response(restApiId, responseType, statusCode,
  responseParameters, responseTemplates)
}
\arguments{
\item{restApiId}{[required] [Required] The string identifier of the associated RestApi.}

\item{responseType}{[required] [Required]

The response type of the associated GatewayResponse. Valid values are
\itemize{
\item ACCESS\_DENIED
\item API\_CONFIGURATION\_ERROR
\item AUTHORIZER\_FAILURE
\item AUTHORIZER\_CONFIGURATION\_ERROR
\item BAD\_REQUEST\_PARAMETERS
\item BAD\_REQUEST\_BODY
\item DEFAULT\_4XX
\item DEFAULT\_5XX
\item EXPIRED\_TOKEN
\item INVALID\_SIGNATURE
\item INTEGRATION\_FAILURE
\item INTEGRATION\_TIMEOUT
\item INVALID\_API\_KEY
\item MISSING\_AUTHENTICATION\_TOKEN
\item QUOTA\_EXCEEDED
\item REQUEST\_TOO\_LARGE
\item RESOURCE\_NOT\_FOUND
\item THROTTLED
\item UNAUTHORIZED
\item UNSUPPORTED\_MEDIA\_TYPE
}}

\item{statusCode}{The HTTP status code of the <a>GatewayResponse</a>.}

\item{responseParameters}{Response parameters (paths, query strings and headers) of the
GatewayResponse as a string-to-string map of key-value pairs.}

\item{responseTemplates}{Response templates of the GatewayResponse as a string-to-string map of
key-value pairs.}
}
\description{
Creates a customization of a GatewayResponse of a specified response
type and status code on the given RestApi.
}
\section{Request syntax}{
\preformatted{svc$put_gateway_response(
  restApiId = "string",
  responseType = "DEFAULT_4XX"|"DEFAULT_5XX"|"RESOURCE_NOT_FOUND"|"UNAUTHORIZED"|"INVALID_API_KEY"|"ACCESS_DENIED"|"AUTHORIZER_FAILURE"|"AUTHORIZER_CONFIGURATION_ERROR"|"INVALID_SIGNATURE"|"EXPIRED_TOKEN"|"MISSING_AUTHENTICATION_TOKEN"|"INTEGRATION_FAILURE"|"INTEGRATION_TIMEOUT"|"API_CONFIGURATION_ERROR"|"UNSUPPORTED_MEDIA_TYPE"|"BAD_REQUEST_PARAMETERS"|"BAD_REQUEST_BODY"|"REQUEST_TOO_LARGE"|"THROTTLED"|"QUOTA_EXCEEDED",
  statusCode = "string",
  responseParameters = list(
    "string"
  ),
  responseTemplates = list(
    "string"
  )
)
}
}

\keyword{internal}
