% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_create_api_key}
\alias{apigateway_create_api_key}
\title{Create an ApiKey resource}
\usage{
apigateway_create_api_key(name, description, enabled,
  generateDistinctId, value, stageKeys, customerId)
}
\arguments{
\item{name}{The name of the ApiKey.}

\item{description}{The description of the ApiKey.}

\item{enabled}{Specifies whether the ApiKey can be used by callers.}

\item{generateDistinctId}{Specifies whether (\code{true}) or not (\code{false}) the key identifier is
distinct from the created API key value.}

\item{value}{Specifies a value of the API key.}

\item{stageKeys}{DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API
key.}

\item{customerId}{An AWS Marketplace customer identifier , when integrating with the AWS
SaaS Marketplace.}
}
\description{
Create an ApiKey resource.
}
\details{
::: {.seeAlso}
\href{https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-api-key.html}{AWS CLI}
:::
}
\section{Request syntax}{
\preformatted{svc$create_api_key(
  name = "string",
  description = "string",
  enabled = TRUE|FALSE,
  generateDistinctId = TRUE|FALSE,
  value = "string",
  stageKeys = list(
    list(
      restApiId = "string",
      stageName = "string"
    )
  ),
  customerId = "string"
)
}
}

\keyword{internal}
