% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_disable_aws_service_access}
\alias{organizations_disable_aws_service_access}
\title{Disables the integration of an Amazon Web Services service (the service
that is specified by ServicePrincipal) with Organizations}
\usage{
organizations_disable_aws_service_access(ServicePrincipal)
}
\arguments{
\item{ServicePrincipal}{[required] The service principal name of the Amazon Web Services service for which
you want to disable integration with your organization. This is
typically in the form of a URL, such as
\code{ service-abbreviation.amazonaws.com}.}
}
\description{
Disables the integration of an Amazon Web Services service (the service that is specified by \code{ServicePrincipal}) with Organizations. When you disable integration, the specified service no longer can create a \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html}{service-linked role} in \emph{new} accounts in your organization. This means the service can't perform operations on your behalf on any new accounts in your organization. The service can still perform operations in older accounts until the service completes its clean-up from Organizations.

See \url{https://paws-r.github.io/docs/organizations/disable_aws_service_access.html} for full documentation.
}
\keyword{internal}
