% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_remove_account_from_organization}
\alias{organizations_remove_account_from_organization}
\title{Removes the specified account from the organization}
\usage{
organizations_remove_account_from_organization(AccountId)
}
\arguments{
\item{AccountId}{[required] The unique identifier (ID) of the member account that you want to remove
from the organization.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for an account ID
string requires exactly 12 digits.}
}
\description{
Removes the specified account from the organization.
}
\details{
The removed account becomes a standalone account that isn\'t a member of
any organization. It\'s no longer subject to any policies and is
responsible for its own bill payments. The organization\'s master
account is no longer charged for any expenses accrued by the member
account after it\'s removed from the organization.

This operation can be called only from the organization\'s master
account. Member accounts can remove themselves with LeaveOrganization
instead.

You can remove an account from your organization only if the account is
configured with the information required to operate as a standalone
account. When you create an account in an organization using the AWS
Organizations console, API, or CLI, the information required of
standalone accounts is \emph{not} automatically collected. For an account
that you want to make standalone, you must accept the end user license
agreement (EULA). You must also choose a support plan, provide and
verify the required contact information, and provide a current payment
method. AWS uses the payment method to charge for any billable (not free
tier) AWS activity that occurs while the account isn\'t attached to an
organization. To remove an account that doesn\'t yet have this
information, you must sign in as the member account. Then follow the
steps at \href{http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info}{To leave an organization when all required account information has not yet been provided}
in the \emph{AWS Organizations User Guide.}
}
\section{Request syntax}{
\preformatted{svc$remove_account_from_organization(
  AccountId = "string"
)
}
}

\examples{
# The following example shows you how to remove an account from an
# organization:
\dontrun{svc$remove_account_from_organization(
  AccountId = "333333333333"
)}

}
\keyword{internal}
