% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_create_policy}
\alias{organizations_create_policy}
\title{Creates a policy of a specified type that you can attach to a root, an
organizational unit (OU), or an individual AWS account}
\usage{
organizations_create_policy(Content, Description, Name, Type)
}
\arguments{
\item{Content}{[required] The policy content to add to the new policy. For example, you could
create a \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html}{service control policy}
(SCP) that specifies the permissions that administrators in attached
accounts can delegate to their users, groups, and roles. The string for
this SCP must be JSON text. For more information about the SCP syntax,
see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html}{Service Control Policy Syntax}
in the \emph{AWS Organizations User Guide.}}

\item{Description}{[required] An optional description to assign to the policy.}

\item{Name}{[required] The friendly name to assign to the policy.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} that is used to
validate this parameter is a string of any of the characters in the
ASCII character range.}

\item{Type}{[required] The type of policy to create.}
}
\description{
Creates a policy of a specified type that you can attach to a root, an
organizational unit (OU), or an individual AWS account.
}
\details{
For more information about policies and their use, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html}{Managing Organization Policies}.

This operation can be called only from the organization\'s master
account.
}
\section{Request syntax}{
\preformatted{svc$create_policy(
  Content = "string",
  Description = "string",
  Name = "string",
  Type = "SERVICE_CONTROL_POLICY"|"TAG_POLICY"
)
}
}

\examples{
# The following example shows how to create a service control policy (SCP)
# that is named AllowAllS3Actions. The JSON string in the content
# parameter specifies the content in the policy. The parameter string is
# escaped with backslashes to ensure that the embedded double quotes in
# the JSON policy are treated as literals in the parameter, which itself
# is surrounded by double quotes:
# 
# 
\dontrun{svc$create_policy(
  Content = "\{\\\\\"Version\\\\\":\\\\\"2012-10-17\\\\\",\\\\\"Statement\\\\\":\{\\\\\"Effect\\\\\":...",
  Description = "Enables admins of attached accounts to delegate all S3 permissions",
  Name = "AllowAllS3Actions",
  Type = "SERVICE_CONTROL_POLICY"
)}

}
\keyword{internal}
