# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include support_service.R
NULL

#' Adds one or more attachments to an attachment set
#'
#' Adds one or more attachments to an attachment set. If an
#' `attachmentSetId` is not specified, a new attachment set is created, and
#' the ID of the set is returned in the response. If an `attachmentSetId`
#' is specified, the attachments are added to the specified set, if it
#' exists.
#' 
#' An attachment set is a temporary container for attachments that are to
#' be added to a case or case communication. The set is available for one
#' hour after it is created; the `expiryTime` returned in the response
#' indicates when the set expires. The maximum number of attachments in a
#' set is 3, and the maximum size of any attachment in the set is 5 MB.
#'
#' @usage
#' support_add_attachments_to_set(attachmentSetId, attachments)
#'
#' @param attachmentSetId The ID of the attachment set. If an `attachmentSetId` is not specified,
#' a new attachment set is created, and the ID of the set is returned in
#' the response. If an `attachmentSetId` is specified, the attachments are
#' added to the specified set, if it exists.
#' @param attachments &#91;required&#93; One or more attachments to add to the set. The limit is 3 attachments
#' per set, and the size limit is 5 MB per attachment.
#'
#' @section Request syntax:
#' ```
#' svc$add_attachments_to_set(
#'   attachmentSetId = "string",
#'   attachments = list(
#'     list(
#'       fileName = "string",
#'       data = raw
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_add_attachments_to_set
support_add_attachments_to_set <- function(attachmentSetId = NULL, attachments) {
  op <- new_operation(
    name = "AddAttachmentsToSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$add_attachments_to_set_input(attachmentSetId = attachmentSetId, attachments = attachments)
  output <- .support$add_attachments_to_set_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$add_attachments_to_set <- support_add_attachments_to_set

#' Adds additional customer communication to an AWS Support case
#'
#' Adds additional customer communication to an AWS Support case. You use
#' the `caseId` value to identify the case to add communication to. You can
#' list a set of email addresses to copy on the communication using the
#' `ccEmailAddresses` value. The `communicationBody` value contains the
#' text of the communication.
#' 
#' The response indicates the success or failure of the request.
#' 
#' This operation implements a subset of the features of the AWS Support
#' Center.
#'
#' @usage
#' support_add_communication_to_case(caseId, communicationBody,
#'   ccEmailAddresses, attachmentSetId)
#'
#' @param caseId The AWS Support case ID requested or returned in the call. The case ID
#' is an alphanumeric string formatted as shown in this example:
#' case-*12345678910-2013-c4c1d2bf33c5cf47*
#' @param communicationBody &#91;required&#93; The body of an email communication to add to the support case.
#' @param ccEmailAddresses The email addresses in the CC line of an email to be added to the
#' support case.
#' @param attachmentSetId The ID of a set of one or more attachments for the communication to add
#' to the case. Create the set by calling AddAttachmentsToSet
#'
#' @section Request syntax:
#' ```
#' svc$add_communication_to_case(
#'   caseId = "string",
#'   communicationBody = "string",
#'   ccEmailAddresses = list(
#'     "string"
#'   ),
#'   attachmentSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_add_communication_to_case
support_add_communication_to_case <- function(caseId = NULL, communicationBody, ccEmailAddresses = NULL, attachmentSetId = NULL) {
  op <- new_operation(
    name = "AddCommunicationToCase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$add_communication_to_case_input(caseId = caseId, communicationBody = communicationBody, ccEmailAddresses = ccEmailAddresses, attachmentSetId = attachmentSetId)
  output <- .support$add_communication_to_case_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$add_communication_to_case <- support_add_communication_to_case

#' Creates a new case in the AWS Support Center
#'
#' Creates a new case in the AWS Support Center. This operation is modeled
#' on the behavior of the AWS Support Center [Create
#' Case](https://console.aws.amazon.com/support/home#/case/create) page.
#' Its parameters require you to specify the following information:
#' 
#' -   **issueType.** The type of issue for the case. You can specify
#'     either \"customer-service\" or \"technical.\" If you do not indicate
#'     a value, the default is \"technical.\"
#' 
#'     Service limit increases are not supported by the Support API; you
#'     must submit service limit increase requests in [Support
#'     Center](https://console.aws.amazon.com/support).
#' 
#'     The `caseId` is not the `displayId` that appears in [Support
#'     Center](https://console.aws.amazon.com/support). You can use the
#'     DescribeCases API to get the `displayId`.
#' 
#' -   **serviceCode.** The code for an AWS service. You can get the
#'     possible `serviceCode` values by calling DescribeServices.
#' 
#' -   **categoryCode.** The category for the service defined for the
#'     `serviceCode` value. You also get the category code for a service by
#'     calling DescribeServices. Each AWS service defines its own set of
#'     category codes.
#' 
#' -   **severityCode.** A value that indicates the urgency of the case,
#'     which in turn determines the response time according to your service
#'     level agreement with AWS Support. You can get the possible
#'     `severityCode` values by calling DescribeSeverityLevels. For more
#'     information about the meaning of the codes, see SeverityLevel and
#'     [Choosing a
#'     Severity](https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity).
#' 
#' -   **subject.** The **Subject** field on the AWS Support Center [Create
#'     Case](https://console.aws.amazon.com/support/home#/case/create)
#'     page.
#' 
#' -   **communicationBody.** The **Description** field on the AWS Support
#'     Center [Create
#'     Case](https://console.aws.amazon.com/support/home#/case/create)
#'     page.
#' 
#' -   **attachmentSetId.** The ID of a set of attachments that has been
#'     created by using AddAttachmentsToSet.
#' 
#' -   **language.** The human language in which AWS Support handles the
#'     case. English and Japanese are currently supported.
#' 
#' -   **ccEmailAddresses.** The AWS Support Center **CC** field on the
#'     [Create
#'     Case](https://console.aws.amazon.com/support/home#/case/create)
#'     page. You can list email addresses to be copied on any
#'     correspondence about the case. The account that opens the case is
#'     already identified by passing the AWS Credentials in the HTTP POST
#'     method or in a method or function call from one of the programming
#'     languages supported by an [AWS SDK](http://aws.amazon.com/tools/).
#' 
#' To add additional communication or attachments to an existing case, use
#' AddCommunicationToCase.
#' 
#' A successful CreateCase request returns an AWS Support case number. Case
#' numbers are used by the DescribeCases operation to retrieve existing AWS
#' Support cases.
#'
#' @usage
#' support_create_case(subject, serviceCode, severityCode, categoryCode,
#'   communicationBody, ccEmailAddresses, language, issueType,
#'   attachmentSetId)
#'
#' @param subject &#91;required&#93; The title of the AWS Support case.
#' @param serviceCode The code for the AWS service returned by the call to DescribeServices.
#' @param severityCode The code for the severity level returned by the call to
#' DescribeSeverityLevels.
#' 
#' The availability of severity levels depends on the support plan for the
#' account.
#' @param categoryCode The category of problem for the AWS Support case.
#' @param communicationBody &#91;required&#93; The communication body text when you create an AWS Support case by
#' calling CreateCase.
#' @param ccEmailAddresses A list of email addresses that AWS Support copies on case
#' correspondence.
#' @param language The ISO 639-1 code for the language in which AWS provides support. AWS
#' Support currently supports English (\"en\") and Japanese (\"ja\").
#' Language parameters must be passed explicitly for operations that take
#' them.
#' @param issueType The type of issue for the case. You can specify either
#' \"customer-service\" or \"technical.\" If you do not indicate a value,
#' the default is \"technical.\"
#' 
#' Service limit increases are not supported by the Support API; you must
#' submit service limit increase requests in [Support
#' Center](https://console.aws.amazon.com/support).
#' @param attachmentSetId The ID of a set of one or more attachments for the case. Create the set
#' by using AddAttachmentsToSet.
#'
#' @section Request syntax:
#' ```
#' svc$create_case(
#'   subject = "string",
#'   serviceCode = "string",
#'   severityCode = "string",
#'   categoryCode = "string",
#'   communicationBody = "string",
#'   ccEmailAddresses = list(
#'     "string"
#'   ),
#'   language = "string",
#'   issueType = "string",
#'   attachmentSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_create_case
support_create_case <- function(subject, serviceCode = NULL, severityCode = NULL, categoryCode = NULL, communicationBody, ccEmailAddresses = NULL, language = NULL, issueType = NULL, attachmentSetId = NULL) {
  op <- new_operation(
    name = "CreateCase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$create_case_input(subject = subject, serviceCode = serviceCode, severityCode = severityCode, categoryCode = categoryCode, communicationBody = communicationBody, ccEmailAddresses = ccEmailAddresses, language = language, issueType = issueType, attachmentSetId = attachmentSetId)
  output <- .support$create_case_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$create_case <- support_create_case

#' Returns the attachment that has the specified ID
#'
#' Returns the attachment that has the specified ID. Attachment IDs are
#' generated by the case management system when you add an attachment to a
#' case or case communication. Attachment IDs are returned in the
#' AttachmentDetails objects that are returned by the
#' DescribeCommunications operation.
#'
#' @usage
#' support_describe_attachment(attachmentId)
#'
#' @param attachmentId &#91;required&#93; The ID of the attachment to return. Attachment IDs are returned by the
#' DescribeCommunications operation.
#'
#' @section Request syntax:
#' ```
#' svc$describe_attachment(
#'   attachmentId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_attachment
support_describe_attachment <- function(attachmentId) {
  op <- new_operation(
    name = "DescribeAttachment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_attachment_input(attachmentId = attachmentId)
  output <- .support$describe_attachment_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_attachment <- support_describe_attachment

#' Returns a list of cases that you specify by passing one or more case IDs
#'
#' Returns a list of cases that you specify by passing one or more case
#' IDs. In addition, you can filter the cases by date by setting values for
#' the `afterTime` and `beforeTime` request parameters. You can set values
#' for the `includeResolvedCases` and `includeCommunications` request
#' parameters to control how much information is returned.
#' 
#' Case data is available for 12 months after creation. If a case was
#' created more than 12 months ago, a request for data might cause an
#' error.
#' 
#' The response returns the following in JSON format:
#' 
#' -   One or more CaseDetails data types.
#' 
#' -   One or more `nextToken` values, which specify where to paginate the
#'     returned records represented by the `CaseDetails` objects.
#'
#' @usage
#' support_describe_cases(caseIdList, displayId, afterTime, beforeTime,
#'   includeResolvedCases, nextToken, maxResults, language,
#'   includeCommunications)
#'
#' @param caseIdList A list of ID numbers of the support cases you want returned. The maximum
#' number of cases is 100.
#' @param displayId The ID displayed for a case in the AWS Support Center user interface.
#' @param afterTime The start date for a filtered date search on support case
#' communications. Case communications are available for 12 months after
#' creation.
#' @param beforeTime The end date for a filtered date search on support case communications.
#' Case communications are available for 12 months after creation.
#' @param includeResolvedCases Specifies whether resolved support cases should be included in the
#' DescribeCases results. The default is *false*.
#' @param nextToken A resumption point for pagination.
#' @param maxResults The maximum number of results to return before paginating.
#' @param language The ISO 639-1 code for the language in which AWS provides support. AWS
#' Support currently supports English (\"en\") and Japanese (\"ja\").
#' Language parameters must be passed explicitly for operations that take
#' them.
#' @param includeCommunications Specifies whether communications should be included in the DescribeCases
#' results. The default is *true*.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cases(
#'   caseIdList = list(
#'     "string"
#'   ),
#'   displayId = "string",
#'   afterTime = "string",
#'   beforeTime = "string",
#'   includeResolvedCases = TRUE|FALSE,
#'   nextToken = "string",
#'   maxResults = 123,
#'   language = "string",
#'   includeCommunications = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_cases
support_describe_cases <- function(caseIdList = NULL, displayId = NULL, afterTime = NULL, beforeTime = NULL, includeResolvedCases = NULL, nextToken = NULL, maxResults = NULL, language = NULL, includeCommunications = NULL) {
  op <- new_operation(
    name = "DescribeCases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_cases_input(caseIdList = caseIdList, displayId = displayId, afterTime = afterTime, beforeTime = beforeTime, includeResolvedCases = includeResolvedCases, nextToken = nextToken, maxResults = maxResults, language = language, includeCommunications = includeCommunications)
  output <- .support$describe_cases_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_cases <- support_describe_cases

#' Returns communications (and attachments) for one or more support cases
#'
#' Returns communications (and attachments) for one or more support cases.
#' You can use the `afterTime` and `beforeTime` parameters to filter by
#' date. You can use the `caseId` parameter to restrict the results to a
#' particular case.
#' 
#' Case data is available for 12 months after creation. If a case was
#' created more than 12 months ago, a request for data might cause an
#' error.
#' 
#' You can use the `maxResults` and `nextToken` parameters to control the
#' pagination of the result set. Set `maxResults` to the number of cases
#' you want displayed on each page, and use `nextToken` to specify the
#' resumption of pagination.
#'
#' @usage
#' support_describe_communications(caseId, beforeTime, afterTime,
#'   nextToken, maxResults)
#'
#' @param caseId &#91;required&#93; The AWS Support case ID requested or returned in the call. The case ID
#' is an alphanumeric string formatted as shown in this example:
#' case-*12345678910-2013-c4c1d2bf33c5cf47*
#' @param beforeTime The end date for a filtered date search on support case communications.
#' Case communications are available for 12 months after creation.
#' @param afterTime The start date for a filtered date search on support case
#' communications. Case communications are available for 12 months after
#' creation.
#' @param nextToken A resumption point for pagination.
#' @param maxResults The maximum number of results to return before paginating.
#'
#' @section Request syntax:
#' ```
#' svc$describe_communications(
#'   caseId = "string",
#'   beforeTime = "string",
#'   afterTime = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_communications
support_describe_communications <- function(caseId, beforeTime = NULL, afterTime = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeCommunications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_communications_input(caseId = caseId, beforeTime = beforeTime, afterTime = afterTime, nextToken = nextToken, maxResults = maxResults)
  output <- .support$describe_communications_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_communications <- support_describe_communications

#' Returns the current list of AWS services and a list of service
#' categories that applies to each one
#'
#' Returns the current list of AWS services and a list of service
#' categories that applies to each one. You then use service names and
#' categories in your CreateCase requests. Each AWS service has its own set
#' of categories.
#' 
#' The service codes and category codes correspond to the values that are
#' displayed in the **Service** and **Category** drop-down lists on the AWS
#' Support Center [Create
#' Case](https://console.aws.amazon.com/support/home#/case/create) page.
#' The values in those fields, however, do not necessarily match the
#' service codes and categories returned by the `DescribeServices` request.
#' Always use the service codes and categories obtained programmatically.
#' This practice ensures that you always have the most recent set of
#' service and category codes.
#'
#' @usage
#' support_describe_services(serviceCodeList, language)
#'
#' @param serviceCodeList A JSON-formatted list of service codes available for AWS services.
#' @param language The ISO 639-1 code for the language in which AWS provides support. AWS
#' Support currently supports English (\"en\") and Japanese (\"ja\").
#' Language parameters must be passed explicitly for operations that take
#' them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_services(
#'   serviceCodeList = list(
#'     "string"
#'   ),
#'   language = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_services
support_describe_services <- function(serviceCodeList = NULL, language = NULL) {
  op <- new_operation(
    name = "DescribeServices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_services_input(serviceCodeList = serviceCodeList, language = language)
  output <- .support$describe_services_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_services <- support_describe_services

#' Returns the list of severity levels that you can assign to an AWS
#' Support case
#'
#' Returns the list of severity levels that you can assign to an AWS
#' Support case. The severity level for a case is also a field in the
#' CaseDetails data type included in any CreateCase request.
#'
#' @usage
#' support_describe_severity_levels(language)
#'
#' @param language The ISO 639-1 code for the language in which AWS provides support. AWS
#' Support currently supports English (\"en\") and Japanese (\"ja\").
#' Language parameters must be passed explicitly for operations that take
#' them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_severity_levels(
#'   language = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_severity_levels
support_describe_severity_levels <- function(language = NULL) {
  op <- new_operation(
    name = "DescribeSeverityLevels",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_severity_levels_input(language = language)
  output <- .support$describe_severity_levels_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_severity_levels <- support_describe_severity_levels

#' Returns the refresh status of the Trusted Advisor checks that have the
#' specified check IDs
#'
#' Returns the refresh status of the Trusted Advisor checks that have the
#' specified check IDs. Check IDs can be obtained by calling
#' DescribeTrustedAdvisorChecks.
#' 
#' Some checks are refreshed automatically, and their refresh statuses
#' cannot be retrieved by using this operation. Use of the
#' `DescribeTrustedAdvisorCheckRefreshStatuses` operation for these checks
#' causes an `InvalidParameterValue` error.
#'
#' @usage
#' support_describe_trusted_advisor_check_refresh_statuses(checkIds)
#'
#' @param checkIds &#91;required&#93; The IDs of the Trusted Advisor checks to get the status of. **Note:**
#' Specifying the check ID of a check that is automatically refreshed
#' causes an `InvalidParameterValue` error.
#'
#' @section Request syntax:
#' ```
#' svc$describe_trusted_advisor_check_refresh_statuses(
#'   checkIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_trusted_advisor_check_refresh_statuses
support_describe_trusted_advisor_check_refresh_statuses <- function(checkIds) {
  op <- new_operation(
    name = "DescribeTrustedAdvisorCheckRefreshStatuses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_trusted_advisor_check_refresh_statuses_input(checkIds = checkIds)
  output <- .support$describe_trusted_advisor_check_refresh_statuses_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_trusted_advisor_check_refresh_statuses <- support_describe_trusted_advisor_check_refresh_statuses

#' Returns the results of the Trusted Advisor check that has the specified
#' check ID
#'
#' Returns the results of the Trusted Advisor check that has the specified
#' check ID. Check IDs can be obtained by calling
#' DescribeTrustedAdvisorChecks.
#' 
#' The response contains a TrustedAdvisorCheckResult object, which contains
#' these three objects:
#' 
#' -   TrustedAdvisorCategorySpecificSummary
#' 
#' -   TrustedAdvisorResourceDetail
#' 
#' -   TrustedAdvisorResourcesSummary
#' 
#' In addition, the response contains these fields:
#' 
#' -   **status.** The alert status of the check: \"ok\" (green),
#'     \"warning\" (yellow), \"error\" (red), or \"not\\_available\".
#' 
#' -   **timestamp.** The time of the last refresh of the check.
#' 
#' -   **checkId.** The unique identifier for the check.
#'
#' @usage
#' support_describe_trusted_advisor_check_result(checkId, language)
#'
#' @param checkId &#91;required&#93; The unique identifier for the Trusted Advisor check.
#' @param language The ISO 639-1 code for the language in which AWS provides support. AWS
#' Support currently supports English (\"en\") and Japanese (\"ja\").
#' Language parameters must be passed explicitly for operations that take
#' them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_trusted_advisor_check_result(
#'   checkId = "string",
#'   language = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_trusted_advisor_check_result
support_describe_trusted_advisor_check_result <- function(checkId, language = NULL) {
  op <- new_operation(
    name = "DescribeTrustedAdvisorCheckResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_trusted_advisor_check_result_input(checkId = checkId, language = language)
  output <- .support$describe_trusted_advisor_check_result_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_trusted_advisor_check_result <- support_describe_trusted_advisor_check_result

#' Returns the summaries of the results of the Trusted Advisor checks that
#' have the specified check IDs
#'
#' Returns the summaries of the results of the Trusted Advisor checks that
#' have the specified check IDs. Check IDs can be obtained by calling
#' DescribeTrustedAdvisorChecks.
#' 
#' The response contains an array of TrustedAdvisorCheckSummary objects.
#'
#' @usage
#' support_describe_trusted_advisor_check_summaries(checkIds)
#'
#' @param checkIds &#91;required&#93; The IDs of the Trusted Advisor checks.
#'
#' @section Request syntax:
#' ```
#' svc$describe_trusted_advisor_check_summaries(
#'   checkIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_trusted_advisor_check_summaries
support_describe_trusted_advisor_check_summaries <- function(checkIds) {
  op <- new_operation(
    name = "DescribeTrustedAdvisorCheckSummaries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_trusted_advisor_check_summaries_input(checkIds = checkIds)
  output <- .support$describe_trusted_advisor_check_summaries_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_trusted_advisor_check_summaries <- support_describe_trusted_advisor_check_summaries

#' Returns information about all available Trusted Advisor checks,
#' including name, ID, category, description, and metadata
#'
#' Returns information about all available Trusted Advisor checks,
#' including name, ID, category, description, and metadata. You must
#' specify a language code; English (\"en\") and Japanese (\"ja\") are
#' currently supported. The response contains a
#' TrustedAdvisorCheckDescription for each check. The region must be set to
#' us-east-1.
#'
#' @usage
#' support_describe_trusted_advisor_checks(language)
#'
#' @param language &#91;required&#93; The ISO 639-1 code for the language in which AWS provides support. AWS
#' Support currently supports English (\"en\") and Japanese (\"ja\").
#' Language parameters must be passed explicitly for operations that take
#' them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_trusted_advisor_checks(
#'   language = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_trusted_advisor_checks
support_describe_trusted_advisor_checks <- function(language) {
  op <- new_operation(
    name = "DescribeTrustedAdvisorChecks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_trusted_advisor_checks_input(language = language)
  output <- .support$describe_trusted_advisor_checks_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_trusted_advisor_checks <- support_describe_trusted_advisor_checks

#' Requests a refresh of the Trusted Advisor check that has the specified
#' check ID
#'
#' Requests a refresh of the Trusted Advisor check that has the specified
#' check ID. Check IDs can be obtained by calling
#' DescribeTrustedAdvisorChecks.
#' 
#' Some checks are refreshed automatically, and they cannot be refreshed by
#' using this operation. Use of the `RefreshTrustedAdvisorCheck` operation
#' for these checks causes an `InvalidParameterValue` error.
#' 
#' The response contains a TrustedAdvisorCheckRefreshStatus object, which
#' contains these fields:
#' 
#' -   **status.** The refresh status of the check:
#' 
#'     -   `none:` The check is not refreshed or the non-success status
#'         exceeds the timeout
#' 
#'     -   `enqueued:` The check refresh requests has entered the refresh
#'         queue
#' 
#'     -   `processing:` The check refresh request is picked up by the rule
#'         processing engine
#' 
#'     -   `success:` The check is successfully refreshed
#' 
#'     -   `abandoned:` The check refresh has failed
#' 
#' -   **millisUntilNextRefreshable.** The amount of time, in milliseconds,
#'     until the check is eligible for refresh.
#' 
#' -   **checkId.** The unique identifier for the check.
#'
#' @usage
#' support_refresh_trusted_advisor_check(checkId)
#'
#' @param checkId &#91;required&#93; The unique identifier for the Trusted Advisor check to refresh.
#' **Note:** Specifying the check ID of a check that is automatically
#' refreshed causes an `InvalidParameterValue` error.
#'
#' @section Request syntax:
#' ```
#' svc$refresh_trusted_advisor_check(
#'   checkId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_refresh_trusted_advisor_check
support_refresh_trusted_advisor_check <- function(checkId) {
  op <- new_operation(
    name = "RefreshTrustedAdvisorCheck",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$refresh_trusted_advisor_check_input(checkId = checkId)
  output <- .support$refresh_trusted_advisor_check_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$refresh_trusted_advisor_check <- support_refresh_trusted_advisor_check

#' Takes a caseId and returns the initial state of the case along with the
#' state of the case after the call to ResolveCase completed
#'
#' Takes a `caseId` and returns the initial state of the case along with
#' the state of the case after the call to ResolveCase completed.
#'
#' @usage
#' support_resolve_case(caseId)
#'
#' @param caseId The AWS Support case ID requested or returned in the call. The case ID
#' is an alphanumeric string formatted as shown in this example:
#' case-*12345678910-2013-c4c1d2bf33c5cf47*
#'
#' @section Request syntax:
#' ```
#' svc$resolve_case(
#'   caseId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_resolve_case
support_resolve_case <- function(caseId = NULL) {
  op <- new_operation(
    name = "ResolveCase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$resolve_case_input(caseId = caseId)
  output <- .support$resolve_case_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$resolve_case <- support_resolve_case
