% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_put_parameter}
\alias{ssm_put_parameter}
\title{Add a parameter to the system}
\usage{
ssm_put_parameter(Name, Description, Value, Type, KeyId, Overwrite,
  AllowedPattern, Tags, Tier, Policies)
}
\arguments{
\item{Name}{[required] The fully qualified name of the parameter that you want to add to the
system. The fully qualified name includes the complete hierarchy of the
parameter path and name. For example: \code{/Dev/DBServer/MySQL/db-string13}

Naming Constraints:
\itemize{
\item Parameter names are case sensitive.
\item A parameter name must be unique within an AWS Region
\item A parameter name can't be prefixed with "aws" or "ssm"
(case-insensitive).
\item Parameter names can include only the following symbols and letters:
\code{a-zA-Z0-9_.-/}
\item A parameter name can't include spaces.
\item Parameter hierarchies are limited to a maximum depth of fifteen
levels.
}

For additional information about valid values for parameter names, see
\href{http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html}{Requirements and Constraints for Parameter Names}
in the \emph{AWS Systems Manager User Guide}.

The maximum length constraint listed below includes capacity for
additional system attributes that are not part of the name. The maximum
length for the fully qualified parameter name is 1011 characters.}

\item{Description}{Information about the parameter that you want to add to the system.
Optional but recommended.

Do not enter personally identifiable information in this field.}

\item{Value}{[required] The parameter value that you want to add to the system. Standard
parameters have a value limit of 4 KB. Advanced parameters have a value
limit of 8 KB.}

\item{Type}{[required] The type of parameter that you want to add to the system.

Items in a \code{StringList} must be separated by a comma (,). You can't use
other punctuation or special character to escape items in the list. If
you have a parameter value that requires a comma, then use the \code{String}
data type.

\code{SecureString} is not currently supported for AWS CloudFormation
templates or in the China Regions.}

\item{KeyId}{The KMS Key ID that you want to use to encrypt a parameter. Either the
default AWS Key Management Service (AWS KMS) key automatically assigned
to your AWS account or a custom key. Required for parameters that use
the \code{SecureString} data type.

If you don't specify a key ID, the system uses the default key
associated with your AWS account.
\itemize{
\item To use your default AWS KMS key, choose the \code{SecureString} data
type, and do \emph{not} specify the \code{Key ID} when you create the
parameter. The system automatically populates \code{Key ID} with your
default KMS key.
\item To use a custom KMS key, choose the \code{SecureString} data type with
the \code{Key ID} parameter.
}}

\item{Overwrite}{Overwrite an existing parameter. If not specified, will default to
"false".}

\item{AllowedPattern}{A regular expression used to validate the parameter value. For example,
for String types with values restricted to numbers, you can specify the
following: AllowedPattern=\^\code{\\d}+\$}

\item{Tags}{Optional metadata that you assign to a resource. Tags enable you to
categorize a resource in different ways, such as by purpose, owner, or
environment. For example, you might want to tag a Systems Manager
parameter to identify the type of resource to which it applies, the
environment, or the type of configuration data referenced by the
parameter. In this case, you could specify the following key name/value
pairs:
\itemize{
\item \code{Key=Resource,Value=S3bucket}
\item \code{Key=OS,Value=Windows}
\item \code{Key=ParameterType,Value=LicenseKey}
}

To add tags to an existing Systems Manager parameter, use the
AddTagsToResource action.}

\item{Tier}{Parameter Store offers a standard tier and an advanced tier for
parameters. Standard parameters have a value limit of 4 KB and can't be
configured to use parameter policies. You can create a maximum of 10,000
standard parameters per account and per Region. Standard parameters are
offered at no additional cost.

Advanced parameters have a value limit of 8 KB and can be configured to
use parameter policies. You can create a maximum of 100,000 advanced
parameters per account and per Region. Advanced parameters incur a
charge.

If you don't specify a parameter tier when you create a new parameter,
the parameter defaults to using the standard tier. You can change a
standard parameter to an advanced parameter at any time. But you can't
revert an advanced parameter to a standard parameter. Reverting an
advanced parameter to a standard parameter would result in data loss
because the system would truncate the size of the parameter from 8 KB to
4 KB. Reverting would also remove any policies attached to the
parameter. Lastly, advanced parameters use a different form of
encryption than standard parameters.

If you no longer need an advanced parameter, or if you no longer want to
incur charges for an advanced parameter, you must delete it and recreate
it as a new standard parameter. For more information, see \href{http://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html}{About Advanced Parameters}
in the \emph{AWS Systems Manager User Guide}.}

\item{Policies}{One or more policies to apply to a parameter. This action takes a JSON
array. Parameter Store supports the following policy types:

Expiration: This policy deletes the parameter after it expires. When you
create the policy, you specify the expiration date. You can update the
expiration date and time by updating the policy. Updating the
\emph{parameter} does not affect the expiration date and time. When the
expiration time is reached, Parameter Store deletes the parameter.

ExpirationNotification: This policy triggers an event in Amazon
CloudWatch Events that notifies you about the expiration. By using this
policy, you can receive notification before or after the expiration time
is reached, in units of days or hours.

NoChangeNotification: This policy triggers a CloudWatch event if a
parameter has not been modified for a specified period of time. This
policy type is useful when, for example, a secret needs to be changed
within a period of time, but it has not been changed.

All existing policies are preserved until you send new policies or an
empty policy. For more information about parameter policies, see
\href{http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-su-policies.html}{Working with Parameter Policies}.}
}
\description{
Add a parameter to the system.
}
\section{Request syntax}{
\preformatted{svc$put_parameter(
  Name = "string",
  Description = "string",
  Value = "string",
  Type = "String"|"StringList"|"SecureString",
  KeyId = "string",
  Overwrite = TRUE|FALSE,
  AllowedPattern = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  Tier = "Standard"|"Advanced",
  Policies = "string"
)
}
}

\keyword{internal}
