% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_get_inventory}
\alias{ssm_get_inventory}
\title{Query inventory information}
\usage{
ssm_get_inventory(Filters, Aggregators, ResultAttributes, NextToken,
  MaxResults)
}
\arguments{
\item{Filters}{One or more filters. Use a filter to return a more specific list of
results.}

\item{Aggregators}{Returns counts of inventory types based on one or more expressions. For
example, if you aggregate by using an expression that uses the
\code{AWS:InstanceInformation.PlatformType} type, you can see a count of how
many Windows and Linux instances exist in your inventoried fleet.}

\item{ResultAttributes}{The list of inventory item types to return.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}
}
\description{
Query inventory information.
}
\section{Request syntax}{
\preformatted{svc$get_inventory(
  Filters = list(
    list(
      Key = "string",
      Values = list(
        "string"
      ),
      Type = "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"|"Exists"
    )
  ),
  Aggregators = list(
    list(
      Expression = "string",
      Aggregators = list(),
      Groups = list(
        list(
          Name = "string",
          Filters = list(
            list(
              Key = "string",
              Values = list(
                "string"
              ),
              Type = "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"|"Exists"
            )
          )
        )
      )
    )
  ),
  ResultAttributes = list(
    list(
      TypeName = "string"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
