% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_update_provisioning_artifact}
\alias{servicecatalog_update_provisioning_artifact}
\title{Updates the specified provisioning artifact (also known as a version)
for the specified product}
\usage{
servicecatalog_update_provisioning_artifact(AcceptLanguage, ProductId,
  ProvisioningArtifactId, Name, Description, Active, Guidance)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{ProductId}{[required] The product identifier.}

\item{ProvisioningArtifactId}{[required] The identifier of the provisioning artifact.}

\item{Name}{The updated name of the provisioning artifact.}

\item{Description}{The updated description of the provisioning artifact.}

\item{Active}{Indicates whether the product version is active.}

\item{Guidance}{Information set by the administrator to provide guidance to end users
about which provisioning artifacts to use.

The \code{DEFAULT} value indicates that the product version is active.

The administrator can set the guidance to \code{DEPRECATED} to inform users
that the product version is deprecated. Users are able to make updates
to a provisioned product of a deprecated version but cannot launch new
provisioned products using a deprecated version.}
}
\description{
Updates the specified provisioning artifact (also known as a version)
for the specified product.
}
\details{
You cannot update a provisioning artifact for a product that was shared
with you.
}
\section{Request syntax}{
\preformatted{svc$update_provisioning_artifact(
  AcceptLanguage = "string",
  ProductId = "string",
  ProvisioningArtifactId = "string",
  Name = "string",
  Description = "string",
  Active = TRUE|FALSE,
  Guidance = "DEFAULT"|"DEPRECATED"
)
}
}

\keyword{internal}
