% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_execute_provisioned_product_service_action}
\alias{servicecatalog_execute_provisioned_product_service_action}
\title{Executes a self-service action against a provisioned product}
\usage{
servicecatalog_execute_provisioned_product_service_action(
  ProvisionedProductId, ServiceActionId, ExecuteToken, AcceptLanguage,
  Parameters)
}
\arguments{
\item{ProvisionedProductId}{[required] The identifier of the provisioned product.}

\item{ServiceActionId}{[required] The self-service action identifier. For example, \code{act-fs7abcd89wxyz}.}

\item{ExecuteToken}{[required] An idempotency token that uniquely identifies the execute request.}

\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{Parameters}{}
}
\description{
Executes a self-service action against a provisioned product.
}
\section{Request syntax}{
\preformatted{svc$execute_provisioned_product_service_action(
  ProvisionedProductId = "string",
  ServiceActionId = "string",
  ExecuteToken = "string",
  AcceptLanguage = "string",
  Parameters = list(
    list(
      "string"
    )
  )
)
}
}

\keyword{internal}
