% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_list_accounts}
\alias{organizations_list_accounts}
\title{Lists all the accounts in the organization}
\usage{
organizations_list_accounts(NextToken, MaxResults)
}
\arguments{
\item{NextToken}{Use this parameter if you receive a \code{NextToken} response in a previous
request that indicates that there is more output available. Set it to
the value of the previous call's \code{NextToken} response to indicate where
the output should continue from.}

\item{MaxResults}{(Optional) Use this to limit the number of results you want included per
page in the response. If you do not include this parameter, it defaults
to a value that is specific to the operation. If additional items exist
beyond the maximum you specify, the \code{NextToken} response element is
present and has a value (is not null). Include that value as the
\code{NextToken} request parameter in the next call to the operation to get
the next part of the results. Note that Organizations might return fewer
results than the maximum even when there are more results available. You
should check \code{NextToken} after every operation to ensure that you
receive all of the results.}
}
\description{
Lists all the accounts in the organization. To request only the accounts
in a specified root or organizational unit (OU), use the
ListAccountsForParent operation instead.
}
\details{
Always check the \code{NextToken} response parameter for a \code{null} value when
calling a \code{List*} operation. These operations can occasionally return an
empty set of results even when there are more results available. The
\code{NextToken} response parameter value is \code{null} \emph{only} when there are no
more results to display.

This operation can be called only from the organization's master
account.
}
\section{Request syntax}{
\preformatted{svc$list_accounts(
  NextToken = "string",
  MaxResults = 123
)
}
}

\examples{
# The following example shows you how to request a list of the accounts in
# an organization:
\donttest{svc$list_accounts()}

}
\keyword{internal}
