# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Application Auto Scaling
#'
#' @description
#' With Application Auto Scaling, you can configure automatic scaling for
#' your scalable resources. You can use Application Auto Scaling to
#' accomplish the following tasks:
#' 
#' -   Define scaling policies to automatically scale your AWS or custom
#'     resources
#' 
#' -   Scale your resources in response to CloudWatch alarms
#' 
#' -   Schedule one-time or recurring scaling actions
#' 
#' -   View the history of your scaling events
#' 
#' Application Auto Scaling can scale the following resources:
#' 
#' -   Amazon ECS services. For more information, see [Service Auto
#'     Scaling](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-auto-scaling.html)
#'     in the *Amazon Elastic Container Service Developer Guide*.
#' 
#' -   Amazon EC2 Spot fleets. For more information, see [Automatic Scaling
#'     for Spot
#'     Fleet](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-auto-scaling.html)
#'     in the *Amazon EC2 User Guide*.
#' 
#' -   Amazon EMR clusters. For more information, see [Using Automatic
#'     Scaling in Amazon
#'     EMR](https://docs.aws.amazon.com/ElasticMapReduce/latest/ManagementGuide/emr-automatic-scaling.html)
#'     in the *Amazon EMR Management Guide*.
#' 
#' -   AppStream 2.0 fleets. For more information, see [Fleet Auto Scaling
#'     for Amazon AppStream
#'     2.0](https://docs.aws.amazon.com/appstream2/latest/developerguide/autoscaling.html)
#'     in the *Amazon AppStream 2.0 Developer Guide*.
#' 
#' -   Provisioned read and write capacity for Amazon DynamoDB tables and
#'     global secondary indexes. For more information, see [Managing
#'     Throughput Capacity Automatically with DynamoDB Auto
#'     Scaling](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/AutoScaling.html)
#'     in the *Amazon DynamoDB Developer Guide*.
#' 
#' -   Amazon Aurora Replicas. For more information, see [Using Amazon
#'     Aurora Auto Scaling with Aurora
#'     Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Integrating.AutoScaling.html).
#' 
#' -   Amazon SageMaker endpoint variants. For more information, see
#'     [Automatically Scaling Amazon SageMaker
#'     Models](https://docs.aws.amazon.com/sagemaker/latest/dg/endpoint-auto-scaling.html).
#' 
#' -   Custom resources provided by your own applications or services. More
#'     information is available in our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' 
#' To learn more about Application Auto Scaling, including information
#' about granting IAM users required permissions for Application Auto
#' Scaling actions, see the [Application Auto Scaling User
#' Guide](https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- applicationautoscaling(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example deletes a scaling policy for the Amazon ECS service called
#' # web-app, which is running in the default cluster.
#' \donttest{svc <- applicationautoscaling()
#' svc$delete_scaling_policy(
#'   PolicyName = "web-app-cpu-lt-25",
#'   ResourceId = "service/default/web-app",
#'   ScalableDimension = "ecs:service:DesiredCount",
#'   ServiceNamespace = "ecs"
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=applicationautoscaling_delete_scaling_policy]{delete_scaling_policy} \tab Deletes the specified Application Auto Scaling scaling policy \cr
#'  \link[=applicationautoscaling_delete_scheduled_action]{delete_scheduled_action} \tab Deletes the specified Application Auto Scaling scheduled action \cr
#'  \link[=applicationautoscaling_deregister_scalable_target]{deregister_scalable_target} \tab Deregisters a scalable target \cr
#'  \link[=applicationautoscaling_describe_scalable_targets]{describe_scalable_targets} \tab Gets information about the scalable targets in the specified namespace \cr
#'  \link[=applicationautoscaling_describe_scaling_activities]{describe_scaling_activities} \tab Provides descriptive information about the scaling activities in the specified namespace from the previous six weeks\cr
#'  \link[=applicationautoscaling_describe_scaling_policies]{describe_scaling_policies} \tab Describes the scaling policies for the specified service namespace \cr
#'  \link[=applicationautoscaling_describe_scheduled_actions]{describe_scheduled_actions} \tab Describes the scheduled actions for the specified service namespace \cr
#'  \link[=applicationautoscaling_put_scaling_policy]{put_scaling_policy} \tab Creates or updates a policy for an Application Auto Scaling scalable target \cr
#'  \link[=applicationautoscaling_put_scheduled_action]{put_scheduled_action} \tab Creates or updates a scheduled action for an Application Auto Scaling scalable target \cr
#'  \link[=applicationautoscaling_register_scalable_target]{register_scalable_target} \tab Registers or updates a scalable target 
#' }
#'
#' @rdname applicationautoscaling
#' @export
applicationautoscaling <- function(config = list()) {
  svc <- .applicationautoscaling$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.applicationautoscaling <- list()

.applicationautoscaling$operations <- list()

.applicationautoscaling$metadata <- list(
  service_name = "autoscaling",
  endpoints = list("*" = list(endpoint = "autoscaling.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "autoscaling.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "Application Auto Scaling",
  api_version = "2016-02-06",
  signing_name = "application-autoscaling",
  json_version = "1.1",
  target_prefix = "AnyScaleFrontendService"
)

.applicationautoscaling$handlers <- new_handlers("jsonrpc", "v4")

.applicationautoscaling$service <- function(config = list()) {
  new_service(.applicationautoscaling$metadata, .applicationautoscaling$handlers, config)
}
