% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_list_change_sets}
\alias{cloudformation_list_change_sets}
\title{Returns the ID and status of each active change set for a stack}
\usage{
cloudformation_list_change_sets(StackName, NextToken)
}
\arguments{
\item{StackName}{[required] The name or the Amazon Resource Name (ARN) of the stack for which you
want to list change sets.}

\item{NextToken}{A string (provided by the ListChangeSets response output) that
identifies the next page of change sets that you want to retrieve.}
}
\description{
Returns the ID and status of each active change set for a stack. For
example, AWS CloudFormation lists change sets that are in the
\code{CREATE_IN_PROGRESS} or \code{CREATE_PENDING} state.
}
\section{Request syntax}{
\preformatted{svc$list_change_sets(
  StackName = "string",
  NextToken = "string"
)
}
}

\keyword{internal}
