% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_list_launch_paths}
\alias{servicecatalog_list_launch_paths}
\title{Lists the paths to the specified product}
\usage{
servicecatalog_list_launch_paths(AcceptLanguage, ProductId, PageSize,
  PageToken)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{ProductId}{[required] The product identifier.}

\item{PageSize}{The maximum number of items to return with this call.}

\item{PageToken}{The page token for the next set of results. To retrieve the first set of
results, use null.}
}
\value{
A list with the following syntax:\preformatted{list(
  LaunchPathSummaries = list(
    list(
      Id = "string",
      ConstraintSummaries = list(
        list(
          Type = "string",
          Description = "string"
        )
      ),
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      ),
      Name = "string"
    )
  ),
  NextPageToken = "string"
)
}
}
\description{
Lists the paths to the specified product. A path is how the user has
access to a specified product, and is necessary when provisioning a
product. A path also determines the constraints put on the product.
}
\section{Request syntax}{
\preformatted{svc$list_launch_paths(
  AcceptLanguage = "string",
  ProductId = "string",
  PageSize = 123,
  PageToken = "string"
)
}
}

\keyword{internal}
