% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_set_time_based_auto_scaling}
\alias{opsworks_set_time_based_auto_scaling}
\title{Specify the time-based auto scaling configuration for a specified
instance}
\usage{
opsworks_set_time_based_auto_scaling(InstanceId, AutoScalingSchedule)
}
\arguments{
\item{InstanceId}{[required] The instance ID.}

\item{AutoScalingSchedule}{An \code{AutoScalingSchedule} with the instance schedule.}
}
\value{
An empty list.
}
\description{
Specify the time-based auto scaling configuration for a specified
instance. For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html}{Managing Load with Time-based and Load-based Instances}.

\strong{Required Permissions}: To use this action, an IAM user must have a
Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions,
see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$set_time_based_auto_scaling(
  InstanceId = "string",
  AutoScalingSchedule = list(
    Monday = list(
      "string"
    ),
    Tuesday = list(
      "string"
    ),
    Wednesday = list(
      "string"
    ),
    Thursday = list(
      "string"
    ),
    Friday = list(
      "string"
    ),
    Saturday = list(
      "string"
    ),
    Sunday = list(
      "string"
    )
  )
)
}
}

\keyword{internal}
