% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_describe_delivery_channels}
\alias{configservice_describe_delivery_channels}
\title{Returns details about the specified delivery channel}
\usage{
configservice_describe_delivery_channels(DeliveryChannelNames)
}
\arguments{
\item{DeliveryChannelNames}{A list of delivery channel names.}
}
\value{
A list with the following syntax:\preformatted{list(
  DeliveryChannels = list(
    list(
      name = "string",
      s3BucketName = "string",
      s3KeyPrefix = "string",
      snsTopicARN = "string",
      configSnapshotDeliveryProperties = list(
        deliveryFrequency = "One_Hour"|"Three_Hours"|"Six_Hours"|"Twelve_Hours"|"TwentyFour_Hours"
      )
    )
  )
)
}
}
\description{
Returns details about the specified delivery channel. If a delivery
channel is not specified, this action returns the details of all
delivery channels associated with the account.

Currently, you can specify only one delivery channel per region in your
account.
}
\section{Request syntax}{
\preformatted{svc$describe_delivery_channels(
  DeliveryChannelNames = list(
    "string"
  )
)
}
}

\keyword{internal}
