% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_operations.R
\name{support_describe_cases}
\alias{support_describe_cases}
\title{Returns a list of cases that you specify by passing one or more case IDs}
\usage{
support_describe_cases(caseIdList, displayId, afterTime, beforeTime,
  includeResolvedCases, nextToken, maxResults, language,
  includeCommunications)
}
\arguments{
\item{caseIdList}{A list of ID numbers of the support cases you want returned. The maximum
number of cases is 100.}

\item{displayId}{The ID displayed for a case in the AWS Support Center user interface.}

\item{afterTime}{The start date for a filtered date search on support case
communications. Case communications are available for 12 months after
creation.}

\item{beforeTime}{The end date for a filtered date search on support case communications.
Case communications are available for 12 months after creation.}

\item{includeResolvedCases}{Specifies whether to include resolved support cases in the
\code{DescribeCases} response. By default, resolved cases aren't included.}

\item{nextToken}{A resumption point for pagination.}

\item{maxResults}{The maximum number of results to return before paginating.}

\item{language}{The ISO 639-1 code for the language in which AWS provides support. AWS
Support currently supports English ("en") and Japanese ("ja"). Language
parameters must be passed explicitly for operations that take them.}

\item{includeCommunications}{Specifies whether to include communications in the \code{DescribeCases}
response. By default, communications are incuded.}
}
\description{
Returns a list of cases that you specify by passing one or more case
IDs. You can use the \code{afterTime} and \code{beforeTime} parameters to filter
the cases by date. You can set values for the \code{includeResolvedCases} and
\code{includeCommunications} parameters to specify how much information to
return.

The response returns the following in JSON format:
\itemize{
\item One or more
\href{https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CaseDetails.html}{CaseDetails}
data types.
\item One or more \code{nextToken} values, which specify where to paginate the
returned records represented by the \code{CaseDetails} objects.
}

Case data is available for 12 months after creation. If a case was
created more than 12 months ago, a request might return an error.
\itemize{
\item You must have a Business or Enterprise support plan to use the AWS
Support API.
\item If you call the AWS Support API from an account that does not have a
Business or Enterprise support plan, the
\code{SubscriptionRequiredException} error message appears. For
information about changing your support plan, see \href{https://aws.amazon.com/premiumsupport/}{AWS Support}.
}
}
\section{Request syntax}{
\preformatted{svc$describe_cases(
  caseIdList = list(
    "string"
  ),
  displayId = "string",
  afterTime = "string",
  beforeTime = "string",
  includeResolvedCases = TRUE|FALSE,
  nextToken = "string",
  maxResults = 123,
  language = "string",
  includeCommunications = TRUE|FALSE
)
}
}

\keyword{internal}
