% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_create_stack_set}
\alias{cloudformation_create_stack_set}
\title{Creates a stack set}
\usage{
cloudformation_create_stack_set(StackSetName, Description, TemplateBody,
  TemplateURL, Parameters, Capabilities, Tags, AdministrationRoleARN,
  ExecutionRoleName, PermissionModel, AutoDeployment, ClientRequestToken)
}
\arguments{
\item{StackSetName}{[required] The name to associate with the stack set. The name must be unique in the
Region where you create your stack set.

A stack name can contain only alphanumeric characters (case-sensitive)
and hyphens. It must start with an alphabetic character and can't be
longer than 128 characters.}

\item{Description}{A description of the stack set. You can use the description to identify
the stack set's purpose or other important information.}

\item{TemplateBody}{The structure that contains the template body, with a minimum length of
1 byte and a maximum length of 51,200 bytes. For more information, see
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html}{Template Anatomy}
in the AWS CloudFormation User Guide.

Conditional: You must specify either the TemplateBody or the TemplateURL
parameter, but not both.}

\item{TemplateURL}{The location of the file that contains the template body. The URL must
point to a template (maximum size: 460,800 bytes) that's located in an
Amazon S3 bucket. For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html}{Template Anatomy}
in the AWS CloudFormation User Guide.

Conditional: You must specify either the TemplateBody or the TemplateURL
parameter, but not both.}

\item{Parameters}{The input parameters for the stack set template.}

\item{Capabilities}{In some cases, you must explicitly acknowledge that your stack set
template contains certain capabilities in order for AWS CloudFormation
to create the stack set and related stack instances.
\itemize{
\item \code{CAPABILITY_IAM} and \code{CAPABILITY_NAMED_IAM}

Some stack templates might include resources that can affect
permissions in your AWS account; for example, by creating new AWS
Identity and Access Management (IAM) users. For those stack sets,
you must explicitly acknowledge this by specifying one of these
capabilities.

The following IAM resources require you to specify either the
\code{CAPABILITY_IAM} or \code{CAPABILITY_NAMED_IAM} capability.
\itemize{
\item If you have IAM resources, you can specify either capability.
\item If you have IAM resources with custom names, you \emph{must} specify
\code{CAPABILITY_NAMED_IAM}.
\item If you don't specify either of these capabilities, AWS
CloudFormation returns an \code{InsufficientCapabilities} error.
}

If your stack template contains these resources, we recommend that
you review all permissions associated with them and edit their
permissions if necessary.
\itemize{
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html}{AWS::IAM::AccessKey}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html}{AWS::IAM::Group}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html}{AWS::IAM::InstanceProfile}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html}{AWS::IAM::Policy}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html}{AWS::IAM::Role}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html}{AWS::IAM::User}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html}{AWS::IAM::UserToGroupAddition}
}

For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities}{Acknowledging IAM Resources in AWS CloudFormation Templates}.
\item \code{CAPABILITY_AUTO_EXPAND}

Some templates contain macros. If your stack template contains one
or more macros, and you choose to create a stack directly from the
processed template, without first reviewing the resulting changes in
a change set, you must acknowledge this capability. For more
information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html}{Using AWS CloudFormation Macros to Perform Custom Processing on Templates}.

Stack sets do not currently support macros in stack templates. (This
includes the
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html}{AWS::Include}
and
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html}{AWS::Serverless}
transforms, which are macros hosted by AWS CloudFormation.) Even if
you specify this capability, if you include a macro in your template
the stack set operation will fail.
}}

\item{Tags}{The key-value pairs to associate with this stack set and the stacks
created from it. AWS CloudFormation also propagates these tags to
supported resources that are created in the stacks. A maximum number of
50 tags can be specified.

If you specify tags as part of a \code{CreateStackSet} action, AWS
CloudFormation checks to see if you have the required IAM permission to
tag resources. If you don't, the entire \code{CreateStackSet} action fails
with an \verb{access denied} error, and the stack set is not created.}

\item{AdministrationRoleARN}{The Amazon Resource Number (ARN) of the IAM role to use to create this
stack set.

Specify an IAM role only if you are using customized administrator roles
to control which users or groups can manage specific stack sets within
the same administrator account. For more information, see
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html}{Prerequisites: Granting Permissions for Stack Set Operations}
in the \emph{AWS CloudFormation User Guide}.}

\item{ExecutionRoleName}{The name of the IAM execution role to use to create the stack set. If
you do not specify an execution role, AWS CloudFormation uses the
\code{AWSCloudFormationStackSetExecutionRole} role for the stack set
operation.

Specify an IAM role only if you are using customized execution roles to
control which stack resources users and groups can include in their
stack sets.}

\item{PermissionModel}{Describes how the IAM roles required for stack set operations are
created. By default, \code{SELF-MANAGED} is specified.
\itemize{
\item With \code{self-managed} permissions, you must create the administrator
and execution roles required to deploy to target accounts. For more
information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html}{Grant Self-Managed Stack Set Permissions}.
\item With \code{service-managed} permissions, StackSets automatically creates
the IAM roles required to deploy to accounts managed by AWS
Organizations. For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/}{Grant Service-Managed Stack Set Permissions}.
}}

\item{AutoDeployment}{Describes whether StackSets automatically deploys to AWS Organizations
accounts that are added to the target organization or organizational
unit (OU). Specify only if \code{PermissionModel} is \code{SERVICE_MANAGED}.}

\item{ClientRequestToken}{A unique identifier for this \code{CreateStackSet} request. Specify this
token if you plan to retry requests so that AWS CloudFormation knows
that you're not attempting to create another stack set with the same
name. You might retry \code{CreateStackSet} requests to ensure that AWS
CloudFormation successfully received them.

If you don't specify an operation ID, the SDK generates one
automatically.}
}
\description{
Creates a stack set.
}
\section{Request syntax}{
\preformatted{svc$create_stack_set(
  StackSetName = "string",
  Description = "string",
  TemplateBody = "string",
  TemplateURL = "string",
  Parameters = list(
    list(
      ParameterKey = "string",
      ParameterValue = "string",
      UsePreviousValue = TRUE|FALSE,
      ResolvedValue = "string"
    )
  ),
  Capabilities = list(
    "CAPABILITY_IAM"|"CAPABILITY_NAMED_IAM"|"CAPABILITY_AUTO_EXPAND"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  AdministrationRoleARN = "string",
  ExecutionRoleName = "string",
  PermissionModel = "SERVICE_MANAGED"|"SELF_MANAGED",
  AutoDeployment = list(
    Enabled = TRUE|FALSE,
    RetainStacksOnAccountRemoval = TRUE|FALSE
  ),
  ClientRequestToken = "string"
)
}
}

\keyword{internal}
