% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_get_metric_data}
\alias{cloudwatch_get_metric_data}
\title{You can use the GetMetricData API to retrieve as many as 100 different
metrics in a single request, with a total of as many as 100,800
datapoints}
\usage{
cloudwatch_get_metric_data(MetricDataQueries, StartTime, EndTime,
  NextToken, ScanBy, MaxDatapoints)
}
\arguments{
\item{MetricDataQueries}{[required] The metric queries to be returned. A single \code{GetMetricData} call can
include as many as 100 \code{MetricDataQuery} structures. Each of these
structures can specify either a metric to retrieve, or a math expression
to perform on retrieved data.}

\item{StartTime}{[required] The time stamp indicating the earliest data to be returned.

For better performance, specify \code{StartTime} and \code{EndTime} values that
align with the value of the metric's \code{Period} and sync up with the
beginning and end of an hour. For example, if the \code{Period} of a metric
is 5 minutes, specifying 12:05 or 12:30 as \code{StartTime} can get a faster
response from CloudWatch than setting 12:07 or 12:29 as the \code{StartTime}.}

\item{EndTime}{[required] The time stamp indicating the latest data to be returned.

For better performance, specify \code{StartTime} and \code{EndTime} values that
align with the value of the metric's \code{Period} and sync up with the
beginning and end of an hour. For example, if the \code{Period} of a metric
is 5 minutes, specifying 12:05 or 12:30 as \code{EndTime} can get a faster
response from CloudWatch than setting 12:07 or 12:29 as the \code{EndTime}.}

\item{NextToken}{Include this value, if it was returned by the previous call, to get the
next set of data points.}

\item{ScanBy}{The order in which data points should be returned. \code{TimestampDescending}
returns the newest data first and paginates when the \code{MaxDatapoints}
limit is reached. \code{TimestampAscending} returns the oldest data first and
paginates when the \code{MaxDatapoints} limit is reached.}

\item{MaxDatapoints}{The maximum number of data points the request should return before
paginating. If you omit this, the default of 100,800 is used.}
}
\description{
You can use the \code{GetMetricData} API to retrieve as many as 100 different
metrics in a single request, with a total of as many as 100,800
datapoints. You can also optionally perform math expressions on the
values of the returned statistics, to create new time series that
represent new insights into your data. For example, using Lambda
metrics, you could divide the Errors metric by the Invocations metric to
get an error rate time series. For more information about metric math
expressions, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax}{Metric Math Syntax and Functions}
in the \emph{Amazon CloudWatch User Guide}.
}
\details{
Calls to the \code{GetMetricData} API have a different pricing structure than
calls to \code{GetMetricStatistics}. For more information about pricing, see
\href{https://aws.amazon.com/cloudwatch/pricing/}{Amazon CloudWatch Pricing}.

Amazon CloudWatch retains metric data as follows:
\itemize{
\item Data points with a period of less than 60 seconds are available for
3 hours. These data points are high-resolution metrics and are
available only for custom metrics that have been defined with a
\code{StorageResolution} of 1.
\item Data points with a period of 60 seconds (1-minute) are available for
15 days.
\item Data points with a period of 300 seconds (5-minute) are available
for 63 days.
\item Data points with a period of 3600 seconds (1 hour) are available for
455 days (15 months).
}

Data points that are initially published with a shorter period are
aggregated together for long-term storage. For example, if you collect
data using a period of 1 minute, the data remains available for 15 days
with 1-minute resolution. After 15 days, this data is still available,
but is aggregated and retrievable only with a resolution of 5 minutes.
After 63 days, the data is further aggregated and is available with a
resolution of 1 hour.
}
\section{Request syntax}{
\preformatted{svc$get_metric_data(
  MetricDataQueries = list(
    list(
      Id = "string",
      MetricStat = list(
        Metric = list(
          Namespace = "string",
          MetricName = "string",
          Dimensions = list(
            list(
              Name = "string",
              Value = "string"
            )
          )
        ),
        Period = 123,
        Stat = "string",
        Unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None"
      ),
      Expression = "string",
      Label = "string",
      ReturnData = TRUE|FALSE
    )
  ),
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  NextToken = "string",
  ScanBy = "TimestampDescending"|"TimestampAscending",
  MaxDatapoints = 123
)
}
}

\keyword{internal}
