# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include resourcegroupstaggingapi_service.R
NULL

#' Returns all the tagged resources that are associated with the specified
#' tags (keys and values) located in the specified region for the AWS
#' account
#'
#' Returns all the tagged resources that are associated with the specified
#' tags (keys and values) located in the specified region for the AWS
#' account. The tags and the resource types that you specify in the request
#' are known as *filters*. The response includes all tags that are
#' associated with the requested resources. If no filter is provided, this
#' action returns a paginated resource list with the associated tags.
#'
#' @usage
#' resourcegroupstaggingapi_get_resources(PaginationToken, TagFilters,
#'   ResourcesPerPage, TagsPerPage, ResourceTypeFilters)
#'
#' @param PaginationToken A string that indicates that additional data is available. Leave this
#' value empty for your initial request. If the response includes a
#' `PaginationToken`, use that string for this value to request an
#' additional page of data.
#' @param TagFilters A list of tags (keys and values). A request can include up to 50 keys,
#' and each key can include up to 20 values.
#' 
#' If you specify multiple filters connected by an AND operator in a single
#' request, the response returns only those resources that are associated
#' with every specified filter.
#' 
#' If you specify multiple filters connected by an OR operator in a single
#' request, the response returns all resources that are associated with at
#' least one or possibly more of the specified filters.
#' @param ResourcesPerPage A limit that restricts the number of resources returned by GetResources
#' in paginated output. You can set ResourcesPerPage to a minimum of 1 item
#' and the maximum of 50 items.
#' @param TagsPerPage A limit that restricts the number of tags (key and value pairs) returned
#' by GetResources in paginated output. A resource with no tags is counted
#' as having one tag (one key and value pair).
#' 
#' `GetResources` does not split a resource and its associated tags across
#' pages. If the specified `TagsPerPage` would cause such a break, a
#' `PaginationToken` is returned in place of the affected resource and its
#' tags. Use that token in another request to get the remaining data. For
#' example, if you specify a `TagsPerPage` of `100` and the account has 22
#' resources with 10 tags each (meaning that each resource has 10 key and
#' value pairs), the output will consist of 3 pages, with the first page
#' displaying the first 10 resources, each with its 10 tags, the second
#' page displaying the next 10 resources each with its 10 tags, and the
#' third page displaying the remaining 2 resources, each with its 10 tags.
#' 
#' You can set `TagsPerPage` to a minimum of 100 items and the maximum of
#' 500 items.
#' @param ResourceTypeFilters The constraints on the resources that you want returned. The format of
#' each resource type is `service\\[:resourceType\\]`. For example,
#' specifying a resource type of `ec2` returns all tagged Amazon EC2
#' resources (which includes tagged EC2 instances). Specifying a resource
#' type of `ec2:instance` returns only EC2 instances.
#' 
#' The string for each service name and resource type is the same as that
#' embedded in a resource\'s Amazon Resource Name (ARN). Consult the *AWS
#' General Reference* for the following:
#' 
#' -   For a list of service name strings, see [AWS Service
#'     Namespaces](http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces).
#' 
#' -   For resource type strings, see [Example
#'     ARNs](http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arns-syntax).
#' 
#' -   For more information about ARNs, see [Amazon Resource Names (ARNs)
#'     and AWS Service
#'     Namespaces](http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#'
#' @section Request syntax:
#' ```
#' svc$get_resources(
#'   PaginationToken = "string",
#'   TagFilters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ResourcesPerPage = 123,
#'   TagsPerPage = 123,
#'   ResourceTypeFilters = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroupstaggingapi_get_resources
resourcegroupstaggingapi_get_resources <- function(PaginationToken = NULL, TagFilters = NULL, ResourcesPerPage = NULL, TagsPerPage = NULL, ResourceTypeFilters = NULL) {
  op <- new_operation(
    name = "GetResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .resourcegroupstaggingapi$get_resources_input(PaginationToken = PaginationToken, TagFilters = TagFilters, ResourcesPerPage = ResourcesPerPage, TagsPerPage = TagsPerPage, ResourceTypeFilters = ResourceTypeFilters)
  output <- .resourcegroupstaggingapi$get_resources_output()
  svc <- .resourcegroupstaggingapi$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroupstaggingapi$operations$get_resources <- resourcegroupstaggingapi_get_resources

#' Returns all tag keys in the specified region for the AWS account
#'
#' Returns all tag keys in the specified region for the AWS account.
#'
#' @usage
#' resourcegroupstaggingapi_get_tag_keys(PaginationToken)
#'
#' @param PaginationToken A string that indicates that additional data is available. Leave this
#' value empty for your initial request. If the response includes a
#' PaginationToken, use that string for this value to request an additional
#' page of data.
#'
#' @section Request syntax:
#' ```
#' svc$get_tag_keys(
#'   PaginationToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroupstaggingapi_get_tag_keys
resourcegroupstaggingapi_get_tag_keys <- function(PaginationToken = NULL) {
  op <- new_operation(
    name = "GetTagKeys",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .resourcegroupstaggingapi$get_tag_keys_input(PaginationToken = PaginationToken)
  output <- .resourcegroupstaggingapi$get_tag_keys_output()
  svc <- .resourcegroupstaggingapi$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroupstaggingapi$operations$get_tag_keys <- resourcegroupstaggingapi_get_tag_keys

#' Returns all tag values for the specified key in the specified region for
#' the AWS account
#'
#' Returns all tag values for the specified key in the specified region for
#' the AWS account.
#'
#' @usage
#' resourcegroupstaggingapi_get_tag_values(PaginationToken, Key)
#'
#' @param PaginationToken A string that indicates that additional data is available. Leave this
#' value empty for your initial request. If the response includes a
#' PaginationToken, use that string for this value to request an additional
#' page of data.
#' @param Key &#91;required&#93; The key for which you want to list all existing values in the specified
#' region for the AWS account.
#'
#' @section Request syntax:
#' ```
#' svc$get_tag_values(
#'   PaginationToken = "string",
#'   Key = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroupstaggingapi_get_tag_values
resourcegroupstaggingapi_get_tag_values <- function(PaginationToken = NULL, Key) {
  op <- new_operation(
    name = "GetTagValues",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .resourcegroupstaggingapi$get_tag_values_input(PaginationToken = PaginationToken, Key = Key)
  output <- .resourcegroupstaggingapi$get_tag_values_output()
  svc <- .resourcegroupstaggingapi$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroupstaggingapi$operations$get_tag_values <- resourcegroupstaggingapi_get_tag_values

#' Applies one or more tags to the specified resources
#'
#' Applies one or more tags to the specified resources. Note the following:
#' 
#' -   Not all resources can have tags. For a list of resources that
#'     support tagging, see [Supported
#'     Resources](http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/supported-resources.html)
#'     in the *AWS Resource Groups and Tag Editor User Guide*.
#' 
#' -   Each resource can have up to 50 tags. For other limits, see [Tag
#'     Restrictions](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-restrictions)
#'     in the *Amazon EC2 User Guide for Linux Instances*.
#' 
#' -   You can only tag resources that are located in the specified region
#'     for the AWS account.
#' 
#' -   To add tags to a resource, you need the necessary permissions for
#'     the service that the resource belongs to as well as permissions for
#'     adding tags. For more information, see [Obtaining Permissions for
#'     Tagging](http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/obtaining-permissions-for-tagging.html)
#'     in the *AWS Resource Groups and Tag Editor User Guide*.
#'
#' @usage
#' resourcegroupstaggingapi_tag_resources(ResourceARNList, Tags)
#'
#' @param ResourceARNList &#91;required&#93; A list of ARNs. An ARN (Amazon Resource Name) uniquely identifies a
#' resource. You can specify a minimum of 1 and a maximum of 20 ARNs
#' (resources) to tag. An ARN can be set to a maximum of 1600 characters.
#' For more information, see [Amazon Resource Names (ARNs) and AWS Service
#' Namespaces](http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param Tags &#91;required&#93; The tags that you want to add to the specified resources. A tag consists
#' of a key and a value that you define.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resources(
#'   ResourceARNList = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroupstaggingapi_tag_resources
resourcegroupstaggingapi_tag_resources <- function(ResourceARNList, Tags) {
  op <- new_operation(
    name = "TagResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .resourcegroupstaggingapi$tag_resources_input(ResourceARNList = ResourceARNList, Tags = Tags)
  output <- .resourcegroupstaggingapi$tag_resources_output()
  svc <- .resourcegroupstaggingapi$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroupstaggingapi$operations$tag_resources <- resourcegroupstaggingapi_tag_resources

#' Removes the specified tags from the specified resources
#'
#' Removes the specified tags from the specified resources. When you
#' specify a tag key, the action removes both that key and its associated
#' value. The operation succeeds even if you attempt to remove tags from a
#' resource that were already removed. Note the following:
#' 
#' -   To remove tags from a resource, you need the necessary permissions
#'     for the service that the resource belongs to as well as permissions
#'     for removing tags. For more information, see [Obtaining Permissions
#'     for
#'     Tagging](http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/obtaining-permissions-for-tagging.html)
#'     in the *AWS Resource Groups and Tag Editor User Guide*.
#' 
#' -   You can only tag resources that are located in the specified region
#'     for the AWS account.
#'
#' @usage
#' resourcegroupstaggingapi_untag_resources(ResourceARNList, TagKeys)
#'
#' @param ResourceARNList &#91;required&#93; A list of ARNs. An ARN (Amazon Resource Name) uniquely identifies a
#' resource. You can specify a minimum of 1 and a maximum of 20 ARNs
#' (resources) to untag. An ARN can be set to a maximum of 1600 characters.
#' For more information, see [Amazon Resource Names (ARNs) and AWS Service
#' Namespaces](http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param TagKeys &#91;required&#93; A list of the tag keys that you want to remove from the specified
#' resources.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resources(
#'   ResourceARNList = list(
#'     "string"
#'   ),
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroupstaggingapi_untag_resources
resourcegroupstaggingapi_untag_resources <- function(ResourceARNList, TagKeys) {
  op <- new_operation(
    name = "UntagResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .resourcegroupstaggingapi$untag_resources_input(ResourceARNList = ResourceARNList, TagKeys = TagKeys)
  output <- .resourcegroupstaggingapi$untag_resources_output()
  svc <- .resourcegroupstaggingapi$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroupstaggingapi$operations$untag_resources <- resourcegroupstaggingapi_untag_resources
