% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_search_users_by_image}
\alias{rekognition_search_users_by_image}
\title{Searches for UserIDs using a supplied image}
\usage{
rekognition_search_users_by_image(
  CollectionId,
  Image,
  UserMatchThreshold = NULL,
  MaxUsers = NULL,
  QualityFilter = NULL
)
}
\arguments{
\item{CollectionId}{[required] The ID of an existing collection containing the UserID.}

\item{Image}{[required]}

\item{UserMatchThreshold}{Specifies the minimum confidence in the UserID match to return. Default
value is 80.}

\item{MaxUsers}{Maximum number of UserIDs to return.}

\item{QualityFilter}{A filter that specifies a quality bar for how much filtering is done to
identify faces. Filtered faces aren't searched for in the collection.
The default value is NONE.}
}
\description{
Searches for UserIDs using a supplied image. It first detects the largest face in the image, and then searches a specified collection for matching UserIDs.

See \url{https://www.paws-r-sdk.com/docs/rekognition_search_users_by_image/} for full documentation.
}
\keyword{internal}
