% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_list_recommenders}
\alias{personalize_list_recommenders}
\title{Returns a list of recommenders in a given Domain dataset group}
\usage{
personalize_list_recommenders(
  datasetGroupArn = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{datasetGroupArn}{The Amazon Resource Name (ARN) of the Domain dataset group to list the
recommenders for. When a Domain dataset group is not specified, all the
recommenders associated with the account are listed.}

\item{nextToken}{A token returned from the previous call to
\code{\link[=personalize_list_recommenders]{list_recommenders}} for getting the
next set of recommenders (if they exist).}

\item{maxResults}{The maximum number of recommenders to return.}
}
\description{
Returns a list of recommenders in a given Domain dataset group. When a Domain dataset group is not specified, all the recommenders associated with the account are listed. The response provides the properties for each recommender, including the Amazon Resource Name (ARN). For more information on recommenders, see \code{\link[=personalize_create_recommender]{create_recommender}}.

See \url{https://www.paws-r-sdk.com/docs/personalize_list_recommenders/} for full documentation.
}
\keyword{internal}
