% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_list_slot_types}
\alias{lexmodelsv2_list_slot_types}
\title{Gets a list of slot types that match the specified criteria}
\usage{
lexmodelsv2_list_slot_types(
  botId,
  botVersion,
  localeId,
  sortBy = NULL,
  filters = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{botId}{[required] The unique identifier of the bot that contains the slot types.}

\item{botVersion}{[required] The version of the bot that contains the slot type.}

\item{localeId}{[required] The identifier of the language and locale of the slot types to list. The
string must match one of the supported locales. For more information,
see \href{https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html}{Supported languages}.}

\item{sortBy}{Determines the sort order for the response from the
\code{\link[=lexmodelsv2_list_slot_types]{list_slot_types}} operation. You can
choose to sort by the slot type name or last updated date in either
ascending or descending order.}

\item{filters}{Provides the specification of a filter used to limit the slot types in
the response to only those that match the filter specification. You can
only specify one filter and only one string to filter on.}

\item{maxResults}{The maximum number of slot types to return in each page of results. If
there are fewer results than the max page size, only the actual number
of results are returned.}

\item{nextToken}{If the response from the
\code{\link[=lexmodelsv2_list_slot_types]{list_slot_types}} operation contains more
results than specified in the \code{maxResults} parameter, a token is
returned in the response. Use that token in the \code{nextToken} parameter to
return the next page of results.}
}
\description{
Gets a list of slot types that match the specified criteria.

See \url{https://www.paws-r-sdk.com/docs/lexmodelsv2_list_slot_types/} for full documentation.
}
\keyword{internal}
