% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastservice_operations.R
\name{forecastservice_create_what_if_analysis}
\alias{forecastservice_create_what_if_analysis}
\title{What-if analysis is a scenario modeling technique where you make a
hypothetical change to a time series and compare the forecasts generated
by these changes against the baseline, unchanged time series}
\usage{
forecastservice_create_what_if_analysis(
  WhatIfAnalysisName,
  ForecastArn,
  TimeSeriesSelector = NULL,
  Tags = NULL
)
}
\arguments{
\item{WhatIfAnalysisName}{[required] The name of the what-if analysis. Each name must be unique.}

\item{ForecastArn}{[required] The Amazon Resource Name (ARN) of the baseline forecast.}

\item{TimeSeriesSelector}{Defines the set of time series that are used in the what-if analysis
with a \code{TimeSeriesIdentifiers} object. What-if analyses are performed
only for the time series in this object.

The \code{TimeSeriesIdentifiers} object needs the following information:
\itemize{
\item \code{DataSource}
\item \code{Format}
\item \code{Schema}
}}

\item{Tags}{A list of
\href{https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html}{tags}
to apply to the what if forecast.}
}
\description{
What-if analysis is a scenario modeling technique where you make a hypothetical change to a time series and compare the forecasts generated by these changes against the baseline, unchanged time series. It is important to remember that the purpose of a what-if analysis is to understand how a forecast can change given different modifications to the baseline time series.

See \url{https://www.paws-r-sdk.com/docs/forecastservice_create_what_if_analysis/} for full documentation.
}
\keyword{internal}
