% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_list_custom_models}
\alias{bedrock_list_custom_models}
\title{Returns a list of the custom models that you have created with the
CreateModelCustomizationJob operation}
\usage{
bedrock_list_custom_models(
  creationTimeBefore = NULL,
  creationTimeAfter = NULL,
  nameContains = NULL,
  baseModelArnEquals = NULL,
  foundationModelArnEquals = NULL,
  maxResults = NULL,
  nextToken = NULL,
  sortBy = NULL,
  sortOrder = NULL
)
}
\arguments{
\item{creationTimeBefore}{Return custom models created before the specified time.}

\item{creationTimeAfter}{Return custom models created after the specified time.}

\item{nameContains}{Return custom models only if the job name contains these characters.}

\item{baseModelArnEquals}{Return custom models only if the base model Amazon Resource Name (ARN)
matches this parameter.}

\item{foundationModelArnEquals}{Return custom models only if the foundation model Amazon Resource Name
(ARN) matches this parameter.}

\item{maxResults}{Maximum number of results to return in the response.}

\item{nextToken}{Continuation token from the previous response, for Amazon Bedrock to
list the next set of results.}

\item{sortBy}{The field to sort by in the returned list of models.}

\item{sortOrder}{The sort order of the results.}
}
\description{
Returns a list of the custom models that you have created with the \code{\link[=bedrock_create_model_customization_job]{create_model_customization_job}} operation.

See \url{https://www.paws-r-sdk.com/docs/bedrock_list_custom_models/} for full documentation.
}
\keyword{internal}
