% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_create_guardrail_version}
\alias{bedrock_create_guardrail_version}
\title{Creates a version of the guardrail}
\usage{
bedrock_create_guardrail_version(
  guardrailIdentifier,
  description = NULL,
  clientRequestToken = NULL
)
}
\arguments{
\item{guardrailIdentifier}{[required] The unique identifier of the guardrail.}

\item{description}{A description of the guardrail version.}

\item{clientRequestToken}{A unique, case-sensitive identifier to ensure that the API request
completes no more than once. If this token matches a previous request,
Amazon Bedrock ignores the request, but does not return an error. For
more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}
in the \emph{Amazon S3 User Guide}.}
}
\description{
Creates a version of the guardrail. Use this API to create a snapshot of the guardrail when you are satisfied with a configuration, or to compare the configuration with another version.

See \url{https://www.paws-r-sdk.com/docs/bedrock_create_guardrail_version/} for full documentation.
}
\keyword{internal}
