% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_code_repositories}
\alias{sagemaker_list_code_repositories}
\title{Gets a list of the Git repositories in your account}
\usage{
sagemaker_list_code_repositories(
  CreationTimeAfter = NULL,
  CreationTimeBefore = NULL,
  LastModifiedTimeAfter = NULL,
  LastModifiedTimeBefore = NULL,
  MaxResults = NULL,
  NameContains = NULL,
  NextToken = NULL,
  SortBy = NULL,
  SortOrder = NULL
)
}
\arguments{
\item{CreationTimeAfter}{A filter that returns only Git repositories that were created after the
specified time.}

\item{CreationTimeBefore}{A filter that returns only Git repositories that were created before the
specified time.}

\item{LastModifiedTimeAfter}{A filter that returns only Git repositories that were last modified
after the specified time.}

\item{LastModifiedTimeBefore}{A filter that returns only Git repositories that were last modified
before the specified time.}

\item{MaxResults}{The maximum number of Git repositories to return in the response.}

\item{NameContains}{A string in the Git repositories name. This filter returns only
repositories whose name contains the specified string.}

\item{NextToken}{If the result of a \code{ListCodeRepositoriesOutput} request was truncated,
the response includes a \code{NextToken}. To get the next set of Git
repositories, use the token in the next request.}

\item{SortBy}{The field to sort results by. The default is \code{Name}.}

\item{SortOrder}{The sort order for results. The default is \code{Ascending}.}
}
\description{
Gets a list of the Git repositories in your account.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_code_repositories/} for full documentation.
}
\keyword{internal}
