% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_presigned_domain_url}
\alias{sagemaker_create_presigned_domain_url}
\title{Creates a URL for a specified UserProfile in a Domain}
\usage{
sagemaker_create_presigned_domain_url(
  DomainId,
  UserProfileName,
  SessionExpirationDurationInSeconds = NULL,
  ExpiresInSeconds = NULL,
  SpaceName = NULL,
  LandingUri = NULL
)
}
\arguments{
\item{DomainId}{[required] The domain ID.}

\item{UserProfileName}{[required] The name of the UserProfile to sign-in as.}

\item{SessionExpirationDurationInSeconds}{The session expiration duration in seconds. This value defaults to
43200.}

\item{ExpiresInSeconds}{The number of seconds until the pre-signed URL expires. This value
defaults to 300.}

\item{SpaceName}{The name of the space.}

\item{LandingUri}{The landing page that the user is directed to when accessing the
presigned URL. Using this value, users can access Studio or Studio
Classic, even if it is not the default experience for the domain. The
supported values are:
\itemize{
\item \code{studio::relative/path}: Directs users to the relative path in
Studio.
\item \code{app:JupyterServer:relative/path}: Directs users to the relative
path in the Studio Classic application.
\item \code{app:JupyterLab:relative/path}: Directs users to the relative path
in the JupyterLab application.
\item \code{app:RStudioServerPro:relative/path}: Directs users to the relative
path in the RStudio application.
\item \code{app:CodeEditor:relative/path}: Directs users to the relative path
in the Code Editor, based on Code-OSS, Visual Studio Code - Open
Source application.
\item \code{app:Canvas:relative/path}: Directs users to the relative path in
the Canvas application.
}}
}
\description{
Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be automatically signed in to the domain, and granted access to all of the Apps and files associated with the Domain's Amazon Elastic File System (EFS) volume. This operation can only be called when the authentication mode equals IAM.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_presigned_domain_url/} for full documentation.
}
\keyword{internal}
