# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include bedrock_service.R
NULL

#' Creates a fine-tuning job to customize a base model
#'
#' @description
#' Creates a fine-tuning job to customize a base model.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_create_model_customization_job/](https://www.paws-r-sdk.com/docs/bedrock_create_model_customization_job/) for full documentation.
#'
#' @param jobName &#91;required&#93; Enter a unique name for the fine-tuning job.
#' @param customModelName &#91;required&#93; Enter a name for the custom model.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that Amazon Bedrock can
#' assume to perform tasks on your behalf. For example, during model
#' training, Amazon Bedrock needs your permission to read input data from
#' an S3 bucket, write model artifacts to an S3 bucket. To pass this role
#' to Amazon Bedrock, the caller of this API must have the `iam:PassRole`
#' permission.
#' @param clientRequestToken Unique token value that you can provide. The GetModelCustomizationJob
#' response includes the same token value.
#' @param baseModelIdentifier &#91;required&#93; Name of the base model.
#' @param customizationType The customization type.
#' @param customModelKmsKeyId The custom model is encrypted at rest using this key.
#' @param jobTags Assign tags to the job.
#' @param customModelTags Assign tags to the custom model.
#' @param trainingDataConfig &#91;required&#93; Information about the training dataset.
#' @param validationDataConfig Information about the validation dataset.
#' @param outputDataConfig &#91;required&#93; S3 location for the output data.
#' @param hyperParameters &#91;required&#93; Parameters related to tuning the model.
#' @param vpcConfig VPC configuration (optional). Configuration parameters for the private
#' Virtual Private Cloud (VPC) that contains the resources you are using
#' for this job.
#'
#' @keywords internal
#'
#' @rdname bedrock_create_model_customization_job
bedrock_create_model_customization_job <- function(jobName, customModelName, roleArn, clientRequestToken = NULL, baseModelIdentifier, customizationType = NULL, customModelKmsKeyId = NULL, jobTags = NULL, customModelTags = NULL, trainingDataConfig, validationDataConfig = NULL, outputDataConfig, hyperParameters, vpcConfig = NULL) {
  op <- new_operation(
    name = "CreateModelCustomizationJob",
    http_method = "POST",
    http_path = "/model-customization-jobs",
    paginator = list()
  )
  input <- .bedrock$create_model_customization_job_input(jobName = jobName, customModelName = customModelName, roleArn = roleArn, clientRequestToken = clientRequestToken, baseModelIdentifier = baseModelIdentifier, customizationType = customizationType, customModelKmsKeyId = customModelKmsKeyId, jobTags = jobTags, customModelTags = customModelTags, trainingDataConfig = trainingDataConfig, validationDataConfig = validationDataConfig, outputDataConfig = outputDataConfig, hyperParameters = hyperParameters, vpcConfig = vpcConfig)
  output <- .bedrock$create_model_customization_job_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$create_model_customization_job <- bedrock_create_model_customization_job

#' Creates a provisioned throughput with dedicated capacity for a
#' foundation model or a fine-tuned model
#'
#' @description
#' Creates a provisioned throughput with dedicated capacity for a foundation model or a fine-tuned model.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_create_provisioned_model_throughput/](https://www.paws-r-sdk.com/docs/bedrock_create_provisioned_model_throughput/) for full documentation.
#'
#' @param clientRequestToken Unique token value that you can provide. If this token matches a
#' previous request, Amazon Bedrock ignores the request, but does not
#' return an error.
#' @param modelUnits &#91;required&#93; Number of model units to allocate.
#' @param provisionedModelName &#91;required&#93; Unique name for this provisioned throughput.
#' @param modelId &#91;required&#93; Name or ARN of the model to associate with this provisioned throughput.
#' @param commitmentDuration Commitment duration requested for the provisioned throughput.
#' @param tags Tags to associate with this provisioned throughput.
#'
#' @keywords internal
#'
#' @rdname bedrock_create_provisioned_model_throughput
bedrock_create_provisioned_model_throughput <- function(clientRequestToken = NULL, modelUnits, provisionedModelName, modelId, commitmentDuration = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateProvisionedModelThroughput",
    http_method = "POST",
    http_path = "/provisioned-model-throughput",
    paginator = list()
  )
  input <- .bedrock$create_provisioned_model_throughput_input(clientRequestToken = clientRequestToken, modelUnits = modelUnits, provisionedModelName = provisionedModelName, modelId = modelId, commitmentDuration = commitmentDuration, tags = tags)
  output <- .bedrock$create_provisioned_model_throughput_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$create_provisioned_model_throughput <- bedrock_create_provisioned_model_throughput

#' Deletes a custom model that you created earlier
#'
#' @description
#' Deletes a custom model that you created earlier. For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_delete_custom_model/](https://www.paws-r-sdk.com/docs/bedrock_delete_custom_model/) for full documentation.
#'
#' @param modelIdentifier &#91;required&#93; Name of the model to delete.
#'
#' @keywords internal
#'
#' @rdname bedrock_delete_custom_model
bedrock_delete_custom_model <- function(modelIdentifier) {
  op <- new_operation(
    name = "DeleteCustomModel",
    http_method = "DELETE",
    http_path = "/custom-models/{modelIdentifier}",
    paginator = list()
  )
  input <- .bedrock$delete_custom_model_input(modelIdentifier = modelIdentifier)
  output <- .bedrock$delete_custom_model_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$delete_custom_model <- bedrock_delete_custom_model

#' Delete the invocation logging
#'
#' @description
#' Delete the invocation logging.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_delete_model_invocation_logging_configuration/](https://www.paws-r-sdk.com/docs/bedrock_delete_model_invocation_logging_configuration/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname bedrock_delete_model_invocation_logging_configuration
bedrock_delete_model_invocation_logging_configuration <- function() {
  op <- new_operation(
    name = "DeleteModelInvocationLoggingConfiguration",
    http_method = "DELETE",
    http_path = "/logging/modelinvocations",
    paginator = list()
  )
  input <- .bedrock$delete_model_invocation_logging_configuration_input()
  output <- .bedrock$delete_model_invocation_logging_configuration_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$delete_model_invocation_logging_configuration <- bedrock_delete_model_invocation_logging_configuration

#' Deletes a provisioned throughput
#'
#' @description
#' Deletes a provisioned throughput. For more information, see [Provisioned throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html) in the Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_delete_provisioned_model_throughput/](https://www.paws-r-sdk.com/docs/bedrock_delete_provisioned_model_throughput/) for full documentation.
#'
#' @param provisionedModelId &#91;required&#93; The ARN or name of the provisioned throughput.
#'
#' @keywords internal
#'
#' @rdname bedrock_delete_provisioned_model_throughput
bedrock_delete_provisioned_model_throughput <- function(provisionedModelId) {
  op <- new_operation(
    name = "DeleteProvisionedModelThroughput",
    http_method = "DELETE",
    http_path = "/provisioned-model-throughput/{provisionedModelId}",
    paginator = list()
  )
  input <- .bedrock$delete_provisioned_model_throughput_input(provisionedModelId = provisionedModelId)
  output <- .bedrock$delete_provisioned_model_throughput_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$delete_provisioned_model_throughput <- bedrock_delete_provisioned_model_throughput

#' Get the properties associated with a Amazon Bedrock custom model that
#' you have created
#'
#' @description
#' Get the properties associated with a Amazon Bedrock custom model that you have created.For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_custom_model/](https://www.paws-r-sdk.com/docs/bedrock_get_custom_model/) for full documentation.
#'
#' @param modelIdentifier &#91;required&#93; Name or ARN of the custom model.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_custom_model
bedrock_get_custom_model <- function(modelIdentifier) {
  op <- new_operation(
    name = "GetCustomModel",
    http_method = "GET",
    http_path = "/custom-models/{modelIdentifier}",
    paginator = list()
  )
  input <- .bedrock$get_custom_model_input(modelIdentifier = modelIdentifier)
  output <- .bedrock$get_custom_model_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_custom_model <- bedrock_get_custom_model

#' Get details about a Amazon Bedrock foundation model
#'
#' @description
#' Get details about a Amazon Bedrock foundation model.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_foundation_model/](https://www.paws-r-sdk.com/docs/bedrock_get_foundation_model/) for full documentation.
#'
#' @param modelIdentifier &#91;required&#93; The model identifier.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_foundation_model
bedrock_get_foundation_model <- function(modelIdentifier) {
  op <- new_operation(
    name = "GetFoundationModel",
    http_method = "GET",
    http_path = "/foundation-models/{modelIdentifier}",
    paginator = list()
  )
  input <- .bedrock$get_foundation_model_input(modelIdentifier = modelIdentifier)
  output <- .bedrock$get_foundation_model_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_foundation_model <- bedrock_get_foundation_model

#' Retrieves the properties associated with a model-customization job,
#' including the status of the job
#'
#' @description
#' Retrieves the properties associated with a model-customization job, including the status of the job. For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_model_customization_job/](https://www.paws-r-sdk.com/docs/bedrock_get_model_customization_job/) for full documentation.
#'
#' @param jobIdentifier &#91;required&#93; Identifier for the customization job.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_model_customization_job
bedrock_get_model_customization_job <- function(jobIdentifier) {
  op <- new_operation(
    name = "GetModelCustomizationJob",
    http_method = "GET",
    http_path = "/model-customization-jobs/{jobIdentifier}",
    paginator = list()
  )
  input <- .bedrock$get_model_customization_job_input(jobIdentifier = jobIdentifier)
  output <- .bedrock$get_model_customization_job_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_model_customization_job <- bedrock_get_model_customization_job

#' Get the current configuration values for model invocation logging
#'
#' @description
#' Get the current configuration values for model invocation logging.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_model_invocation_logging_configuration/](https://www.paws-r-sdk.com/docs/bedrock_get_model_invocation_logging_configuration/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_model_invocation_logging_configuration
bedrock_get_model_invocation_logging_configuration <- function() {
  op <- new_operation(
    name = "GetModelInvocationLoggingConfiguration",
    http_method = "GET",
    http_path = "/logging/modelinvocations",
    paginator = list()
  )
  input <- .bedrock$get_model_invocation_logging_configuration_input()
  output <- .bedrock$get_model_invocation_logging_configuration_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_model_invocation_logging_configuration <- bedrock_get_model_invocation_logging_configuration

#' Get details for a provisioned throughput
#'
#' @description
#' Get details for a provisioned throughput. For more information, see [Provisioned throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html) in the Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_provisioned_model_throughput/](https://www.paws-r-sdk.com/docs/bedrock_get_provisioned_model_throughput/) for full documentation.
#'
#' @param provisionedModelId &#91;required&#93; The ARN or name of the provisioned throughput.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_provisioned_model_throughput
bedrock_get_provisioned_model_throughput <- function(provisionedModelId) {
  op <- new_operation(
    name = "GetProvisionedModelThroughput",
    http_method = "GET",
    http_path = "/provisioned-model-throughput/{provisionedModelId}",
    paginator = list()
  )
  input <- .bedrock$get_provisioned_model_throughput_input(provisionedModelId = provisionedModelId)
  output <- .bedrock$get_provisioned_model_throughput_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_provisioned_model_throughput <- bedrock_get_provisioned_model_throughput

#' Returns a list of the custom models that you have created with the
#' CreateModelCustomizationJob operation
#'
#' @description
#' Returns a list of the custom models that you have created with the [`create_model_customization_job`][bedrock_create_model_customization_job] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_custom_models/](https://www.paws-r-sdk.com/docs/bedrock_list_custom_models/) for full documentation.
#'
#' @param creationTimeBefore Return custom models created before the specified time.
#' @param creationTimeAfter Return custom models created after the specified time.
#' @param nameContains Return custom models only if the job name contains these characters.
#' @param baseModelArnEquals Return custom models only if the base model ARN matches this parameter.
#' @param foundationModelArnEquals Return custom models only if the foundation model ARN matches this
#' parameter.
#' @param maxResults Maximum number of results to return in the response.
#' @param nextToken Continuation token from the previous response, for Amazon Bedrock to
#' list the next set of results.
#' @param sortBy The field to sort by in the returned list of models.
#' @param sortOrder The sort order of the results.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_custom_models
bedrock_list_custom_models <- function(creationTimeBefore = NULL, creationTimeAfter = NULL, nameContains = NULL, baseModelArnEquals = NULL, foundationModelArnEquals = NULL, maxResults = NULL, nextToken = NULL, sortBy = NULL, sortOrder = NULL) {
  op <- new_operation(
    name = "ListCustomModels",
    http_method = "GET",
    http_path = "/custom-models",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "modelSummaries")
  )
  input <- .bedrock$list_custom_models_input(creationTimeBefore = creationTimeBefore, creationTimeAfter = creationTimeAfter, nameContains = nameContains, baseModelArnEquals = baseModelArnEquals, foundationModelArnEquals = foundationModelArnEquals, maxResults = maxResults, nextToken = nextToken, sortBy = sortBy, sortOrder = sortOrder)
  output <- .bedrock$list_custom_models_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_custom_models <- bedrock_list_custom_models

#' List of Amazon Bedrock foundation models that you can use
#'
#' @description
#' List of Amazon Bedrock foundation models that you can use. For more information, see [Foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/) in the Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_foundation_models/](https://www.paws-r-sdk.com/docs/bedrock_list_foundation_models/) for full documentation.
#'
#' @param byProvider A Amazon Bedrock model provider.
#' @param byCustomizationType List by customization type.
#' @param byOutputModality List by output modality type.
#' @param byInferenceType List by inference type.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_foundation_models
bedrock_list_foundation_models <- function(byProvider = NULL, byCustomizationType = NULL, byOutputModality = NULL, byInferenceType = NULL) {
  op <- new_operation(
    name = "ListFoundationModels",
    http_method = "GET",
    http_path = "/foundation-models",
    paginator = list()
  )
  input <- .bedrock$list_foundation_models_input(byProvider = byProvider, byCustomizationType = byCustomizationType, byOutputModality = byOutputModality, byInferenceType = byInferenceType)
  output <- .bedrock$list_foundation_models_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_foundation_models <- bedrock_list_foundation_models

#' Returns a list of model customization jobs that you have submitted
#'
#' @description
#' Returns a list of model customization jobs that you have submitted. You can filter the jobs to return based on one or more criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_model_customization_jobs/](https://www.paws-r-sdk.com/docs/bedrock_list_model_customization_jobs/) for full documentation.
#'
#' @param creationTimeAfter Return customization jobs created after the specified time.
#' @param creationTimeBefore Return customization jobs created before the specified time.
#' @param statusEquals Return customization jobs with the specified status.
#' @param nameContains Return customization jobs only if the job name contains these
#' characters.
#' @param maxResults Maximum number of results to return in the response.
#' @param nextToken Continuation token from the previous response, for Amazon Bedrock to
#' list the next set of results.
#' @param sortBy The field to sort by in the returned list of jobs.
#' @param sortOrder The sort order of the results.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_model_customization_jobs
bedrock_list_model_customization_jobs <- function(creationTimeAfter = NULL, creationTimeBefore = NULL, statusEquals = NULL, nameContains = NULL, maxResults = NULL, nextToken = NULL, sortBy = NULL, sortOrder = NULL) {
  op <- new_operation(
    name = "ListModelCustomizationJobs",
    http_method = "GET",
    http_path = "/model-customization-jobs",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "modelCustomizationJobSummaries")
  )
  input <- .bedrock$list_model_customization_jobs_input(creationTimeAfter = creationTimeAfter, creationTimeBefore = creationTimeBefore, statusEquals = statusEquals, nameContains = nameContains, maxResults = maxResults, nextToken = nextToken, sortBy = sortBy, sortOrder = sortOrder)
  output <- .bedrock$list_model_customization_jobs_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_model_customization_jobs <- bedrock_list_model_customization_jobs

#' List the provisioned capacities
#'
#' @description
#' List the provisioned capacities. For more information, see [Provisioned throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html) in the Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_provisioned_model_throughputs/](https://www.paws-r-sdk.com/docs/bedrock_list_provisioned_model_throughputs/) for full documentation.
#'
#' @param creationTimeAfter Return provisioned capacities created after the specified time.
#' @param creationTimeBefore Return provisioned capacities created before the specified time.
#' @param statusEquals Return the list of provisioned capacities that match the specified
#' status.
#' @param modelArnEquals Return the list of provisioned capacities where their model ARN is equal
#' to this parameter.
#' @param nameContains Return the list of provisioned capacities if their name contains these
#' characters.
#' @param maxResults THe maximum number of results to return in the response.
#' @param nextToken Continuation token from the previous response, for Amazon Bedrock to
#' list the next set of results.
#' @param sortBy The field to sort by in the returned list of provisioned capacities.
#' @param sortOrder The sort order of the results.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_provisioned_model_throughputs
bedrock_list_provisioned_model_throughputs <- function(creationTimeAfter = NULL, creationTimeBefore = NULL, statusEquals = NULL, modelArnEquals = NULL, nameContains = NULL, maxResults = NULL, nextToken = NULL, sortBy = NULL, sortOrder = NULL) {
  op <- new_operation(
    name = "ListProvisionedModelThroughputs",
    http_method = "GET",
    http_path = "/provisioned-model-throughputs",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "provisionedModelSummaries")
  )
  input <- .bedrock$list_provisioned_model_throughputs_input(creationTimeAfter = creationTimeAfter, creationTimeBefore = creationTimeBefore, statusEquals = statusEquals, modelArnEquals = modelArnEquals, nameContains = nameContains, maxResults = maxResults, nextToken = nextToken, sortBy = sortBy, sortOrder = sortOrder)
  output <- .bedrock$list_provisioned_model_throughputs_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_provisioned_model_throughputs <- bedrock_list_provisioned_model_throughputs

#' List the tags associated with the specified resource
#'
#' @description
#' List the tags associated with the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/bedrock_list_tags_for_resource/) for full documentation.
#'
#' @param resourceARN &#91;required&#93; The ARN of the resource.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_tags_for_resource
bedrock_list_tags_for_resource <- function(resourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/listTagsForResource",
    paginator = list()
  )
  input <- .bedrock$list_tags_for_resource_input(resourceARN = resourceARN)
  output <- .bedrock$list_tags_for_resource_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_tags_for_resource <- bedrock_list_tags_for_resource

#' Set the configuration values for model invocation logging
#'
#' @description
#' Set the configuration values for model invocation logging.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_put_model_invocation_logging_configuration/](https://www.paws-r-sdk.com/docs/bedrock_put_model_invocation_logging_configuration/) for full documentation.
#'
#' @param loggingConfig &#91;required&#93; The logging configuration values to set.
#'
#' @keywords internal
#'
#' @rdname bedrock_put_model_invocation_logging_configuration
bedrock_put_model_invocation_logging_configuration <- function(loggingConfig) {
  op <- new_operation(
    name = "PutModelInvocationLoggingConfiguration",
    http_method = "PUT",
    http_path = "/logging/modelinvocations",
    paginator = list()
  )
  input <- .bedrock$put_model_invocation_logging_configuration_input(loggingConfig = loggingConfig)
  output <- .bedrock$put_model_invocation_logging_configuration_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$put_model_invocation_logging_configuration <- bedrock_put_model_invocation_logging_configuration

#' Stops an active model customization job
#'
#' @description
#' Stops an active model customization job. For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_stop_model_customization_job/](https://www.paws-r-sdk.com/docs/bedrock_stop_model_customization_job/) for full documentation.
#'
#' @param jobIdentifier &#91;required&#93; Job identifier of the job to stop.
#'
#' @keywords internal
#'
#' @rdname bedrock_stop_model_customization_job
bedrock_stop_model_customization_job <- function(jobIdentifier) {
  op <- new_operation(
    name = "StopModelCustomizationJob",
    http_method = "POST",
    http_path = "/model-customization-jobs/{jobIdentifier}/stop",
    paginator = list()
  )
  input <- .bedrock$stop_model_customization_job_input(jobIdentifier = jobIdentifier)
  output <- .bedrock$stop_model_customization_job_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$stop_model_customization_job <- bedrock_stop_model_customization_job

#' Associate tags with a resource
#'
#' @description
#' Associate tags with a resource. For more information, see [Tagging resources](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html) in the Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_tag_resource/](https://www.paws-r-sdk.com/docs/bedrock_tag_resource/) for full documentation.
#'
#' @param resourceARN &#91;required&#93; The ARN of the resource to tag.
#' @param tags &#91;required&#93; Tags to associate with the resource.
#'
#' @keywords internal
#'
#' @rdname bedrock_tag_resource
bedrock_tag_resource <- function(resourceARN, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tagResource",
    paginator = list()
  )
  input <- .bedrock$tag_resource_input(resourceARN = resourceARN, tags = tags)
  output <- .bedrock$tag_resource_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$tag_resource <- bedrock_tag_resource

#' Remove one or more tags from a resource
#'
#' @description
#' Remove one or more tags from a resource. For more information, see [Tagging resources](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html) in the Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_untag_resource/](https://www.paws-r-sdk.com/docs/bedrock_untag_resource/) for full documentation.
#'
#' @param resourceARN &#91;required&#93; The ARN of the resource to untag.
#' @param tagKeys &#91;required&#93; Tag keys of the tags to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname bedrock_untag_resource
bedrock_untag_resource <- function(resourceARN, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/untagResource",
    paginator = list()
  )
  input <- .bedrock$untag_resource_input(resourceARN = resourceARN, tagKeys = tagKeys)
  output <- .bedrock$untag_resource_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$untag_resource <- bedrock_untag_resource

#' Update a provisioned throughput
#'
#' @description
#' Update a provisioned throughput. For more information, see [Provisioned throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html) in the Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_update_provisioned_model_throughput/](https://www.paws-r-sdk.com/docs/bedrock_update_provisioned_model_throughput/) for full documentation.
#'
#' @param provisionedModelId &#91;required&#93; The ARN or name of the provisioned throughput to update.
#' @param desiredProvisionedModelName The new name for this provisioned throughput.
#' @param desiredModelId The ARN of the new model to associate with this provisioned throughput.
#'
#' @keywords internal
#'
#' @rdname bedrock_update_provisioned_model_throughput
bedrock_update_provisioned_model_throughput <- function(provisionedModelId, desiredProvisionedModelName = NULL, desiredModelId = NULL) {
  op <- new_operation(
    name = "UpdateProvisionedModelThroughput",
    http_method = "PATCH",
    http_path = "/provisioned-model-throughput/{provisionedModelId}",
    paginator = list()
  )
  input <- .bedrock$update_provisioned_model_throughput_input(provisionedModelId = provisionedModelId, desiredProvisionedModelName = desiredProvisionedModelName, desiredModelId = desiredModelId)
  output <- .bedrock$update_provisioned_model_throughput_output()
  config <- get_config()
  svc <- .bedrock$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$update_provisioned_model_throughput <- bedrock_update_provisioned_model_throughput
