% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_create_slot_type_version}
\alias{lexmodelbuildingservice_create_slot_type_version}
\title{Creates a new version of a slot type based on the $LATEST version of the
specified slot type}
\usage{
lexmodelbuildingservice_create_slot_type_version(name, checksum = NULL)
}
\arguments{
\item{name}{[required] The name of the slot type that you want to create a new version for. The
name is case sensitive.}

\item{checksum}{Checksum for the \verb{$LATEST} version of the slot type that you want to
publish. If you specify a checksum and the \verb{$LATEST} version of the slot
type has a different checksum, Amazon Lex returns a
\code{PreconditionFailedException} exception and doesn't publish the new
version. If you don't specify a checksum, Amazon Lex publishes the
\verb{$LATEST} version.}
}
\description{
Creates a new version of a slot type based on the \verb{$LATEST} version of the specified slot type. If the \verb{$LATEST} version of this resource has not changed since the last version that you created, Amazon Lex doesn't create a new version. It returns the last version that you created.

See \url{https://www.paws-r-sdk.com/docs/lexmodelbuildingservice_create_slot_type_version/} for full documentation.
}
\keyword{internal}
