# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include lookoutequipment_service.R
NULL

#' Creates a container for a collection of data being ingested for analysis
#'
#' @description
#' Creates a container for a collection of data being ingested for analysis. The dataset contains the metadata describing where the data is and what the data actually looks like. In other words, it contains the location of the data source, the data schema, and other information. A dataset also contains any tags associated with the ingested data.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_create_dataset/](https://www.paws-r-sdk.com/docs/lookoutequipment_create_dataset/) for full documentation.
#'
#' @param DatasetName &#91;required&#93; The name of the dataset being created.
#' @param DatasetSchema A JSON description of the data that is in each time series dataset,
#' including names, column names, and data types.
#' @param ServerSideKmsKeyId Provides the identifier of the KMS key used to encrypt dataset data by
#' Amazon Lookout for Equipment.
#' @param ClientToken &#91;required&#93; A unique identifier for the request. If you do not set the client
#' request token, Amazon Lookout for Equipment generates one.
#' @param Tags Any tags associated with the ingested data described in the dataset.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_create_dataset
lookoutequipment_create_dataset <- function(DatasetName, DatasetSchema = NULL, ServerSideKmsKeyId = NULL, ClientToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateDataset",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$create_dataset_input(DatasetName = DatasetName, DatasetSchema = DatasetSchema, ServerSideKmsKeyId = ServerSideKmsKeyId, ClientToken = ClientToken, Tags = Tags)
  output <- .lookoutequipment$create_dataset_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$create_dataset <- lookoutequipment_create_dataset

#' Creates a scheduled inference
#'
#' @description
#' Creates a scheduled inference. Scheduling an inference is setting up a continuous real-time inference plan to analyze new measurement data. When setting up the schedule, you provide an S3 bucket location for the input data, assign it a delimiter between separate entries in the data, set an offset delay if desired, and set the frequency of inferencing. You must also provide an S3 bucket location for the output data.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_create_inference_scheduler/](https://www.paws-r-sdk.com/docs/lookoutequipment_create_inference_scheduler/) for full documentation.
#'
#' @param ModelName &#91;required&#93; The name of the previously trained ML model being used to create the
#' inference scheduler.
#' @param InferenceSchedulerName &#91;required&#93; The name of the inference scheduler being created.
#' @param DataDelayOffsetInMinutes The interval (in minutes) of planned delay at the start of each
#' inference segment. For example, if inference is set to run every ten
#' minutes, the delay is set to five minutes and the time is 09:08. The
#' inference scheduler will wake up at the configured interval (which,
#' without a delay configured, would be 09:10) plus the additional five
#' minute delay time (so 09:15) to check your Amazon S3 bucket. The delay
#' provides a buffer for you to upload data at the same frequency, so that
#' you don't have to stop and restart the scheduler when uploading new
#' data.
#' 
#' For more information, see [Understanding the inference
#' process](https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-inference-process.html).
#' @param DataUploadFrequency &#91;required&#93; How often data is uploaded to the source Amazon S3 bucket for the input
#' data. The value chosen is the length of time between data uploads. For
#' instance, if you select 5 minutes, Amazon Lookout for Equipment will
#' upload the real-time data to the source bucket once every 5 minutes.
#' This frequency also determines how often Amazon Lookout for Equipment
#' runs inference on your data.
#' 
#' For more information, see [Understanding the inference
#' process](https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-inference-process.html).
#' @param DataInputConfiguration &#91;required&#93; Specifies configuration information for the input data for the inference
#' scheduler, including delimiter, format, and dataset location.
#' @param DataOutputConfiguration &#91;required&#93; Specifies configuration information for the output results for the
#' inference scheduler, including the S3 location for the output.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of a role with permission to access the
#' data source being used for the inference.
#' @param ServerSideKmsKeyId Provides the identifier of the KMS key used to encrypt inference
#' scheduler data by Amazon Lookout for Equipment.
#' @param ClientToken &#91;required&#93; A unique identifier for the request. If you do not set the client
#' request token, Amazon Lookout for Equipment generates one.
#' @param Tags Any tags associated with the inference scheduler.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_create_inference_scheduler
lookoutequipment_create_inference_scheduler <- function(ModelName, InferenceSchedulerName, DataDelayOffsetInMinutes = NULL, DataUploadFrequency, DataInputConfiguration, DataOutputConfiguration, RoleArn, ServerSideKmsKeyId = NULL, ClientToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateInferenceScheduler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$create_inference_scheduler_input(ModelName = ModelName, InferenceSchedulerName = InferenceSchedulerName, DataDelayOffsetInMinutes = DataDelayOffsetInMinutes, DataUploadFrequency = DataUploadFrequency, DataInputConfiguration = DataInputConfiguration, DataOutputConfiguration = DataOutputConfiguration, RoleArn = RoleArn, ServerSideKmsKeyId = ServerSideKmsKeyId, ClientToken = ClientToken, Tags = Tags)
  output <- .lookoutequipment$create_inference_scheduler_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$create_inference_scheduler <- lookoutequipment_create_inference_scheduler

#' Creates a label for an event
#'
#' @description
#' Creates a label for an event.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_create_label/](https://www.paws-r-sdk.com/docs/lookoutequipment_create_label/) for full documentation.
#'
#' @param LabelGroupName &#91;required&#93; The name of a group of labels.
#' 
#' Data in this field will be retained for service usage. Follow best
#' practices for the security of your data.
#' @param StartTime &#91;required&#93; The start time of the labeled event.
#' @param EndTime &#91;required&#93; The end time of the labeled event.
#' @param Rating &#91;required&#93; Indicates whether a labeled event represents an anomaly.
#' @param FaultCode Provides additional information about the label. The fault code must be
#' defined in the FaultCodes attribute of the label group.
#' 
#' Data in this field will be retained for service usage. Follow best
#' practices for the security of your data.
#' @param Notes Metadata providing additional information about the label.
#' 
#' Data in this field will be retained for service usage. Follow best
#' practices for the security of your data.
#' @param Equipment Indicates that a label pertains to a particular piece of equipment.
#' 
#' Data in this field will be retained for service usage. Follow best
#' practices for the security of your data.
#' @param ClientToken &#91;required&#93; A unique identifier for the request to create a label. If you do not set
#' the client request token, Lookout for Equipment generates one.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_create_label
lookoutequipment_create_label <- function(LabelGroupName, StartTime, EndTime, Rating, FaultCode = NULL, Notes = NULL, Equipment = NULL, ClientToken) {
  op <- new_operation(
    name = "CreateLabel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$create_label_input(LabelGroupName = LabelGroupName, StartTime = StartTime, EndTime = EndTime, Rating = Rating, FaultCode = FaultCode, Notes = Notes, Equipment = Equipment, ClientToken = ClientToken)
  output <- .lookoutequipment$create_label_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$create_label <- lookoutequipment_create_label

#' Creates a group of labels
#'
#' @description
#' Creates a group of labels.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_create_label_group/](https://www.paws-r-sdk.com/docs/lookoutequipment_create_label_group/) for full documentation.
#'
#' @param LabelGroupName &#91;required&#93; Names a group of labels.
#' 
#' Data in this field will be retained for service usage. Follow best
#' practices for the security of your data.
#' @param FaultCodes The acceptable fault codes (indicating the type of anomaly associated
#' with the label) that can be used with this label group.
#' 
#' Data in this field will be retained for service usage. Follow best
#' practices for the security of your data.
#' @param ClientToken &#91;required&#93; A unique identifier for the request to create a label group. If you do
#' not set the client request token, Lookout for Equipment generates one.
#' @param Tags Tags that provide metadata about the label group you are creating.
#' 
#' Data in this field will be retained for service usage. Follow best
#' practices for the security of your data.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_create_label_group
lookoutequipment_create_label_group <- function(LabelGroupName, FaultCodes = NULL, ClientToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateLabelGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$create_label_group_input(LabelGroupName = LabelGroupName, FaultCodes = FaultCodes, ClientToken = ClientToken, Tags = Tags)
  output <- .lookoutequipment$create_label_group_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$create_label_group <- lookoutequipment_create_label_group

#' Creates an ML model for data inference
#'
#' @description
#' Creates an ML model for data inference.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_create_model/](https://www.paws-r-sdk.com/docs/lookoutequipment_create_model/) for full documentation.
#'
#' @param ModelName &#91;required&#93; The name for the ML model to be created.
#' @param DatasetName &#91;required&#93; The name of the dataset for the ML model being created.
#' @param DatasetSchema The data schema for the ML model being created.
#' @param LabelsInputConfiguration The input configuration for the labels being used for the ML model
#' that's being created.
#' @param ClientToken &#91;required&#93; A unique identifier for the request. If you do not set the client
#' request token, Amazon Lookout for Equipment generates one.
#' @param TrainingDataStartTime Indicates the time reference in the dataset that should be used to begin
#' the subset of training data for the ML model.
#' @param TrainingDataEndTime Indicates the time reference in the dataset that should be used to end
#' the subset of training data for the ML model.
#' @param EvaluationDataStartTime Indicates the time reference in the dataset that should be used to begin
#' the subset of evaluation data for the ML model.
#' @param EvaluationDataEndTime Indicates the time reference in the dataset that should be used to end
#' the subset of evaluation data for the ML model.
#' @param RoleArn The Amazon Resource Name (ARN) of a role with permission to access the
#' data source being used to create the ML model.
#' @param DataPreProcessingConfiguration The configuration is the `TargetSamplingRate`, which is the sampling
#' rate of the data after post processing by Amazon Lookout for Equipment.
#' For example, if you provide data that has been collected at a 1 second
#' level and you want the system to resample the data at a 1 minute rate
#' before training, the `TargetSamplingRate` is 1 minute.
#' 
#' When providing a value for the `TargetSamplingRate`, you must attach the
#' prefix "PT" to the rate you want. The value for a 1 second rate is
#' therefore *PT1S*, the value for a 15 minute rate is *PT15M*, and the
#' value for a 1 hour rate is *PT1H*
#' @param ServerSideKmsKeyId Provides the identifier of the KMS key used to encrypt model data by
#' Amazon Lookout for Equipment.
#' @param Tags Any tags associated with the ML model being created.
#' @param OffCondition Indicates that the asset associated with this sensor has been shut off.
#' As long as this condition is met, Lookout for Equipment will not use
#' data from this asset for training, evaluation, or inference.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_create_model
lookoutequipment_create_model <- function(ModelName, DatasetName, DatasetSchema = NULL, LabelsInputConfiguration = NULL, ClientToken, TrainingDataStartTime = NULL, TrainingDataEndTime = NULL, EvaluationDataStartTime = NULL, EvaluationDataEndTime = NULL, RoleArn = NULL, DataPreProcessingConfiguration = NULL, ServerSideKmsKeyId = NULL, Tags = NULL, OffCondition = NULL) {
  op <- new_operation(
    name = "CreateModel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$create_model_input(ModelName = ModelName, DatasetName = DatasetName, DatasetSchema = DatasetSchema, LabelsInputConfiguration = LabelsInputConfiguration, ClientToken = ClientToken, TrainingDataStartTime = TrainingDataStartTime, TrainingDataEndTime = TrainingDataEndTime, EvaluationDataStartTime = EvaluationDataStartTime, EvaluationDataEndTime = EvaluationDataEndTime, RoleArn = RoleArn, DataPreProcessingConfiguration = DataPreProcessingConfiguration, ServerSideKmsKeyId = ServerSideKmsKeyId, Tags = Tags, OffCondition = OffCondition)
  output <- .lookoutequipment$create_model_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$create_model <- lookoutequipment_create_model

#' Deletes a dataset and associated artifacts
#'
#' @description
#' Deletes a dataset and associated artifacts. The operation will check to see if any inference scheduler or data ingestion job is currently using the dataset, and if there isn't, the dataset, its metadata, and any associated data stored in S3 will be deleted. This does not affect any models that used this dataset for training and evaluation, but does prevent it from being used in the future.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_delete_dataset/](https://www.paws-r-sdk.com/docs/lookoutequipment_delete_dataset/) for full documentation.
#'
#' @param DatasetName &#91;required&#93; The name of the dataset to be deleted.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_delete_dataset
lookoutequipment_delete_dataset <- function(DatasetName) {
  op <- new_operation(
    name = "DeleteDataset",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$delete_dataset_input(DatasetName = DatasetName)
  output <- .lookoutequipment$delete_dataset_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$delete_dataset <- lookoutequipment_delete_dataset

#' Deletes an inference scheduler that has been set up
#'
#' @description
#' Deletes an inference scheduler that has been set up. Already processed output results are not affected.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_delete_inference_scheduler/](https://www.paws-r-sdk.com/docs/lookoutequipment_delete_inference_scheduler/) for full documentation.
#'
#' @param InferenceSchedulerName &#91;required&#93; The name of the inference scheduler to be deleted.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_delete_inference_scheduler
lookoutequipment_delete_inference_scheduler <- function(InferenceSchedulerName) {
  op <- new_operation(
    name = "DeleteInferenceScheduler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$delete_inference_scheduler_input(InferenceSchedulerName = InferenceSchedulerName)
  output <- .lookoutequipment$delete_inference_scheduler_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$delete_inference_scheduler <- lookoutequipment_delete_inference_scheduler

#' Deletes a label
#'
#' @description
#' Deletes a label.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_delete_label/](https://www.paws-r-sdk.com/docs/lookoutequipment_delete_label/) for full documentation.
#'
#' @param LabelGroupName &#91;required&#93; The name of the label group that contains the label that you want to
#' delete. Data in this field will be retained for service usage. Follow
#' best practices for the security of your data.
#' @param LabelId &#91;required&#93; The ID of the label that you want to delete.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_delete_label
lookoutequipment_delete_label <- function(LabelGroupName, LabelId) {
  op <- new_operation(
    name = "DeleteLabel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$delete_label_input(LabelGroupName = LabelGroupName, LabelId = LabelId)
  output <- .lookoutequipment$delete_label_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$delete_label <- lookoutequipment_delete_label

#' Deletes a group of labels
#'
#' @description
#' Deletes a group of labels.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_delete_label_group/](https://www.paws-r-sdk.com/docs/lookoutequipment_delete_label_group/) for full documentation.
#'
#' @param LabelGroupName &#91;required&#93; The name of the label group that you want to delete. Data in this field
#' will be retained for service usage. Follow best practices for the
#' security of your data.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_delete_label_group
lookoutequipment_delete_label_group <- function(LabelGroupName) {
  op <- new_operation(
    name = "DeleteLabelGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$delete_label_group_input(LabelGroupName = LabelGroupName)
  output <- .lookoutequipment$delete_label_group_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$delete_label_group <- lookoutequipment_delete_label_group

#' Deletes an ML model currently available for Amazon Lookout for Equipment
#'
#' @description
#' Deletes an ML model currently available for Amazon Lookout for Equipment. This will prevent it from being used with an inference scheduler, even one that is already set up.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_delete_model/](https://www.paws-r-sdk.com/docs/lookoutequipment_delete_model/) for full documentation.
#'
#' @param ModelName &#91;required&#93; The name of the ML model to be deleted.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_delete_model
lookoutequipment_delete_model <- function(ModelName) {
  op <- new_operation(
    name = "DeleteModel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$delete_model_input(ModelName = ModelName)
  output <- .lookoutequipment$delete_model_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$delete_model <- lookoutequipment_delete_model

#' Provides information on a specific data ingestion job such as creation
#' time, dataset ARN, and status
#'
#' @description
#' Provides information on a specific data ingestion job such as creation time, dataset ARN, and status.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_describe_data_ingestion_job/](https://www.paws-r-sdk.com/docs/lookoutequipment_describe_data_ingestion_job/) for full documentation.
#'
#' @param JobId &#91;required&#93; The job ID of the data ingestion job.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_describe_data_ingestion_job
lookoutequipment_describe_data_ingestion_job <- function(JobId) {
  op <- new_operation(
    name = "DescribeDataIngestionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$describe_data_ingestion_job_input(JobId = JobId)
  output <- .lookoutequipment$describe_data_ingestion_job_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$describe_data_ingestion_job <- lookoutequipment_describe_data_ingestion_job

#' Provides a JSON description of the data in each time series dataset,
#' including names, column names, and data types
#'
#' @description
#' Provides a JSON description of the data in each time series dataset, including names, column names, and data types.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_describe_dataset/](https://www.paws-r-sdk.com/docs/lookoutequipment_describe_dataset/) for full documentation.
#'
#' @param DatasetName &#91;required&#93; The name of the dataset to be described.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_describe_dataset
lookoutequipment_describe_dataset <- function(DatasetName) {
  op <- new_operation(
    name = "DescribeDataset",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$describe_dataset_input(DatasetName = DatasetName)
  output <- .lookoutequipment$describe_dataset_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$describe_dataset <- lookoutequipment_describe_dataset

#' Specifies information about the inference scheduler being used,
#' including name, model, status, and associated metadata
#'
#' @description
#' Specifies information about the inference scheduler being used, including name, model, status, and associated metadata
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_describe_inference_scheduler/](https://www.paws-r-sdk.com/docs/lookoutequipment_describe_inference_scheduler/) for full documentation.
#'
#' @param InferenceSchedulerName &#91;required&#93; The name of the inference scheduler being described.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_describe_inference_scheduler
lookoutequipment_describe_inference_scheduler <- function(InferenceSchedulerName) {
  op <- new_operation(
    name = "DescribeInferenceScheduler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$describe_inference_scheduler_input(InferenceSchedulerName = InferenceSchedulerName)
  output <- .lookoutequipment$describe_inference_scheduler_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$describe_inference_scheduler <- lookoutequipment_describe_inference_scheduler

#' Returns the name of the label
#'
#' @description
#' Returns the name of the label.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_describe_label/](https://www.paws-r-sdk.com/docs/lookoutequipment_describe_label/) for full documentation.
#'
#' @param LabelGroupName &#91;required&#93; Returns the name of the group containing the label.
#' @param LabelId &#91;required&#93; Returns the ID of the label.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_describe_label
lookoutequipment_describe_label <- function(LabelGroupName, LabelId) {
  op <- new_operation(
    name = "DescribeLabel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$describe_label_input(LabelGroupName = LabelGroupName, LabelId = LabelId)
  output <- .lookoutequipment$describe_label_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$describe_label <- lookoutequipment_describe_label

#' Returns information about the label group
#'
#' @description
#' Returns information about the label group.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_describe_label_group/](https://www.paws-r-sdk.com/docs/lookoutequipment_describe_label_group/) for full documentation.
#'
#' @param LabelGroupName &#91;required&#93; Returns the name of the label group.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_describe_label_group
lookoutequipment_describe_label_group <- function(LabelGroupName) {
  op <- new_operation(
    name = "DescribeLabelGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$describe_label_group_input(LabelGroupName = LabelGroupName)
  output <- .lookoutequipment$describe_label_group_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$describe_label_group <- lookoutequipment_describe_label_group

#' Provides a JSON containing the overall information about a specific ML
#' model, including model name and ARN, dataset, training and evaluation
#' information, status, and so on
#'
#' @description
#' Provides a JSON containing the overall information about a specific ML model, including model name and ARN, dataset, training and evaluation information, status, and so on.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_describe_model/](https://www.paws-r-sdk.com/docs/lookoutequipment_describe_model/) for full documentation.
#'
#' @param ModelName &#91;required&#93; The name of the ML model to be described.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_describe_model
lookoutequipment_describe_model <- function(ModelName) {
  op <- new_operation(
    name = "DescribeModel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$describe_model_input(ModelName = ModelName)
  output <- .lookoutequipment$describe_model_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$describe_model <- lookoutequipment_describe_model

#' Provides a list of all data ingestion jobs, including dataset name and
#' ARN, S3 location of the input data, status, and so on
#'
#' @description
#' Provides a list of all data ingestion jobs, including dataset name and ARN, S3 location of the input data, status, and so on.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_list_data_ingestion_jobs/](https://www.paws-r-sdk.com/docs/lookoutequipment_list_data_ingestion_jobs/) for full documentation.
#'
#' @param DatasetName The name of the dataset being used for the data ingestion job.
#' @param NextToken An opaque pagination token indicating where to continue the listing of
#' data ingestion jobs.
#' @param MaxResults Specifies the maximum number of data ingestion jobs to list.
#' @param Status Indicates the status of the data ingestion job.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_list_data_ingestion_jobs
lookoutequipment_list_data_ingestion_jobs <- function(DatasetName = NULL, NextToken = NULL, MaxResults = NULL, Status = NULL) {
  op <- new_operation(
    name = "ListDataIngestionJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$list_data_ingestion_jobs_input(DatasetName = DatasetName, NextToken = NextToken, MaxResults = MaxResults, Status = Status)
  output <- .lookoutequipment$list_data_ingestion_jobs_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$list_data_ingestion_jobs <- lookoutequipment_list_data_ingestion_jobs

#' Lists all datasets currently available in your account, filtering on the
#' dataset name
#'
#' @description
#' Lists all datasets currently available in your account, filtering on the dataset name.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_list_datasets/](https://www.paws-r-sdk.com/docs/lookoutequipment_list_datasets/) for full documentation.
#'
#' @param NextToken An opaque pagination token indicating where to continue the listing of
#' datasets.
#' @param MaxResults Specifies the maximum number of datasets to list.
#' @param DatasetNameBeginsWith The beginning of the name of the datasets to be listed.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_list_datasets
lookoutequipment_list_datasets <- function(NextToken = NULL, MaxResults = NULL, DatasetNameBeginsWith = NULL) {
  op <- new_operation(
    name = "ListDatasets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$list_datasets_input(NextToken = NextToken, MaxResults = MaxResults, DatasetNameBeginsWith = DatasetNameBeginsWith)
  output <- .lookoutequipment$list_datasets_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$list_datasets <- lookoutequipment_list_datasets

#' Lists all inference events that have been found for the specified
#' inference scheduler
#'
#' @description
#' Lists all inference events that have been found for the specified inference scheduler.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_list_inference_events/](https://www.paws-r-sdk.com/docs/lookoutequipment_list_inference_events/) for full documentation.
#'
#' @param NextToken An opaque pagination token indicating where to continue the listing of
#' inference events.
#' @param MaxResults Specifies the maximum number of inference events to list.
#' @param InferenceSchedulerName &#91;required&#93; The name of the inference scheduler for the inference events listed.
#' @param IntervalStartTime &#91;required&#93; Lookout for Equipment will return all the inference events with an end
#' time equal to or greater than the start time given.
#' @param IntervalEndTime &#91;required&#93; Returns all the inference events with an end start time equal to or
#' greater than less than the end time given
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_list_inference_events
lookoutequipment_list_inference_events <- function(NextToken = NULL, MaxResults = NULL, InferenceSchedulerName, IntervalStartTime, IntervalEndTime) {
  op <- new_operation(
    name = "ListInferenceEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$list_inference_events_input(NextToken = NextToken, MaxResults = MaxResults, InferenceSchedulerName = InferenceSchedulerName, IntervalStartTime = IntervalStartTime, IntervalEndTime = IntervalEndTime)
  output <- .lookoutequipment$list_inference_events_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$list_inference_events <- lookoutequipment_list_inference_events

#' Lists all inference executions that have been performed by the specified
#' inference scheduler
#'
#' @description
#' Lists all inference executions that have been performed by the specified inference scheduler.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_list_inference_executions/](https://www.paws-r-sdk.com/docs/lookoutequipment_list_inference_executions/) for full documentation.
#'
#' @param NextToken An opaque pagination token indicating where to continue the listing of
#' inference executions.
#' @param MaxResults Specifies the maximum number of inference executions to list.
#' @param InferenceSchedulerName &#91;required&#93; The name of the inference scheduler for the inference execution listed.
#' @param DataStartTimeAfter The time reference in the inferenced dataset after which Amazon Lookout
#' for Equipment started the inference execution.
#' @param DataEndTimeBefore The time reference in the inferenced dataset before which Amazon Lookout
#' for Equipment stopped the inference execution.
#' @param Status The status of the inference execution.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_list_inference_executions
lookoutequipment_list_inference_executions <- function(NextToken = NULL, MaxResults = NULL, InferenceSchedulerName, DataStartTimeAfter = NULL, DataEndTimeBefore = NULL, Status = NULL) {
  op <- new_operation(
    name = "ListInferenceExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$list_inference_executions_input(NextToken = NextToken, MaxResults = MaxResults, InferenceSchedulerName = InferenceSchedulerName, DataStartTimeAfter = DataStartTimeAfter, DataEndTimeBefore = DataEndTimeBefore, Status = Status)
  output <- .lookoutequipment$list_inference_executions_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$list_inference_executions <- lookoutequipment_list_inference_executions

#' Retrieves a list of all inference schedulers currently available for
#' your account
#'
#' @description
#' Retrieves a list of all inference schedulers currently available for your account.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_list_inference_schedulers/](https://www.paws-r-sdk.com/docs/lookoutequipment_list_inference_schedulers/) for full documentation.
#'
#' @param NextToken An opaque pagination token indicating where to continue the listing of
#' inference schedulers.
#' @param MaxResults Specifies the maximum number of inference schedulers to list.
#' @param InferenceSchedulerNameBeginsWith The beginning of the name of the inference schedulers to be listed.
#' @param ModelName The name of the ML model used by the inference scheduler to be listed.
#' @param Status Specifies the current status of the inference schedulers to list.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_list_inference_schedulers
lookoutequipment_list_inference_schedulers <- function(NextToken = NULL, MaxResults = NULL, InferenceSchedulerNameBeginsWith = NULL, ModelName = NULL, Status = NULL) {
  op <- new_operation(
    name = "ListInferenceSchedulers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$list_inference_schedulers_input(NextToken = NextToken, MaxResults = MaxResults, InferenceSchedulerNameBeginsWith = InferenceSchedulerNameBeginsWith, ModelName = ModelName, Status = Status)
  output <- .lookoutequipment$list_inference_schedulers_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$list_inference_schedulers <- lookoutequipment_list_inference_schedulers

#' Returns a list of the label groups
#'
#' @description
#' Returns a list of the label groups.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_list_label_groups/](https://www.paws-r-sdk.com/docs/lookoutequipment_list_label_groups/) for full documentation.
#'
#' @param LabelGroupNameBeginsWith The beginning of the name of the label groups to be listed.
#' @param NextToken An opaque pagination token indicating where to continue the listing of
#' label groups.
#' @param MaxResults Specifies the maximum number of label groups to list.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_list_label_groups
lookoutequipment_list_label_groups <- function(LabelGroupNameBeginsWith = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListLabelGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$list_label_groups_input(LabelGroupNameBeginsWith = LabelGroupNameBeginsWith, NextToken = NextToken, MaxResults = MaxResults)
  output <- .lookoutequipment$list_label_groups_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$list_label_groups <- lookoutequipment_list_label_groups

#' Provides a list of labels
#'
#' @description
#' Provides a list of labels.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_list_labels/](https://www.paws-r-sdk.com/docs/lookoutequipment_list_labels/) for full documentation.
#'
#' @param LabelGroupName &#91;required&#93; Retruns the name of the label group.
#' @param IntervalStartTime Returns all the labels with a end time equal to or later than the start
#' time given.
#' @param IntervalEndTime Returns all labels with a start time earlier than the end time given.
#' @param FaultCode Returns labels with a particular fault code.
#' @param Equipment Lists the labels that pertain to a particular piece of equipment.
#' @param NextToken An opaque pagination token indicating where to continue the listing of
#' label groups.
#' @param MaxResults Specifies the maximum number of labels to list.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_list_labels
lookoutequipment_list_labels <- function(LabelGroupName, IntervalStartTime = NULL, IntervalEndTime = NULL, FaultCode = NULL, Equipment = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListLabels",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$list_labels_input(LabelGroupName = LabelGroupName, IntervalStartTime = IntervalStartTime, IntervalEndTime = IntervalEndTime, FaultCode = FaultCode, Equipment = Equipment, NextToken = NextToken, MaxResults = MaxResults)
  output <- .lookoutequipment$list_labels_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$list_labels <- lookoutequipment_list_labels

#' Generates a list of all models in the account, including model name and
#' ARN, dataset, and status
#'
#' @description
#' Generates a list of all models in the account, including model name and ARN, dataset, and status.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_list_models/](https://www.paws-r-sdk.com/docs/lookoutequipment_list_models/) for full documentation.
#'
#' @param NextToken An opaque pagination token indicating where to continue the listing of
#' ML models.
#' @param MaxResults Specifies the maximum number of ML models to list.
#' @param Status The status of the ML model.
#' @param ModelNameBeginsWith The beginning of the name of the ML models being listed.
#' @param DatasetNameBeginsWith The beginning of the name of the dataset of the ML models to be listed.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_list_models
lookoutequipment_list_models <- function(NextToken = NULL, MaxResults = NULL, Status = NULL, ModelNameBeginsWith = NULL, DatasetNameBeginsWith = NULL) {
  op <- new_operation(
    name = "ListModels",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$list_models_input(NextToken = NextToken, MaxResults = MaxResults, Status = Status, ModelNameBeginsWith = ModelNameBeginsWith, DatasetNameBeginsWith = DatasetNameBeginsWith)
  output <- .lookoutequipment$list_models_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$list_models <- lookoutequipment_list_models

#' Lists statistics about the data collected for each of the sensors that
#' have been successfully ingested in the particular dataset
#'
#' @description
#' Lists statistics about the data collected for each of the sensors that have been successfully ingested in the particular dataset. Can also be used to retreive Sensor Statistics for a previous ingestion job.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_list_sensor_statistics/](https://www.paws-r-sdk.com/docs/lookoutequipment_list_sensor_statistics/) for full documentation.
#'
#' @param DatasetName &#91;required&#93; The name of the dataset associated with the list of Sensor Statistics.
#' @param IngestionJobId The ingestion job id associated with the list of Sensor Statistics. To
#' get sensor statistics for a particular ingestion job id, both dataset
#' name and ingestion job id must be submitted as inputs.
#' @param MaxResults Specifies the maximum number of sensors for which to retrieve
#' statistics.
#' @param NextToken An opaque pagination token indicating where to continue the listing of
#' sensor statistics.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_list_sensor_statistics
lookoutequipment_list_sensor_statistics <- function(DatasetName, IngestionJobId = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListSensorStatistics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$list_sensor_statistics_input(DatasetName = DatasetName, IngestionJobId = IngestionJobId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .lookoutequipment$list_sensor_statistics_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$list_sensor_statistics <- lookoutequipment_list_sensor_statistics

#' Lists all the tags for a specified resource, including key and value
#'
#' @description
#' Lists all the tags for a specified resource, including key and value.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/lookoutequipment_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource (such as the dataset or
#' model) that is the focus of the
#' [`list_tags_for_resource`][lookoutequipment_list_tags_for_resource]
#' operation.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_list_tags_for_resource
lookoutequipment_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .lookoutequipment$list_tags_for_resource_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$list_tags_for_resource <- lookoutequipment_list_tags_for_resource

#' Starts a data ingestion job
#'
#' @description
#' Starts a data ingestion job. Amazon Lookout for Equipment returns the job status.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_start_data_ingestion_job/](https://www.paws-r-sdk.com/docs/lookoutequipment_start_data_ingestion_job/) for full documentation.
#'
#' @param DatasetName &#91;required&#93; The name of the dataset being used by the data ingestion job.
#' @param IngestionInputConfiguration &#91;required&#93; Specifies information for the input data for the data ingestion job,
#' including dataset S3 location.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of a role with permission to access the
#' data source for the data ingestion job.
#' @param ClientToken &#91;required&#93; A unique identifier for the request. If you do not set the client
#' request token, Amazon Lookout for Equipment generates one.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_start_data_ingestion_job
lookoutequipment_start_data_ingestion_job <- function(DatasetName, IngestionInputConfiguration, RoleArn, ClientToken) {
  op <- new_operation(
    name = "StartDataIngestionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$start_data_ingestion_job_input(DatasetName = DatasetName, IngestionInputConfiguration = IngestionInputConfiguration, RoleArn = RoleArn, ClientToken = ClientToken)
  output <- .lookoutequipment$start_data_ingestion_job_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$start_data_ingestion_job <- lookoutequipment_start_data_ingestion_job

#' Starts an inference scheduler
#'
#' @description
#' Starts an inference scheduler.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_start_inference_scheduler/](https://www.paws-r-sdk.com/docs/lookoutequipment_start_inference_scheduler/) for full documentation.
#'
#' @param InferenceSchedulerName &#91;required&#93; The name of the inference scheduler to be started.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_start_inference_scheduler
lookoutequipment_start_inference_scheduler <- function(InferenceSchedulerName) {
  op <- new_operation(
    name = "StartInferenceScheduler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$start_inference_scheduler_input(InferenceSchedulerName = InferenceSchedulerName)
  output <- .lookoutequipment$start_inference_scheduler_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$start_inference_scheduler <- lookoutequipment_start_inference_scheduler

#' Stops an inference scheduler
#'
#' @description
#' Stops an inference scheduler.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_stop_inference_scheduler/](https://www.paws-r-sdk.com/docs/lookoutequipment_stop_inference_scheduler/) for full documentation.
#'
#' @param InferenceSchedulerName &#91;required&#93; The name of the inference scheduler to be stopped.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_stop_inference_scheduler
lookoutequipment_stop_inference_scheduler <- function(InferenceSchedulerName) {
  op <- new_operation(
    name = "StopInferenceScheduler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$stop_inference_scheduler_input(InferenceSchedulerName = InferenceSchedulerName)
  output <- .lookoutequipment$stop_inference_scheduler_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$stop_inference_scheduler <- lookoutequipment_stop_inference_scheduler

#' Associates a given tag to a resource in your account
#'
#' @description
#' Associates a given tag to a resource in your account. A tag is a key-value pair which can be added to an Amazon Lookout for Equipment resource as metadata. Tags can be used for organizing your resources as well as helping you to search and filter by tag. Multiple tags can be added to a resource, either when you create it, or later. Up to 50 tags can be associated with each resource.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_tag_resource/](https://www.paws-r-sdk.com/docs/lookoutequipment_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the specific resource to which the tag
#' should be associated.
#' @param Tags &#91;required&#93; The tag or tags to be associated with a specific resource. Both the tag
#' key and value are specified.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_tag_resource
lookoutequipment_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .lookoutequipment$tag_resource_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$tag_resource <- lookoutequipment_tag_resource

#' Removes a specific tag from a given resource
#'
#' @description
#' Removes a specific tag from a given resource. The tag is specified by its key.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_untag_resource/](https://www.paws-r-sdk.com/docs/lookoutequipment_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to which the tag is
#' currently associated.
#' @param TagKeys &#91;required&#93; Specifies the key of the tag to be removed from a specified resource.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_untag_resource
lookoutequipment_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .lookoutequipment$untag_resource_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$untag_resource <- lookoutequipment_untag_resource

#' Updates an inference scheduler
#'
#' @description
#' Updates an inference scheduler.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_update_inference_scheduler/](https://www.paws-r-sdk.com/docs/lookoutequipment_update_inference_scheduler/) for full documentation.
#'
#' @param InferenceSchedulerName &#91;required&#93; The name of the inference scheduler to be updated.
#' @param DataDelayOffsetInMinutes A period of time (in minutes) by which inference on the data is delayed
#' after the data starts. For instance, if you select an offset delay time
#' of five minutes, inference will not begin on the data until the first
#' data measurement after the five minute mark. For example, if five
#' minutes is selected, the inference scheduler will wake up at the
#' configured frequency with the additional five minute delay time to check
#' the customer S3 bucket. The customer can upload data at the same
#' frequency and they don't need to stop and restart the scheduler when
#' uploading new data.
#' @param DataUploadFrequency How often data is uploaded to the source S3 bucket for the input data.
#' The value chosen is the length of time between data uploads. For
#' instance, if you select 5 minutes, Amazon Lookout for Equipment will
#' upload the real-time data to the source bucket once every 5 minutes.
#' This frequency also determines how often Amazon Lookout for Equipment
#' starts a scheduled inference on your data. In this example, it starts
#' once every 5 minutes.
#' @param DataInputConfiguration Specifies information for the input data for the inference scheduler,
#' including delimiter, format, and dataset location.
#' @param DataOutputConfiguration Specifies information for the output results from the inference
#' scheduler, including the output S3 location.
#' @param RoleArn The Amazon Resource Name (ARN) of a role with permission to access the
#' data source for the inference scheduler.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_update_inference_scheduler
lookoutequipment_update_inference_scheduler <- function(InferenceSchedulerName, DataDelayOffsetInMinutes = NULL, DataUploadFrequency = NULL, DataInputConfiguration = NULL, DataOutputConfiguration = NULL, RoleArn = NULL) {
  op <- new_operation(
    name = "UpdateInferenceScheduler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$update_inference_scheduler_input(InferenceSchedulerName = InferenceSchedulerName, DataDelayOffsetInMinutes = DataDelayOffsetInMinutes, DataUploadFrequency = DataUploadFrequency, DataInputConfiguration = DataInputConfiguration, DataOutputConfiguration = DataOutputConfiguration, RoleArn = RoleArn)
  output <- .lookoutequipment$update_inference_scheduler_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$update_inference_scheduler <- lookoutequipment_update_inference_scheduler

#' Updates the label group
#'
#' @description
#' Updates the label group.
#'
#' See [https://www.paws-r-sdk.com/docs/lookoutequipment_update_label_group/](https://www.paws-r-sdk.com/docs/lookoutequipment_update_label_group/) for full documentation.
#'
#' @param LabelGroupName &#91;required&#93; The name of the label group to be updated.
#' @param FaultCodes Updates the code indicating the type of anomaly associated with the
#' label.
#' 
#' Data in this field will be retained for service usage. Follow best
#' practices for the security of your data.
#'
#' @keywords internal
#'
#' @rdname lookoutequipment_update_label_group
lookoutequipment_update_label_group <- function(LabelGroupName, FaultCodes = NULL) {
  op <- new_operation(
    name = "UpdateLabelGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lookoutequipment$update_label_group_input(LabelGroupName = LabelGroupName, FaultCodes = FaultCodes)
  output <- .lookoutequipment$update_label_group_output()
  config <- get_config()
  svc <- .lookoutequipment$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutequipment$operations$update_label_group <- lookoutequipment_update_label_group
